/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.activitycontextnamingfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.facilities.activitycontextnamingfacility.ActivityContextNamingFacilityTestACI;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.Level;
import javax.slee.facilities.NameAlreadyBoundException;
import javax.slee.facilities.NameNotBoundException;

public abstract class ActivityContextNamingFacilityTestSbb
extends BaseTCKSbb {
    private static final String JNDI_ACNF_NAME = "java:comp/env/slee/facilities/activitycontextnaming";
    private boolean result = false;
    private String message;
    private String testName;
    private int failedAssertionID = -1;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.testName = (String)event.getMessage();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received " + this.testName + " message", null);
            if (this.testName.equals("jndi")) {
                this.doJNDITest();
            } else if (this.testName.equals("bind")) {
                this.doBindTest(aci);
            } else if (this.testName.equals("unbind")) {
                this.doUnbindTest(aci);
            } else if (this.testName.equals("lookup")) {
                this.doLookupTest(aci);
            }
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.testName);
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }

    private void doJNDITest() throws Exception {
        ActivityContextNamingFacility acnf = this.getACNF();
        if (acnf != null) {
            this.setResultPassed("Found ActivityContextNamingFacility object in JNDI at java:comp/env/slee/facilities/activitycontextnaming");
        } else {
            this.setResultFailed(1413, "Could not find ActivityContextNamingFacility object in JNDI at java:comp/env/slee/facilities/activitycontextnaming");
        }
    }

    private void doBindTest(ActivityContextInterface aci) throws Exception {
        ActivityContextNamingFacility acnf = this.getACNF();
        try {
            acnf.bind(null, "noddy");
            this.setResultFailed(1360, "bind with null aci did not throw a NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1360, "bind with null aci threw unexpected exception: " + e);
            return;
        }
        try {
            acnf.bind(aci, null);
            this.setResultFailed(1360, "bind with null name did not throw a NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1360, "bind with null name threw unexpected exception: " + e);
            return;
        }
        try {
            acnf.bind(aci, "");
            this.setResultFailed(1362, "bind with zero-length name did not throw a IllegalArgumentException");
            return;
        }
        catch (IllegalArgumentException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected IllegalArgumentExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1362, "bind with zero-length name threw unexpected exception: " + e);
            return;
        }
        acnf.bind(aci, "foo");
        acnf.bind(aci, "bar");
        try {
            acnf.bind(aci, "foo");
            this.setResultFailed(1361, "bind to already bound name did not throw a NameAlreadyBoundException");
            return;
        }
        catch (NameAlreadyBoundException nabe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NameAlreadyBoundExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1361, "bind to already bound name threw unexpected exception: " + e);
            return;
        }
        acnf.unbind("foo");
        acnf.unbind("bar");
        this.setResultPassed("ActivityContextNamingFacility.bind() tests passed");
    }

    private void doUnbindTest(ActivityContextInterface aci) throws Exception {
        ActivityContextNamingFacility acnf = this.getACNF();
        try {
            acnf.unbind(null);
            this.setResultFailed(1366, "unbind with null name did not throw a NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1366, "unbind with null name threw unexpected exception: " + e);
            return;
        }
        try {
            acnf.unbind("name-does-not-exist");
            this.setResultFailed(1367, "bind with unbound name did not throw a NameNotBoundException");
            return;
        }
        catch (NameNotBoundException nnbe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NameNotBoundExcepion", null);
        }
        catch (Exception e) {
            this.setResultFailed(1367, "unbind with unbound name threw unexpected exception: " + e);
            return;
        }
        acnf.bind(aci, "testname");
        try {
            acnf.bind(aci, "testname");
            this.setResultFailed(1361, "bind with already bound name did not throw a NameAlreadyBoundException");
            return;
        }
        catch (NameAlreadyBoundException nabe) {
            acnf.unbind("testname");
            try {
                acnf.bind(aci, "testname");
            }
            catch (NameAlreadyBoundException nabe2) {
                this.setResultFailed(1365, "bind with unbound name threw a NameAlreadyBoundException - unbind failed");
                return;
            }
            acnf.unbind("testname");
            this.setResultPassed("ActivityContextNamingFacillity.unbind() tests passed");
            return;
        }
    }

    private void doLookupTest(ActivityContextInterface aci) throws Exception {
        ActivityContextNamingFacility acnf = this.getACNF();
        ActivityContextInterface dummyaci = null;
        try {
            dummyaci = acnf.lookup(null);
            this.setResultFailed(1371, "lookup with null name did not throw a NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1371, "lookup with null name threw unexpected exception: " + e);
            return;
        }
        dummyaci = acnf.lookup("name-does-not-exist");
        if (dummyaci != null) {
            this.setResultFailed(1370, "lookup with unbound name did not return null");
            return;
        }
        ActivityContextNamingFacilityTestACI testaci = this.asSbbActivityContextInterface(aci);
        int key = 666;
        testaci.setKey(key);
        acnf.bind((ActivityContextInterface)testaci, "testname");
        ActivityContextNamingFacilityTestACI testaci2 = this.asSbbActivityContextInterface(acnf.lookup("testname"));
        int key2 = testaci2.getKey();
        if (key != key2) {
            this.setResultFailed(1372, "lookup did not return same aci");
            return;
        }
        acnf.unbind("testname");
        this.setResultPassed("ActivityContextNamingFacillity.lookup() tests passed");
    }

    private ActivityContextNamingFacility getACNF() throws Exception {
        ActivityContextNamingFacility acnf = null;
        try {
            acnf = (ActivityContextNamingFacility)new InitialContext().lookup(JNDI_ACNF_NAME);
        }
        catch (Exception e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, "got unexpected Exception: " + e, null);
        }
        return acnf;
    }

    public abstract ActivityContextNamingFacilityTestACI asSbbActivityContextInterface(ActivityContextInterface var1);
}

