/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;

public class Test2195Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2195;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private boolean deactivated = false;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
        this.result = new FutureResult(utils.getLog());
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        this.utils.activateServices(this.duID, true);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result", 2195);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test2195ControlActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test2195Test.this.utils.getLog().info("Received message from SBB: " + message.getMessage());
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed != null) {
                if (Test2195Test.this.deactivated) {
                    if (passed.booleanValue()) {
                        Test2195Test.this.result.setPassed();
                    } else {
                        Test2195Test.this.result.setFailed(2195, msgString);
                    }
                } else {
                    Test2195Test.this.result.setFailed(2195, "ActivityEndEvent received before the service was deactivated by the test - possibly due to test timeout.");
                }
                return;
            }
            try {
                SleeManagementMBeanProxy proxy = Test2195Test.this.utils.getSleeManagementMBeanProxy();
                Test2195Test.this.deactivated = true;
                proxy.stop();
            }
            catch (Exception e) {
                Test2195Test.this.result.setError(e);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2195Test.this.utils.getLog().warning("Received exception from SBB.");
            Test2195Test.this.utils.getLog().warning(e);
            Test2195Test.this.result.setError(e);
        }
    }
}

