/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testsuite.events.servicestarted.QueuingSleeStateListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class Test2185Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2185;
    private DeployableUnitID duID;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private int count = 0;
    private QueuingSleeStateListener stateListener;
    private SleeManagementMBeanProxy management;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.getLog());
        this.utils().activateServices(this.duID, true);
        return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result", 2185);
    }

    public void setUp() throws Exception {
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.stateListener = new QueuingSleeStateListener(this.utils());
        this.management = this.utils().getSleeManagementMBeanProxy();
        this.management.addNotificationListener(this.stateListener, null, null);
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test2185Test.this.getLog().info("Received message from SBB: " + message.getMessage());
            if (Test2185Test.this.count == 0) {
                Test2185Test.this.count++;
                try {
                    Test2185Test.this.management.stop();
                    this.waitForStateChange(SleeState.STOPPED);
                    Test2185Test.this.management.start();
                }
                catch (Exception e) {
                    this.onException(e);
                    return;
                }
                return;
            }
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test2185Test.this.result.setPassed();
            } else {
                Test2185Test.this.result.setFailed(2185, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2185Test.this.getLog().warning("Received exception from SBB.");
            Test2185Test.this.getLog().warning(e);
            Test2185Test.this.result.setError(e);
        }

        private void waitForStateChange(SleeState expectedState) throws Exception {
            SleeStateChangeNotification stateChange = null;
            try {
                while (stateChange == null || !stateChange.getNewState().equals((Object)expectedState)) {
                    Test2185Test.this.getLog().fine("Waiting to move to the " + expectedState + " state.");
                    stateChange = Test2185Test.this.stateListener.nextNotification();
                    Test2185Test.this.getLog().fine("SLEE has moved to the " + stateChange + " state.");
                }
            }
            catch (OperationTimedOutException e) {
                this.onException(e);
            }
        }
    }
}

