/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.maskreadystate;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import javax.management.ObjectName;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String PROFILE_SPEC_DU_PATH_PARAM = "profileSpecDUPath";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult futureResult;
    private ProfileProvisioningMBeanProxy profileProvisioningMBeanProxy;
    private boolean tableCreated;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.futureResult = new FutureResult(this.utils.getLog());
        String activityName = "MaskEventReadyStateTestActivity";
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        this.utils.getLog().fine("Creating activity");
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils.getLog().info("Firing event");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils.getLog().fine("Test thread is waiting for test result");
        return this.futureResult.waitForResultOrFail(this.utils.getTestTimeout(), "Event must be delivered", 713);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String serviceDUPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils.install(serviceDUPath);
        this.utils.activateServices(duID, true);
        this.utils.getLog().fine("Installing profile spec");
        String profileSpecDUPath = this.utils.getTestParams().getProperty(PROFILE_SPEC_DU_PATH_PARAM);
        this.utils.install(profileSpecDUPath);
        this.utils.getLog().fine("Creating a profile table, to create a profile table activity");
        ObjectName profileProvisioningName = this.utils.getSleeManagementMBeanProxy().getProfileProvisioningMBean();
        this.profileProvisioningMBeanProxy = this.utils.getMBeanProxyFactory().createProfileProvisioningMBeanProxy(profileProvisioningName);
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        this.utils.getLog().info("Creating profile table: MaskReadyStateTest-ProfileTable");
        this.profileProvisioningMBeanProxy.createProfileTable(profileSpecID, "MaskReadyStateTest-ProfileTable");
        this.tableCreated = true;
    }

    public void tearDown() throws Exception {
        if (this.profileProvisioningMBeanProxy != null && this.tableCreated) {
            try {
                this.utils.getLog().fine("Removing profile table");
                this.profileProvisioningMBeanProxy.removeProfileTable("MaskReadyStateTest-ProfileTable");
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
        }
        this.utils.getLog().fine("Ending and purging activities");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service and profile spec");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test.this.utils.getLog().info("Received result from SBB");
            Test.this.futureResult.setResult(TCKTestResult.fromExported(message.getMessage()));
        }

        public void onException(Exception exception) throws RemoteException {
            Test.this.utils.getLog().warning("Received Exception from SBB or resource:");
            Test.this.utils.getLog().warning(exception);
            Test.this.futureResult.setError(exception);
        }
    }
}

