/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.maskonattach;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import javax.slee.management.DeployableUnitID;

public class Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        String activityName = "MaskOnAttachTestActivity";
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        this.utils.getLog().fine("Creating activity");
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils.getLog().info("Firing event");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID, null);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", activityID, null);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", activityID, null);
        this.utils.getLog().fine("Test thread is waiting for test result");
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Event must be delivered", 717);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils.install(duPath);
        this.utils.activateServices(duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test.this.utils.getLog().info("Received message from SBB");
            String[] messageData = (String[])message.getMessage();
            if (messageData.length != 2) {
                Test.this.result.setError("Bad response received from application in SLEE");
            }
            if ("SUCCESS".equals(messageData[0])) {
                Test.this.result.setPassed();
            } else {
                Test.this.result.setFailed(717, "SbbContext maskEvent is incorrect, message from SBB is: " + messageData[1]);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test.this.utils.getLog().warning("Received Exception from SBB or resource:");
            Test.this.utils.getLog().warning(exception);
            Test.this.result.setError(exception);
        }
    }
}

