/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventrouting;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.events.eventrouting.Test1108081Sbb;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AddressProfile11CMPProxyImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.UnrecognizedComponentException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class Test1108081Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String ADDRESS_PROFILE_TABLE = "tck.Test1108081.AddressAndProfileTestProfile";
    private static final String PROFILE_1 = "PROFILE_1";
    private static final String PROFILE_2 = "PROFILE_2";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private int expectedCount = 3;
    private int receivedCount = 0;
    private ProfileProvisioningMBeanProxy profileProxy;
    private String testName = "Test1108081";
    private ProfileSpecificationID stdAddressProfileSpecID;
    private boolean tableCreated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1108081InitialActivity");
        if (this.getTestName().equals("ADDRESSFOUND")) {
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with Address1.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_1);
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with Address2.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_2);
        } else if (this.getTestName().equals("ADDRESSNOTFOUND")) {
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with Address3.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_3);
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with Address4.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_4);
        } else if (this.getTestName().equals("NULLADDRESS")) {
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with null address.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with null address.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        } else if (this.getTestName().equals("ADDRESSFOUNDANDNOTFOUND")) {
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with null address.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_1);
            this.getLog().fine("Firing TCKResourceEventX1 on Test1108081InitialActivity with null address.");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, Test1108081Sbb.ADDRESS_3);
        } else {
            result.setError("Unexpected test name encountered during test run: " + this.getTestName());
            return;
        }
        Test1108081Test test1108081Test = this;
        synchronized (test1108081Test) {
            this.wait(25000L);
        }
        if (this.getTestName().equals("ADDRESSFOUND")) {
            if (this.receivedCount == this.expectedCount) {
                result.setPassed();
            } else {
                result.setFailed(1113081, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected " + this.expectedCount + ", received " + this.receivedCount + ")");
            }
        } else if (this.getTestName().equals("NULLADDRESS") || this.getTestName().equals("ADDRESSFOUNDANDNOTFOUND")) {
            this.expectedCount = 2;
            if (this.receivedCount == this.expectedCount) {
                result.setPassed();
            } else {
                result.setFailed(1113081, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected " + this.expectedCount + ", received " + this.receivedCount + ")");
            }
        } else if (this.getTestName().equals("ADDRESSNOTFOUND")) {
            this.expectedCount = 0;
            if (this.receivedCount == this.expectedCount) {
                result.setPassed();
            } else {
                result.setFailed(1113082, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected " + this.expectedCount + ", received " + this.receivedCount + ")");
            }
        } else {
            result.setError("Unexpected test name encountered during test run: " + this.getTestName());
            return;
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.testName = this.getTestName();
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE_DU_PATH_PARAM, true);
        this.profileProxy = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
        this.profileProxy.createProfileTable(this.getStdAddressProfileSpecID(), ADDRESS_PROFILE_TABLE);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_1, Test1108081Sbb.ADDRESS_1);
        this.setupAddressProfile(ADDRESS_PROFILE_TABLE, PROFILE_2, Test1108081Sbb.ADDRESS_2);
        this.tableCreated = true;
    }

    public String getTestName() {
        String testName = "testName";
        return this.utils().getTestParams().getProperty(testName);
    }

    public void tearDown() throws Exception {
        if (this.profileProxy != null && this.tableCreated) {
            try {
                this.getLog().fine("Removing profile table");
                this.profileProxy.removeProfileTable(ADDRESS_PROFILE_TABLE);
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        super.tearDown();
    }

    private void setupAddressProfile(String tableName, String profileName, Address address) throws Exception {
        ObjectName objectName = this.profileProxy.createProfile(tableName, profileName);
        AddressProfile11CMPProxyImpl addressProfileProxy = new AddressProfile11CMPProxyImpl(objectName, this.utils().getMBeanFacade());
        addressProfileProxy.editProfile();
        addressProfileProxy.setAddress(address);
        addressProfileProxy.commitProfile();
    }

    public ProfileSpecificationID getStdAddressProfileSpecID() throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        if (this.stdAddressProfileSpecID == null) {
            this.stdAddressProfileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("AddressProfileSpec", "javax.slee", "1.1");
            if (this.stdAddressProfileSpecID == null) {
                throw new TCKTestErrorException("Standard address profile specification not found");
            }
        }
        return this.stdAddressProfileSpecID;
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108081Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108081Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108081Test.this.receivedCount++;
            }
            catch (TCKTestFailureException ex) {
                Test1108081Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108081Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108081Test.this.getLog().warning(exception);
            Test1108081Test.this.result.setError(exception);
        }
    }
}

