/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108043Sbb2
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108043Sbb2:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2A = "Test1108043Sbb2:I got TCKResourceEventX2 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2B = "Test1108043Sbb2:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108043Sbb2:I got TCKResourceEventX3 on ActivityB";
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
            this.setPassedX1(true);
            if (!this.getPassed()) {
                this.sendResultToTCK("Test1108043Test", false, "SBB2:onTCKResourceEventX1-ERROR: When the transaction does not commit in the first SBB, then the Event Context will not be resumed, and the event TCKResourceEventX1 on ActivityA should not been delivered to the second SBB.", 1108043);
            }
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            TCKActivity activity = (TCKActivity)context.getActivityContextInterface().getActivity();
            TCKActivityID activityID = activity.getID();
            if (activityID.getName().equals("Test1108043Test-ActivityA")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2A);
                this.setPassedX2(true);
                if (!this.getPassed()) {
                    this.sendResultToTCK("Test1108043Test", false, "SBB2:onTCKResourceEventX2-ERROR: When the transaction does not commit in the first SBB, then the Event Context will not be resumed, and the event TCKResourceEventX2 on ActivityA should not been delivered to the second SBB.", 1108043);
                }
                return;
            }
            if (activityID.getName().equals("Test1108043Test-ActivityB")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2B);
                this.setPassed(true);
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            if (!this.getPassedX1() && !this.getPassedX2()) {
                this.sendResultToTCK("Test1108043Test", true, "If the transaction does not commit then the Event Context will not be resumed and therefore the event will not be delivered to any other eligible SBB entities.", 1108043);
            } else {
                this.sendResultToTCK("Test1108043Test", false, "SBB2:onTCKResourceEventX3-ERROR: When the transaction does not commit in the first SBB, then the Event Context will not be resumed, and the event should not been delivered to the second SBB.", 1108043);
            }
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setPassedX1(boolean var1);

    public abstract boolean getPassedX1();

    public abstract void setPassedX2(boolean var1);

    public abstract boolean getPassedX2();

    public abstract void setPassed(boolean var1);

    public abstract boolean getPassed();
}

