/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108040Sbb
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108040Sbb:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2A = "Test1108040Sbb:I got TCKResourceEventX2 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2B = "Test1108040Sbb:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108040Sbb:I got TCKResourceEventX3 on ActivityA";
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Prior to call EventContext.suspendDelivery() Test1108040Sbb:I got TCKResourceEventX1 on ActivityA");
            this.setPassedX1(false);
            this.setPassedX2(false);
            this.setEventContext(context);
            context.suspendDelivery();
            this.tracer.info("After called EventContext.suspendDelivery() Test1108040Sbb:I got TCKResourceEventX1 on ActivityA");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            TCKActivity activity = (TCKActivity)context.getActivityContextInterface().getActivity();
            TCKActivityID activityID = activity.getID();
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Sbb1:Entering onTCKResourceEventX2");
            if (activityID.getName().equals("Test1108040Test-ActivityB")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2B);
                EventContext ec = this.getEventContext();
                try {
                    if (!ec.isSuspended()) {
                        this.sendResultToTCK("Test1108040Test", false, "SBB:onTCKResourceEventX2-ERROR: The event delivery hasn't been suspended, the EventContext.isSuspended() returned false!", 1108040);
                        return;
                    }
                    ec.resumeDelivery();
                }
                catch (Exception e) {
                    this.tracer.severe("ERROR onTCKResourceEventX2, the event delivery failed to be resumed" + e.getMessage());
                    return;
                }
                this.setPassedX2(true);
            } else if (activityID.getName().equals("Test1108040Test-ActivityA")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2A);
                if (this.getPassedX2()) {
                    this.setPassedX1(true);
                }
            }
            this.tracer.info("Sbb1:Exiting onTCKResourceEventX2");
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            if (this.getPassedX1()) {
                this.sendResultToTCK("Test1108040Test", true, "The SBB entity to which the event was delivered that was not added to the SLEE delivered set when the event was suspended is now added to the event\u201a\u00c4\u00f4s delivered set.", 1108040);
            } else {
                this.sendResultToTCK("Test1108040Test", false, "Sbb did not receive TCKResourceEventX3 on ActivityA, this means the resumeDelivery method still does not resume the delivery of the event associated with this Event Context.", 1108040);
            }
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    public abstract void setPassedX1(boolean var1);

    public abstract boolean getPassedX1();

    public abstract void setPassedX2(boolean var1);

    public abstract boolean getPassedX2();
}

