/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.eventcontext;

import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.facilities.Tracer;

public abstract class Test1108039Sbb1
extends BaseTCKSbb {
    public static final String TRACE_MESSAGE_TCKResourceEventX1 = "Test1108039Sbb1:I got TCKResourceEventX1 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2A = "Test1108039Sbb1:I got TCKResourceEventX2 on ActivityA";
    public static final String TRACE_MESSAGE_TCKResourceEventX2B = "Test1108039Sbb1:I got TCKResourceEventX2 on ActivityB";
    public static final String TRACE_MESSAGE_TCKResourceEventX3 = "Test1108039Sbb1:I got TCKResourceEventX3 on ActivityA";
    private Tracer tracer = null;

    public InitialEventSelector initialEventSelector(InitialEventSelector ies) {
        ies.setCustomName("test");
        return ies;
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX1);
            this.setEventContext(context);
            context.suspendDelivery();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            TCKActivity activity = (TCKActivity)context.getActivityContextInterface().getActivity();
            TCKActivityID activityID = activity.getID();
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Sbb1:Entering onTCKResourceEventX2");
            if (activityID.getName().equals("Test1108039Test-ActivityB")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2B);
                EventContext ec = this.getEventContext();
                if (ec.isSuspended()) {
                    ec.resumeDelivery();
                }
            } else if (activityID.getName().equals("Test1108039Test-ActivityA")) {
                this.tracer.info(TRACE_MESSAGE_TCKResourceEventX2A);
                this.setPassed(true);
            }
            this.tracer.info("Sbb1:Exiting onTCKResourceEventX2");
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci, EventContext context) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info(TRACE_MESSAGE_TCKResourceEventX3);
            if (this.getPassed()) {
                this.sendResultToTCK("Test1108039Test", true, "Sbb1 received TCKResourceEventX3 on ActivityA, this means the resumeDelivery method resumed the delivery of the event associated with this Event Context.", 1108039);
            } else {
                this.sendResultToTCK("Test1108039Test", false, "SBB1:onTCKResourceEventX3-ERROR: Sbb1 did not receive TCKResourceEventX3 on ActivityA, this means the resumeDelivery method still does not resume the delivery of the event associated with this Event Context.", 1108039);
            }
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    private void sendResultToTCK(String testName, boolean result, String message, int failedAssertionID) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    public abstract void setPassed(boolean var1);

    public abstract boolean getPassed();
}

