/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.deploymentdescriptor;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import javax.slee.management.DeploymentException;

public class Test663Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String SERVICE_INVALID_DU_PATH_PARAM = "serviceInvalidDUPath";
    private static final int TEST_ID = 663;
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        String duPath;
        this.utils.getLog().fine("Installing first deployable unit.");
        try {
            duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
            this.utils.install(duPath);
        }
        catch (TCKTestErrorException e) {
            if (e.getEnclosedException().getClass().equals(DeploymentException.class)) {
                return TCKTestResult.failed(663, "Failed to install service with valid event directions");
            }
            throw e;
        }
        this.utils.getLog().fine("Deactivating and uninstalling first service.");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
        this.utils.getLog().fine("Installing second deployable unit.");
        try {
            duPath = this.utils.getTestParams().getProperty(SERVICE_INVALID_DU_PATH_PARAM);
            this.utils.install(duPath);
        }
        catch (TCKTestErrorException e) {
            if (e.getEnclosedException().getClass().equals(DeploymentException.class)) {
                return TCKTestResult.passed();
            }
            throw e;
        }
        return TCKTestResult.failed(663, "Installed service with invalid event direction.");
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

