/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename.iesInitialize;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.iesInitialize.IESInitTestEventMessageData;
import javax.slee.ActivityContextInterface;
import javax.slee.InitialEventSelector;

public abstract class IESInitialValuesTestSbb
extends BaseTCKSbb {
    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci) {
    }

    public InitialEventSelector initialEventSelectorMethod(InitialEventSelector ies) {
        try {
            TCKResourceEventX event = (TCKResourceEventX)ies.getEvent();
            if (event == null) {
                throw new TCKTestFailureException(1922, "The event variable is null");
            }
            IESInitTestEventMessageData eventMessageData = IESInitTestEventMessageData.fromExported(event.getMessage());
            this.assertEqual(757, "Address", ies.getAddress(), eventMessageData.getAddress());
            Object iesActivity = ies.getActivity();
            if (iesActivity == null || !(iesActivity instanceof TCKActivity)) {
                throw new TCKTestFailureException(756, "The Activity set in the InitialEventSelector is not the Activity on which the event was fired. InitialEventSelector activity variable: " + iesActivity);
            }
            this.assertEqual(756, "Activity", ((TCKActivity)ies.getActivity()).getID(), eventMessageData.getActivityID());
            if (ies.getCustomName() != null) {
                throw new TCKTestFailureException(758, "The custom name variable in the InitialEventSelector was not set to null. Custom name value: " + ies.getCustomName());
            }
            if (!ies.isInitialEvent()) {
                throw new TCKTestFailureException(759, "The isInitialEvent variable in the InitialEventSelector was set to false");
            }
            if (event.getEventTypeName().equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1")) {
                this.checkIsVariableSelected("ActivityContext", true, ies.isActivityContextSelected());
                this.checkIsVariableSelected("Address", true, ies.isAddressSelected());
                this.checkIsVariableSelected("AddressProfile", false, ies.isAddressProfileSelected());
                this.checkIsVariableSelected("Event", false, ies.isEventSelected());
            } else if (event.getEventTypeName().equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2")) {
                this.checkIsVariableSelected("ActivityContext", false, ies.isActivityContextSelected());
                this.checkIsVariableSelected("Address", false, ies.isAddressSelected());
                this.checkIsVariableSelected("AddressProfile", true, ies.isAddressProfileSelected());
                this.checkIsVariableSelected("Event", true, ies.isEventSelected());
            } else {
                throw new TCKTestErrorException("Received unexpected event type. Event type name=" + event.getEventTypeName());
            }
            ies.setCustomName("foo");
            ies.setInitialEvent(false);
            TCKSbbUtils.getResourceInterface().sendSbbMessage(eventMessageData.getEventID());
        }
        catch (Exception ex) {
            TCKSbbUtils.handleException(ex);
        }
        return ies;
    }

    private void assertEqual(int assertionID, String variableName, Object iesValue, Object producerValue) throws TCKTestFailureException {
        boolean equal;
        boolean bl = iesValue == null ? producerValue == null : (equal = iesValue.equals(producerValue));
        if (!equal) {
            throw new TCKTestFailureException(assertionID, variableName + " variable " + iesValue + " in InitialEventSelector does not match value given by event producer: " + producerValue);
        }
    }

    private void checkIsVariableSelected(String variableName, boolean expectedValue, boolean iesValue) throws TCKTestFailureException {
        if (expectedValue != iesValue) {
            throw new TCKTestFailureException(754, "The is" + variableName + "Selected flag was not set to the expected value in the InitialEventSelector. Expected value: " + expectedValue + "; InitialEventSelector value:" + iesValue);
        }
    }
}

