/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.convergencename.iesInitialize;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testsuite.events.convergencename.iesInitialize.IESInitTestEventMessageData;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.TCKSbbMessageFilter;
import java.rmi.RemoteException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.EventTypeID;

public class IESInitialValuesTest
extends AbstractSleeTCKTest {
    private EventTypeID x1EventTypeID;
    private EventTypeID x2EventTypeID;
    private QueuingResourceListener resourceListener;

    public void setUp() throws Exception {
        super.setUp();
        ComponentIDLookup idLookup = new ComponentIDLookup(this.utils());
        this.x1EventTypeID = idLookup.lookupEventTypeID("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "jain.slee.tck", "1.0");
        this.x2EventTypeID = idLookup.lookupEventTypeID("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "jain.slee.tck", "1.0");
        if (this.x1EventTypeID == null || this.x2EventTypeID == null) {
            throw new TCKTestErrorException("Couldn't find EventTypeID for one or more of the events. Events type names: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1,com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        }
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
    }

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("IESInitialValuesTest-Activity-1");
        this.sendMessageAndWait(activityID, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.x1EventTypeID, "1", new Address(AddressPlan.IP, "1.0.0.1"));
        activityID = this.utils().getResourceInterface().createActivity("IESInitialValuesTest-Activity-2");
        this.sendMessageAndWait(activityID, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", this.x2EventTypeID, "2", null);
        return TCKTestResult.passed();
    }

    private void sendMessageAndWait(TCKActivityID activityID, String eventTypeName, EventTypeID eventTypeID, final String eventID, Address address) throws TCKTestFailureException, TCKTestErrorException, RemoteException {
        Object eventMessage = new IESInitTestEventMessageData(eventID, eventTypeID, activityID, address).toExported();
        this.utils().getResourceInterface().fireEvent(eventTypeName, eventMessage, activityID, address);
        this.resourceListener.nextMessage(new TCKSbbMessageFilter(){

            public boolean accept(TCKSbbMessage received) {
                return received.getMessage().equals(eventID);
            }
        });
    }
}

