/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.resource.adaptor11;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceAdaptorInterface;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceEventHandler;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceFactory;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceSetupInterface;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityMap;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKMarshalerImpl;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKTransactionIDAccessImpl;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEvent;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceAdaptorSbbInterface;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceSbbInterface;
import com.opencloud.sleetck.lib.resource.sbbapi.TransactionIDAccess;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.TraceLevel;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.transaction.SleeTransactionManager;

public class TCKResourceAdaptor
extends UnicastRemoteObject
implements ResourceAdaptor,
TCKResourceAdaptorSbbInterface,
TCKResourceEventHandler {
    static final String EVENT_TYPE_VENDOR = "jain.slee.tck";
    static final String EVENT_TYPE_VERSION = "1.0";
    static final String TRACER_NAME = "jain.slee.tck.TCKResourceAdaptor";
    private transient SleeEndpoint sleeEndpoint;
    private transient SleeTransactionManager sleeTransactionManager;
    private transient EventLookupFacility eventLookupFacility;
    private transient Tracer tracer;
    private ResourceAdaptorContext context;
    private transient Registry rmiRegistry;
    private transient Map eventTypes;
    private transient TCKActivityMap activityMap;
    private transient TCKMarshalerImpl marshaler;
    private transient TCKResourceAdaptorInterface resource;
    private transient TCKResourceSbbInterface resourceSbbInterface;
    private transient TransactionIDAccess transactionIDAccess;
    private transient int rmiPort = -1;

    public void activityEnded(ActivityHandle activityHandle) {
        TCKActivity tCKActivity;
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("activityEnded(): " + activityHandle);
        }
        if ((tCKActivity = (TCKActivity)this.activityMap.getActivity((TCKActivityHandleImpl)activityHandle)) != null) {
            try {
                this.resource.onActivityContextInvalid(tCKActivity.getID());
            }
            catch (RemoteException remoteException) {
                this.tracer.severe("Caught RemoteException while calling TCKResourceAdaptorInterface:" + remoteException);
            }
        } else {
            this.tracer.severe("Received activityEnded() call for non registered activity. Activity Handle:" + activityHandle);
        }
        this.deregisterActivity((TCKActivityHandleImpl)activityHandle);
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("activityUnreferenced(): " + activityHandle);
        }
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("administrativeRemove(): " + activityHandle);
        }
    }

    public void raConfigurationUpdate(ConfigProperties configProperties) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("raConfigurationUpdate(): " + configProperties);
        }
    }

    public void raConfigure(ConfigProperties configProperties) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("raConfigure(): " + configProperties);
        }
        try {
            this.rmiPort = (Integer)configProperties.getProperty("rmiPort").getValue();
            if (this.context == null) {
                throw new IllegalStateException("configureResourceAdaptor() called before setResourceAdaptorContext()");
            }
            this.tracer.info("Creating TCK Resource Adaptor Entity");
            this.eventLookupFacility = this.context.getEventLookupFacility();
            this.sleeEndpoint = this.context.getSleeEndpoint();
            this.sleeTransactionManager = this.context.getSleeTransactionManager();
            this.tracer.info("TCK Resource Adaptor Entity created");
        }
        catch (Exception exception) {
            this.tracer.severe("Exception caught while creating the TCK Resource Adaptor", (Throwable)exception);
        }
    }

    public void raUnconfigure() {
        this.tracer.finest("raUnconfigure()");
        this.eventLookupFacility = null;
        this.sleeEndpoint = null;
        this.sleeTransactionManager = null;
        this.tracer.info("TCK Resource Adaptor Entity removed");
    }

    public void raActive() {
        this.tracer.finest("raActive()");
        this.tracer.info("Starting TCK Resource Adaptor");
        try {
            this.transactionIDAccess = new TCKTransactionIDAccessImpl(this.sleeTransactionManager);
            this.activityMap = new TCKActivityMap(this.tracer);
            this.eventTypes = new HashMap();
            this.marshaler = new TCKMarshalerImpl();
            TCKResourceSetupInterface tCKResourceSetupInterface = TCKResourceFactory.createResource();
            tCKResourceSetupInterface.setLog(new TCKRALogger());
            this.resource = tCKResourceSetupInterface.getResourceAdaptorInterface();
            this.resourceSbbInterface = this.resource.getSbbInterface();
            this.tracer.info("Locating RMI registry at port " + this.rmiPort + " on localhost...");
            this.rmiRegistry = LocateRegistry.getRegistry(this.rmiPort);
            this.tracer.info("Registry located");
            this.tracer.info("Binding test interface...");
            TCKResourceTestInterface tCKResourceTestInterface = tCKResourceSetupInterface.getTestInterface();
            this.rmiRegistry.rebind("TCKResourceTestInterface", tCKResourceTestInterface);
            this.tracer.info("Test interface bound in RMI registry");
            this.resource.addEventHandler(this);
        }
        catch (Exception exception) {
            this.tracer.severe("Exception caught while starting the TCK Resource Adaptor", (Throwable)exception);
        }
        this.tracer.info("TCK Resource Adaptor started");
    }

    public void raInactive() {
        this.tracer.finest("raInactive()");
        try {
            this.resource.removeEventHandler(this);
            this.tracer.info("Unbinding from RMI Registry");
            this.rmiRegistry.unbind("TCKResourceTestInterface");
            this.tracer.info("Test interface unbound from RMI Registry");
            this.transactionIDAccess = null;
            this.activityMap = null;
            this.eventTypes = null;
            this.marshaler = null;
            this.resource = null;
            this.resourceSbbInterface = null;
            this.rmiRegistry = null;
        }
        catch (Exception exception) {
            this.tracer.severe("Exception caught while stopping the TCK Resource Adaptor", (Throwable)exception);
        }
        this.tracer.info("TCK Resource Adaptor stopped");
    }

    public void raStopping() {
        this.tracer.finest("raStopping()");
        this.tracer.info("Stopping TCK Resource Adaptor");
        try {
            this.resource.eventHandlerDeactivating(this);
        }
        catch (RemoteException remoteException) {
            this.tracer.severe("Exception caught while deactivating the TCK Resource Adaptor event handler", (Throwable)remoteException);
        }
    }

    public void raVerifyConfiguration(ConfigProperties configProperties) throws InvalidConfigurationException {
        this.tracer.finest("raVerifyConfiguration(): " + configProperties);
        ConfigProperties.Property property = configProperties.getProperty("rmiPort");
        if (property == null) {
            throw new InvalidConfigurationException("Configuration property rmiPort has not been set");
        }
        int n = (Integer)property.getValue();
        if (n < 0 || n > 65535) {
            throw new InvalidConfigurationException("Configuration property rmiPort has not been set to a valid value (0-65535): " + n);
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n, FailureReason failureReason) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("eventProcessingFailed(): handle=" + activityHandle + ", eventTypeID=" + fireableEventType.getEventType().toString() + ", event=" + object + ", address=" + address + ", service=" + receivableService + ", flags=" + n + ", failureReason=" + failureReason);
        }
        TCKActivity tCKActivity = (TCKActivity)this.getActivity(activityHandle);
        String string = "Event processing failed. Event=" + object + ",Activity=" + tCKActivity + ",ServiceID=" + receivableService + ",Flags=" + n + ",Reason=" + failureReason;
        if (object != null && object instanceof TCKResourceEvent) {
            TCKResourceEvent tCKResourceEvent = (TCKResourceEvent)object;
            try {
                this.resource.onEventProcessingFailed(tCKResourceEvent.getEventObjectID(), string, null);
            }
            catch (RemoteException remoteException) {
                this.tracer.severe("Caught RemoteException while calling TCKResourceAdaptorInterface:" + remoteException);
            }
        } else {
            try {
                this.resource.onException(new TCKTestErrorException(string));
            }
            catch (RemoteException remoteException) {
                this.tracer.severe("Caught RemoteException while calling TCKResourceAdaptorInterface:" + remoteException);
            }
        }
        this.tracer.severe("Event processing failed for event: " + object);
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("eventProcessingSuccessful(): handle=" + activityHandle + ", eventTypeID=" + fireableEventType.getEventType().toString() + ", event=" + object + ", address=" + address + ", service=" + receivableService + ", flags=" + n);
        }
        if (object != null && object instanceof TCKResourceEvent) {
            TCKResourceEvent tCKResourceEvent = (TCKResourceEvent)object;
            try {
                this.resource.onEventProcessingSuccessful(tCKResourceEvent.getEventObjectID());
            }
            catch (RemoteException remoteException) {
                this.tracer.severe("Caught RemoteException while calling TCKResourceAdaptorInterface:" + remoteException);
            }
        }
        this.tracer.info("eventProcessingSuccessful() call received for event: " + object);
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType fireableEventType, Object object, Address address, ReceivableService receivableService, int n) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("eventUnreferenced(): handle=" + activityHandle + ", eventID=" + fireableEventType.getEventType() + ", event=" + object + ", address=" + address + ", service=" + receivableService.getService() + ", flags=" + n);
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getActivity():" + activityHandle);
        }
        if (activityHandle instanceof TCKActivityHandleImpl) {
            return this.activityMap.getActivity((TCKActivityHandleImpl)activityHandle);
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object object) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getActivityHandle():" + object);
        }
        return this.activityMap.getActivityHandle(object);
    }

    public Marshaler getMarshaler() {
        this.tracer.finest("getMarshaler()");
        return this.marshaler;
    }

    public Object getResourceAdaptorInterface(String string) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getResourceAdaptorInterface(): " + string);
        }
        if (string.equals("com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceAdaptorSbbInterface")) {
            return this;
        }
        return null;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("queryLiveness(): " + activityHandle);
        }
        TCKActivity tCKActivity = (TCKActivity)this.getActivity(activityHandle);
        try {
            if (!tCKActivity.isLive()) {
                this.sleeEndpoint.endActivity(activityHandle);
            }
        }
        catch (Exception exception) {
            try {
                this.resource.onException(exception);
            }
            catch (RemoteException remoteException) {
                this.tracer.severe("Caught RemoteException while calling TCKResourceAdaptorInterface:", (Throwable)remoteException);
            }
            this.tracer.severe("Caught Exception while querying an activity for liveness", (Throwable)exception);
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("serviceActive(): service=" + receivableService.getService() + ", eventIDs=" + Arrays.toString(receivableService.getReceivableEvents()) + ", resourceOptions=" + Arrays.toString(this.extractResourceOptionArrFromEvents(receivableService.getReceivableEvents())));
        }
    }

    public void serviceInactive(ReceivableService receivableService) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("serviceInactive(): service=" + receivableService.getService() + ", eventIDs=" + Arrays.toString(receivableService.getReceivableEvents()) + ", resourceOptions=" + Arrays.toString(this.extractResourceOptionArrFromEvents(receivableService.getReceivableEvents())));
        }
    }

    public void serviceStopping(ReceivableService receivableService) {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("serviceStopping(): service=" + receivableService.getService() + ", eventIDs=" + Arrays.toString(receivableService.getReceivableEvents()) + ", resourceOptions=" + Arrays.toString(this.extractResourceOptionArrFromEvents(receivableService.getReceivableEvents())));
        }
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext resourceAdaptorContext) {
        if (resourceAdaptorContext == null) {
            throw new IllegalArgumentException("TCKResourceAdaptor: The SLEE passed a null context to the TCK Resource Adaptor");
        }
        this.context = resourceAdaptorContext;
        this.tracer = resourceAdaptorContext.getTracer("TCK-RA");
        this.tracer.finest("setResourceadaptorContext(): " + resourceAdaptorContext);
    }

    public void unsetResourceAdaptorContext() {
        this.tracer.finest("unsetResourceAdaptorContext()");
        this.tracer = null;
        this.context = null;
    }

    public TCKResourceSbbInterface getResource() {
        this.tracer.finest("getResource()");
        return this.resourceSbbInterface;
    }

    public TransactionIDAccess getTransactionIDAccess() {
        this.tracer.finest("getTransactionIDAccess()");
        return this.transactionIDAccess;
    }

    public void handleActivityCreatedBySbb(TCKActivityID tCKActivityID) throws TCKTestErrorException, RemoteException {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("handleActivityCreatedBySbb(): activityID=" + tCKActivityID);
        }
        TCKActivity tCKActivity = this.resource.getActivity(tCKActivityID);
        TCKActivityHandleImpl tCKActivityHandleImpl = this.registerActivity(tCKActivity);
        try {
            int n = 6;
            this.sleeEndpoint.startActivity((ActivityHandle)tCKActivityHandleImpl, (Object)tCKActivity, n);
        }
        catch (Exception exception) {
            this.deregisterActivity(tCKActivityHandleImpl);
            throw new TCKTestErrorException("Can't register new activity, see enclosed exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleActivityEnd(TCKActivityID tCKActivityID, boolean bl) throws TCKTestErrorException, RemoteException {
        TCKActivity tCKActivity;
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("handleActivityEnd(): activityID=" + tCKActivityID + ", endedBySbb=" + bl);
        }
        if ((tCKActivity = this.resource.getActivity(tCKActivityID)) == null) {
            throw new TCKTestErrorException("Couldn't find activity for ID: " + tCKActivityID);
        }
        TCKActivityMap tCKActivityMap = this.activityMap;
        synchronized (tCKActivityMap) {
            TCKActivityHandleImpl tCKActivityHandleImpl = this.activityMap.getActivityHandle(tCKActivity);
            if (tCKActivityHandleImpl != null) {
                try {
                    this.sleeEndpoint.endActivity((ActivityHandle)tCKActivityHandleImpl);
                }
                catch (Exception exception) {
                    throw new TCKTestErrorException("Couldn't end activity with ID '" + tCKActivityID + "', see enclosed exception", exception);
                }
            } else if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Ignoring activity end for unknown activity: " + tCKActivityID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TCKResourceEvent tCKResourceEvent, String string, TCKActivityID tCKActivityID, Address address) throws TCKTestErrorException, RemoteException {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("handleEvent(): event=" + tCKResourceEvent + ", eventType=" + string + ", activityID=" + tCKActivityID + ", address=" + address);
        }
        TCKActivity tCKActivity = this.resource.getActivity(tCKActivityID);
        FireableEventType fireableEventType = this.lookupFireableEventType(string);
        TCKActivityHandleImpl tCKActivityHandleImpl = null;
        boolean bl = false;
        TCKActivityMap tCKActivityMap = this.activityMap;
        synchronized (tCKActivityMap) {
            tCKActivityHandleImpl = this.activityMap.getActivityHandle(tCKActivity);
            if (tCKActivityHandleImpl == null) {
                tCKActivityHandleImpl = this.registerActivity(tCKActivity);
                bl = true;
            }
        }
        if (bl) {
            try {
                int n = 6;
                this.sleeEndpoint.startActivity((ActivityHandle)tCKActivityHandleImpl, (Object)tCKActivity, n);
            }
            catch (Exception exception) {
                throw new TCKTestErrorException("Couldn't create Activity Handle: " + tCKActivityHandleImpl, exception);
            }
        }
        try {
            int n = 96;
            this.sleeEndpoint.fireEvent((ActivityHandle)tCKActivityHandleImpl, fireableEventType, (Object)tCKResourceEvent, address, null, n);
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Couldn't fire event with ID '" + fireableEventType.getEventType() + "', see enclosed exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCKActivityHandleImpl registerActivity(Object object) {
        TCKActivityMap tCKActivityMap = this.activityMap;
        synchronized (tCKActivityMap) {
            return this.activityMap.allocateActivityHandle(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterActivity(TCKActivityHandleImpl tCKActivityHandleImpl) {
        TCKActivityMap tCKActivityMap = this.activityMap;
        synchronized (tCKActivityMap) {
            this.activityMap.deallocateActivityHandle(tCKActivityHandleImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FireableEventType lookupFireableEventType(String string) throws TCKTestErrorException {
        try {
            FireableEventType fireableEventType = null;
            Map map = this.eventTypes;
            synchronized (map) {
                fireableEventType = (FireableEventType)this.eventTypes.get(string);
            }
            if (fireableEventType == null) {
                map = new EventTypeID(string, EVENT_TYPE_VENDOR, EVENT_TYPE_VERSION);
                fireableEventType = this.eventLookupFacility.getFireableEventType((EventTypeID)map);
                Map map2 = this.eventTypes;
                synchronized (map2) {
                    this.eventTypes.put(string, fireableEventType);
                }
            }
            return fireableEventType;
        }
        catch (UnrecognizedEventException unrecognizedEventException) {
            throw new TCKTestErrorException("Unrecognized event type name: " + string);
        }
    }

    private String[] extractResourceOptionArrFromEvents(ReceivableService.ReceivableEvent[] receivableEventArray) {
        String[] stringArray = new String[receivableEventArray.length];
        for (int i = 0; i < receivableEventArray.length; ++i) {
            stringArray[i] = receivableEventArray[i].getResourceOption();
        }
        return stringArray;
    }

    public class TCKRALogger
    implements Logable {
        public void config(String string) {
            TCKResourceAdaptor.this.tracer.config(string);
        }

        public void config(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.config(throwable.getMessage(), throwable);
        }

        public void critical(String string) {
            TCKResourceAdaptor.this.tracer.severe(string);
        }

        public void critical(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.severe(throwable.getMessage(), throwable);
        }

        public void debug(String string) {
            TCKResourceAdaptor.this.tracer.fine(string);
        }

        public void debug(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.fine(throwable.getMessage(), throwable);
        }

        public void error(String string) {
            TCKResourceAdaptor.this.tracer.severe(string);
        }

        public void error(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.severe(throwable.getMessage(), throwable);
        }

        public void fine(String string) {
            TCKResourceAdaptor.this.tracer.fine(string);
        }

        public void fine(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.fine(throwable.getMessage(), throwable);
        }

        public void finer(String string) {
            TCKResourceAdaptor.this.tracer.finer(string);
        }

        public void finer(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.finer(throwable.getMessage(), throwable);
        }

        public void finest(String string) {
            TCKResourceAdaptor.this.tracer.finest(string);
        }

        public void finest(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.finest(throwable.getMessage(), throwable);
        }

        public void info(String string) {
            TCKResourceAdaptor.this.tracer.info(string);
        }

        public void info(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.info(throwable.getMessage(), throwable);
        }

        public boolean isLogable(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return TCKResourceAdaptor.this.tracer.isInfoEnabled();
                }
                case 14: {
                    return TCKResourceAdaptor.this.tracer.isConfigEnabled();
                }
                case 0: 
                case 15: {
                    return TCKResourceAdaptor.this.tracer.isFineEnabled();
                }
                case 16: {
                    return TCKResourceAdaptor.this.tracer.isFinerEnabled();
                }
                case 17: {
                    return TCKResourceAdaptor.this.tracer.isFinestEnabled();
                }
                case 4: 
                case 5: 
                case 11: {
                    return TCKResourceAdaptor.this.tracer.isSevereEnabled();
                }
            }
            return false;
        }

        public void normal(String string) {
            TCKResourceAdaptor.this.tracer.info(string);
        }

        public void normal(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.info(throwable.getMessage(), throwable);
        }

        public void setIgnoreLevel(int n) {
        }

        public void severe(String string) {
            TCKResourceAdaptor.this.tracer.severe(string);
        }

        public void severe(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.severe(throwable.getMessage(), throwable);
        }

        public void warning(String string) {
            TCKResourceAdaptor.this.tracer.warning(string);
        }

        public void warning(Throwable throwable) {
            TCKResourceAdaptor.this.tracer.warning(throwable.getMessage(), throwable);
        }

        public void writeToLog(int n, String string) {
            switch (n) {
                case 1: 
                case 2: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.INFO, string);
                    break;
                }
                case 14: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.CONFIG, string);
                    break;
                }
                case 0: 
                case 15: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINE, string);
                    break;
                }
                case 16: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINER, string);
                    break;
                }
                case 17: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINEST, string);
                    break;
                }
                case 3: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.WARNING, string);
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.SEVERE, string);
                }
            }
        }

        public void writeToLog(int n, Throwable throwable) {
            switch (n) {
                case 1: 
                case 2: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.INFO, throwable.getMessage(), throwable);
                    break;
                }
                case 14: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.CONFIG, throwable.getMessage(), throwable);
                    break;
                }
                case 0: 
                case 15: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINE, throwable.getMessage(), throwable);
                    break;
                }
                case 16: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINER, throwable.getMessage(), throwable);
                    break;
                }
                case 17: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.FINEST, throwable.getMessage(), throwable);
                    break;
                }
                case 3: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.WARNING, throwable.getMessage(), throwable);
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    TCKResourceAdaptor.this.tracer.trace(TraceLevel.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }
    }
}

