/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.rautils;

import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannelException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class TCKRAUtils {
    public static RMIObjectChannel lookupRMIObjectChannel() throws RMIObjectChannelException {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Registry registry = LocateRegistry.getRegistry(TCKRAUtils.getRMIRegistryPort());
                    return (RMIObjectChannel)registry.lookup("RMIObjectChannel");
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        });
        if (t instanceof RMIObjectChannel) {
            return (RMIObjectChannel)t;
        }
        if (t instanceof Exception) {
            throw new RMIObjectChannelException((Exception)t);
        }
        throw new RMIObjectChannelException("Unexpected result returned from RMIObjectChannel lookup: " + t);
    }

    public static MessageHandlerRegistry lookupMessageHandlerRegistry() throws RMIObjectChannelException {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Registry registry = LocateRegistry.getRegistry(TCKRAUtils.getRMIRegistryPort());
                    return (MessageHandlerRegistry)registry.lookup("MessageHandlerRegistry");
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        });
        if (t instanceof MessageHandlerRegistry) {
            return (MessageHandlerRegistry)t;
        }
        if (t instanceof Exception) {
            throw new RMIObjectChannelException((Exception)t);
        }
        throw new RMIObjectChannelException("Unexpected result returned from RMIObjectChannel lookup: " + t);
    }

    public static int getRMIRegistryPort() {
        return 4099;
    }
}

