/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.profileutils;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import java.rmi.RemoteException;
import java.util.HashMap;

public class BaseMessageAdapter
implements MessageHandler {
    private Logable log;

    public BaseMessageAdapter(Logable logable) {
        this.log = logable;
    }

    private boolean checkMsgClass(HashMap hashMap) {
        Integer n = (Integer)hashMap.get("MsgClass");
        return n != null && n == 1;
    }

    public void onException(Exception exception) {
        this.onSetError("Exception occured: ", exception);
    }

    public boolean handleMessage(Object object) throws RemoteException {
        this.log.finer("Received message: " + object);
        if (object instanceof Exception) {
            this.onException((Exception)object);
            return true;
        }
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            if (!this.checkMsgClass(hashMap)) {
                return false;
            }
            try {
                int n = (Integer)hashMap.get("Type");
                switch (n) {
                    case 0: {
                        int n2 = (Integer)hashMap.get("ID");
                        String string = (String)hashMap.get("Msg");
                        Exception exception = (Exception)hashMap.get("Cause");
                        this.onSetFailed(n2, string, exception);
                        return true;
                    }
                    case 1: {
                        int n3 = (Integer)hashMap.get("ID");
                        String string = (String)hashMap.get("Msg");
                        this.onSetPassed(n3, string);
                        return true;
                    }
                    case 3: {
                        String string = (String)hashMap.get("Msg");
                        this.onLogCall(string);
                        return true;
                    }
                    case 2: {
                        String string = (String)hashMap.get("Msg");
                        Exception exception = (Exception)hashMap.get("Cause");
                        this.onSetError(string, exception);
                        return true;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                this.log.warning("NullPointerException occured while trying to read fields of message from RMIObjectChannel. The msg contents were:");
                for (Object k : hashMap.keySet()) {
                    Object v = hashMap.get(k);
                    this.log.warning("Key: " + k + " Value:" + v);
                }
                this.log.warning("Thrown exception: ");
                this.log.warning(nullPointerException);
                return true;
            }
        }
        return false;
    }

    public void onSetPassed(int n, String string) {
    }

    public void onSetFailed(int n, String string, Exception exception) {
    }

    public void onLogCall(String string) {
    }

    public void onSetError(String string, Exception exception) {
    }
}

