/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.testfinder;

import com.opencloud.sleetck.lib.DescriptionKeys;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.testfinder.NotATestDescriptionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestDescriptionFileHandler
extends DefaultHandler {
    private static final String DTD_URI = "http://www.opencloud.com/dtd/slee-tck-test-description_1_0.dtd";
    private static final String DTD_NAME_PREFIX = "slee-tck-test-description";
    private static final String NO_URI = "";
    private String localDTDURI;
    private boolean foundDTD;
    private Map testParameters;
    private Vector assertions;
    private Vector assumeAssertions;
    private Vector keywords;
    private StringBuffer elementTextBuf;

    public TestDescriptionFileHandler(String string) {
        this.localDTDURI = string;
        this.testParameters = new HashMap();
        this.assertions = new Vector();
        this.assumeAssertions = new Vector();
        this.keywords = new Vector();
        this.elementTextBuf = new StringBuffer();
    }

    public Map getTestParameters() {
        return new HashMap(this.testParameters);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (string2.equals(DTD_URI)) {
            this.foundDTD = true;
            return new InputSource(this.localDTDURI);
        }
        if (string2.indexOf(DTD_NAME_PREFIX) != -1) {
            throw new SAXNotRecognizedException("The referenced test description dtd reference is not specified with the expected systemID. Expected=http://www.opencloud.com/dtd/slee-tck-test-description_1_0.dtd; Found=" + string2);
        }
        throw new SAXException(new NotATestDescriptionException());
    }

    public void startDocument() throws SAXException {
        this.foundDTD = false;
        this.testParameters.clear();
        this.assertions.clear();
        this.assumeAssertions.clear();
        this.keywords.clear();
    }

    public void endDocument() throws SAXException {
        this.setParameter("keywords", this.getList(this.keywords));
        this.setParameter("assertions", this.getList(this.assertions));
        this.setParameter("assume-assertions", this.getList(this.assumeAssertions));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.foundDTD) {
            throw new SAXException(new NotATestDescriptionException());
        }
        this.elementTextBuf.setLength(0);
        if (string2.equals("assertion")) {
            this.assertions.addElement(attributes.getValue(NO_URI, "id"));
        } else if (string2.equals("assume-assertion")) {
            this.assumeAssertions.addElement(attributes.getValue(NO_URI, "id"));
        } else if (string2.equals("property")) {
            String string4 = attributes.getValue(NO_URI, "name");
            this.validatePropertyName(string4);
            String string5 = attributes.getValue(NO_URI, "value");
            this.setParameter(string4, string5);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.elementTextBuf.toString();
        if (string2.equals("title")) {
            this.setParameter("title", string4);
        } else if (string2.equals("description")) {
            this.setParameter("description", string4);
        } else if (string2.equals("executeClass")) {
            this.setParameter("executeClass", string4);
        } else if (string2.equals("executeArgs")) {
            this.setParameter("executeArgs", string4);
        } else if (string2.equals("timeout-multiplier")) {
            this.setParameter("timeout-multiplier", string4);
        } else if (string2.equals("keyword")) {
            if (this.keywords.contains(string4)) {
                throw new SAXException(new TCKTestErrorException("keyword " + string4 + " included twice in test description: " + this.localDTDURI));
            }
            this.keywords.addElement(string4);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.elementTextBuf.append(cArray, n, n2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void setParameter(String string, String string2) {
        if (string2 != null) {
            this.testParameters.put(string, string2);
        }
    }

    private void validatePropertyName(String string) throws SAXException {
        for (int i = 0; i < DescriptionKeys.RESERVED_KEYS.length; ++i) {
            if (!DescriptionKeys.RESERVED_KEYS[i].equals(string)) continue;
            throw new SAXException(new TCKTestErrorException("The property name " + string + " is a reserved name and may not be used to define a custom test property"));
        }
        if (this.testParameters.containsKey(string)) {
            throw new SAXException(new TCKTestErrorException("Attempt to define property " + string + " twice. Properties can only be defined once in each test description."));
        }
    }

    private String getList(Vector vector) {
        StringBuffer stringBuffer = null;
        Iterator iterator = vector.iterator();
        if (iterator.hasNext()) {
            stringBuffer = new StringBuffer();
            stringBuffer.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(',').append((String)iterator.next());
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }
}

