/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra.testfinder;

import com.opencloud.sleetck.lib.infra.testfinder.TestDescriptionReader;
import com.opencloud.sleetck.lib.testutils.ExceptionsUtil;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Vector;
import org.xml.sax.SAXException;

public class SleeTCKTestFinder
extends TestFinder {
    private static final String DTD_RELATIVE_PATH = "slee-tck-test-description_1_0.dtd";
    private TestDescriptionReader descriptionReader;
    private Vector testsFound;
    private Vector filesFound;
    private I18NResourceBundle i18NResourceBundle = I18NResourceBundle.getBundleForClass(((Object)((Object)this)).getClass());
    private static final String TEST_DESCRIPTION_ERROR = "SleeTCKTestFinder.scanFile.test-description-error";
    private static final String DTD_LOCATION_ERROR = "SleeTCKTestFinder.init.dtd-location-error";
    private static final String XML_READER_ERROR = "SleeTCKTestFinder.init.xml-reader-error";

    public SleeTCKTestFinder(File file) throws TestFinder.Fault {
        this.setRoot(file);
        File file2 = new File(this.getRootDir(), DTD_RELATIVE_PATH);
        String string = null;
        if (file2.exists()) {
            try {
                string = file2.toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                throw new TestFinder.Fault(this.i18NResourceBundle, DTD_LOCATION_ERROR, (Object)("MalformedURLException which trying convert file " + file2.getPath() + " to a URI: " + ExceptionsUtil.formatThrowable(malformedURLException)));
            }
        } else {
            throw new TestFinder.Fault(this.i18NResourceBundle, DTD_LOCATION_ERROR, (Object)("DTD file not found at " + file2.getPath()));
        }
        try {
            this.descriptionReader = new TestDescriptionReader(file, string);
        }
        catch (SAXException sAXException) {
            throw new TestFinder.Fault(this.i18NResourceBundle, XML_READER_ERROR, (Object)ExceptionsUtil.formatThrowable(sAXException));
        }
        this.testsFound = new Vector();
        this.filesFound = new Vector();
    }

    protected void scan(File file) {
        this.testsFound.clear();
        this.filesFound.clear();
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    public File[] getFiles() {
        Object[] objectArray = new File[this.filesFound.size()];
        this.filesFound.copyInto(objectArray);
        return objectArray;
    }

    public TestDescription[] getTests() {
        Object[] objectArray = new TestDescription[this.testsFound.size()];
        this.testsFound.copyInto(objectArray);
        return objectArray;
    }

    private void scanFile(File file) {
        try {
            TestDescription testDescription = this.descriptionReader.readTestDescription(file);
            if (testDescription != null) {
                this.testsFound.addElement(testDescription);
            }
        }
        catch (Exception exception) {
            this.error(this.i18NResourceBundle, TEST_DESCRIPTION_ERROR, ExceptionsUtil.formatThrowable(exception));
        }
    }

    private void scanDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory() && !fileArray[i].getPath().endsWith(".xml")) continue;
            this.filesFound.addElement(fileArray[i]);
        }
    }
}

