/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.util.SleepUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.InvalidStateException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.facilities.Level;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ManagementException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.SbbDescriptor;
import javax.slee.management.ServiceDescriptor;
import javax.slee.management.ServiceState;
import javax.slee.resource.ResourceAdaptorID;

public class SleeTCKTestUtilsImpl
implements SleeTCKTestUtils {
    private Properties testParams;
    private Properties envParams;
    private MBeanFacade facade;
    private MBeanProxyFactory mBeanProxyFactory;
    private TCKResourceTestInterface resourceInterface;
    private RMIObjectChannel rmiObjectChannel;
    private MessageHandlerRegistry messageHandlerRegistry;
    private Logable log;
    private ObjectName mgmtMBeanName;
    private String baseDeployableUnitsURL;
    private int defaultTimeout;
    private int testTimeout;
    private SleeManagementMBeanProxy sleeManagementMBeanProxy;
    private ServiceManagementMBeanProxy serviceManagementMBeanProxy;
    private ResourceManagementMBeanProxy resourceManagementMBeanProxy;
    private TraceMBeanProxy traceMBeanProxy;
    private AlarmMBeanProxy alarmMBeanProxy;
    private DeploymentMBeanProxy deploymentMBeanProxy;
    private LinkedList deployableUnitIDs;
    private Set activatedServiceIDs;
    private static final long WAIT_FOR_COMPONENT_PAUSE = 500L;

    public SleeTCKTestUtilsImpl(Properties properties, Properties properties2, MBeanFacade mBeanFacade, MBeanProxyFactory mBeanProxyFactory, TCKResourceTestInterface tCKResourceTestInterface, RMIObjectChannel rMIObjectChannel, MessageHandlerRegistry messageHandlerRegistry, Logable logable, ObjectName objectName, String string, int n, int n2) {
        this.testParams = properties;
        this.envParams = properties2;
        this.facade = mBeanFacade;
        this.mBeanProxyFactory = mBeanProxyFactory;
        this.resourceInterface = tCKResourceTestInterface;
        this.rmiObjectChannel = rMIObjectChannel;
        this.messageHandlerRegistry = messageHandlerRegistry;
        this.log = logable;
        this.mgmtMBeanName = objectName;
        this.baseDeployableUnitsURL = string;
        this.defaultTimeout = n;
        this.testTimeout = n2;
        this.deployableUnitIDs = new LinkedList();
        this.activatedServiceIDs = new HashSet();
    }

    public Properties getTestParams() {
        return this.testParams;
    }

    public Properties getEnvParams() {
        return this.envParams;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public int getTestTimeout() {
        return this.testTimeout;
    }

    public Logable getLog() {
        return this.log;
    }

    public MBeanFacade getMBeanFacade() {
        return this.facade;
    }

    public MBeanProxyFactory getMBeanProxyFactory() {
        return this.mBeanProxyFactory;
    }

    public ObjectName getSleeManagementMBeanName() {
        return this.mgmtMBeanName;
    }

    public SleeManagementMBeanProxy getSleeManagementMBeanProxy() throws TCKTestErrorException {
        if (this.sleeManagementMBeanProxy == null) {
            this.sleeManagementMBeanProxy = this.mBeanProxyFactory.createSleeManagementMBeanProxy(this.mgmtMBeanName);
        }
        return this.sleeManagementMBeanProxy;
    }

    public String getDeploymentUnitURL(String string) {
        if (this.baseDeployableUnitsURL == null) {
            throw new NullPointerException("baseDeployableUnitsURL must be set");
        }
        if (string == null) {
            throw new NullPointerException("relativeURL must be non-null");
        }
        StringBuffer stringBuffer = new StringBuffer(this.baseDeployableUnitsURL);
        if (!this.baseDeployableUnitsURL.endsWith("/") && !string.startsWith("/")) {
            stringBuffer.append("/");
        }
        return stringBuffer.append(string).toString();
    }

    public DeploymentMBeanProxy getDeploymentMBeanProxy() throws TCKTestErrorException {
        if (this.deploymentMBeanProxy == null) {
            ObjectName objectName = this.getSleeManagementMBeanProxy().getDeploymentMBean();
            this.deploymentMBeanProxy = this.mBeanProxyFactory.createDeploymentMBeanProxy(objectName);
        }
        return this.deploymentMBeanProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableUnitID install(String string) throws TCKTestErrorException {
        try {
            LinkedList linkedList = this.deployableUnitIDs;
            synchronized (linkedList) {
                String string2 = this.getDeploymentUnitURL(string);
                this.log.fine("Installing deployable unit " + string2);
                DeployableUnitID deployableUnitID = this.getDeploymentMBeanProxy().install(string2);
                this.deployableUnitIDs.addFirst(deployableUnitID);
                return deployableUnitID;
            }
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Caught Exception while trying to install component", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninstallAll() throws TCKTestErrorException {
        boolean bl = false;
        TCKTestErrorException tCKTestErrorException = null;
        LinkedList linkedList = this.deployableUnitIDs;
        synchronized (linkedList) {
            this.log.fine("Uninstalling all deployable units installed via SleeTCKTestUtils...");
            Iterator iterator = this.deployableUnitIDs.iterator();
            while (iterator.hasNext()) {
                block9: {
                    DeployableUnitID deployableUnitID = (DeployableUnitID)iterator.next();
                    try {
                        if (!this.deploymentMBeanProxy.isInstalled(deployableUnitID)) break block9;
                        this.log.finer("Uninstalling deployable unit " + deployableUnitID);
                        try {
                            this.ensureServicesStopped(deployableUnitID);
                        }
                        catch (Exception exception) {
                            this.log.warning(exception);
                            tCKTestErrorException = new TCKTestErrorException("Caught Exception while trying to ensure services are stopped", exception);
                        }
                        this.deploymentMBeanProxy.uninstall(deployableUnitID);
                        bl = true;
                    }
                    catch (Exception exception) {
                        this.log.warning(exception);
                        tCKTestErrorException = new TCKTestErrorException("Caught Exception while trying to uninstall component", exception);
                    }
                }
                iterator.remove();
            }
        }
        if (tCKTestErrorException != null) {
            throw tCKTestErrorException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceID[] activateServices(DeployableUnitID deployableUnitID, boolean bl) throws TCKTestErrorException {
        try {
            int n;
            ServiceID[] serviceIDArray;
            Level level = null;
            if (bl && (serviceIDArray = this.envParams.getProperty("sbbTraceLevel")) != null && (n = Integer.parseInt((String)serviceIDArray)) != 0) {
                level = Level.fromInt((int)n);
            }
            this.log.fine("Activating services for deployable unit " + deployableUnitID);
            serviceIDArray = this.getServices(deployableUnitID);
            Set set = this.activatedServiceIDs;
            synchronized (set) {
                for (int i = 0; i < serviceIDArray.length; ++i) {
                    this.log.finer("Activating service " + serviceIDArray[i]);
                    this.getServiceManagementMBeanProxy().activate(serviceIDArray[i]);
                    this.activatedServiceIDs.add(serviceIDArray[i]);
                    if (level == null) continue;
                    ServiceDescriptor serviceDescriptor = (ServiceDescriptor)this.getDeploymentMBeanProxy().getDescriptor((ComponentID)serviceIDArray[i]);
                    SbbID sbbID = serviceDescriptor.getRootSbb();
                    this.setTraceLevelForSbbTree(sbbID, level);
                }
            }
            return serviceIDArray;
        }
        catch (Exception exception) {
            if (exception instanceof TCKTestErrorException) {
                throw (TCKTestErrorException)exception;
            }
            throw new TCKTestErrorException("Caught Exception while trying to activate service", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivateAllServices() throws TCKTestErrorException {
        boolean bl = false;
        TCKTestErrorException tCKTestErrorException = null;
        ServiceManagementMBeanProxy serviceManagementMBeanProxy = this.getServiceManagementMBeanProxy();
        Set set = this.activatedServiceIDs;
        synchronized (set) {
            this.log.finer("Deactivating all services activated via SleeTCKTestUtils...");
            Iterator iterator = this.activatedServiceIDs.iterator();
            while (iterator.hasNext()) {
                ServiceID serviceID = (ServiceID)iterator.next();
                this.log.finer("deactivateAllServices: activatedServiceIDs.next = " + serviceID.toString());
                try {
                    ServiceState serviceState = serviceManagementMBeanProxy.getState(serviceID);
                    this.log.finer("deactivateAllServices: Current state for service is: " + serviceState.toString());
                    if (serviceManagementMBeanProxy.getState(serviceID).isActive()) {
                        this.log.finer("Deactivating service " + serviceID);
                        this.deactivateService(serviceID);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    this.log.warning(exception);
                    tCKTestErrorException = new TCKTestErrorException("Caught Exception while trying to deactivate service", exception);
                }
                iterator.remove();
            }
            this.log.fine("deactivateAllServices: activatedServiceIDs.next complete");
        }
        if (tCKTestErrorException != null) {
            throw tCKTestErrorException;
        }
        return bl;
    }

    public void removeRAEntities() throws TCKTestErrorException {
        System.out.println("removeRAEntities()");
        if (this.resourceManagementMBeanProxy == null) {
            return;
        }
        try {
            long l = System.currentTimeMillis();
            long l2 = l + (long)this.getTestTimeout();
            while (System.currentTimeMillis() < l2) {
                boolean bl = true;
                String[] stringArray = this.resourceManagementMBeanProxy.getResourceAdaptorEntities();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    System.out.println("Processing ra entity " + string);
                    ResourceAdaptorID resourceAdaptorID = this.resourceManagementMBeanProxy.getResourceAdaptor(string);
                    ResourceAdaptorEntityState resourceAdaptorEntityState = this.resourceManagementMBeanProxy.getState(string);
                    if (resourceAdaptorID.getName().equals("TCK_Resource_Adaptor") && resourceAdaptorID.getVendor().equals("jain.slee.tck")) {
                        System.out.println("Ignoring ra entity " + string + ", it is the tck ra entity");
                        continue;
                    }
                    if (!resourceAdaptorID.getVendor().equals("jain.slee.tck")) {
                        System.out.println("Ignoring ra entity " + string + " it is not from tck vendor");
                        continue;
                    }
                    if (resourceAdaptorEntityState.isActive()) {
                        this.log.finer("Deactivating RA Entity: " + string);
                        this.resourceManagementMBeanProxy.deactivateResourceAdaptorEntity(string);
                        bl = false;
                        continue;
                    }
                    if (resourceAdaptorEntityState.isStopping()) {
                        this.log.finer("Still waiting for RA Entity to deactivate: " + string);
                        bl = false;
                        continue;
                    }
                    if (!resourceAdaptorEntityState.isInactive()) continue;
                    String[] stringArray2 = this.resourceManagementMBeanProxy.getLinkNames(string);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string2 = stringArray2[j];
                        this.log.finer("Unbinding link name: " + string2);
                        this.resourceManagementMBeanProxy.unbindLinkName(string2);
                    }
                    this.log.finer("Removing RA Entity: " + string);
                    this.resourceManagementMBeanProxy.removeResourceAdaptorEntity(string);
                }
                if (bl) {
                    this.log.finer("RA entities removed");
                    return;
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Failed to deactivate and remove one or more RA Entities", exception);
        }
        throw new TCKTestErrorException("Failed to deactivate and remove one or more RA Entities before test timeout");
    }

    public ResourceUsageMBeanProxy getResourceUsageMBeanProxy(String string) throws TCKTestErrorException {
        try {
            return this.mBeanProxyFactory.createResourceUsageMBeanProxy(this.getResourceManagementMBeanProxy().getResourceUsageMBean(string));
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("An error occured attempting to create a UsageMBeanProxy for Resource Adaptor Entity: " + string, exception);
        }
    }

    public ResourceManagementMBeanProxy getResourceManagementMBeanProxy() throws TCKTestErrorException {
        if (this.resourceManagementMBeanProxy == null) {
            this.resourceManagementMBeanProxy = this.mBeanProxyFactory.createResourceManagementMBeanProxy(this.getSleeManagementMBeanProxy().getResourceManagementMBean());
        }
        return this.resourceManagementMBeanProxy;
    }

    public ServiceManagementMBeanProxy getServiceManagementMBeanProxy() throws TCKTestErrorException {
        if (this.serviceManagementMBeanProxy == null) {
            this.serviceManagementMBeanProxy = this.mBeanProxyFactory.createServiceManagementMBeanProxy(this.getSleeManagementMBeanProxy().getServiceManagementMBean());
        }
        return this.serviceManagementMBeanProxy;
    }

    public TraceMBeanProxy getTraceMBeanProxy() throws TCKTestErrorException {
        if (this.traceMBeanProxy == null) {
            this.traceMBeanProxy = this.mBeanProxyFactory.createTraceMBeanProxy(this.getSleeManagementMBeanProxy().getTraceMBean());
        }
        return this.traceMBeanProxy;
    }

    public AlarmMBeanProxy getAlarmMBeanProxy() throws TCKTestErrorException {
        if (this.alarmMBeanProxy == null) {
            this.alarmMBeanProxy = this.mBeanProxyFactory.createAlarmMBeanProxy(this.getSleeManagementMBeanProxy().getAlarmMBean());
        }
        return this.alarmMBeanProxy;
    }

    public TCKResourceTestInterface getResourceInterface() {
        return this.resourceInterface;
    }

    public RMIObjectChannel getRMIObjectChannel() {
        return this.rmiObjectChannel;
    }

    public MessageHandlerRegistry getMessageHandlerRegistry() {
        return this.messageHandlerRegistry;
    }

    private void ensureServicesStopped(DeployableUnitID deployableUnitID) throws TCKTestErrorException {
        ServiceID[] serviceIDArray = this.getServices(deployableUnitID);
        for (int i = 0; i < serviceIDArray.length; ++i) {
            ServiceID serviceID = serviceIDArray[i];
            if (serviceID != null) {
                try {
                    ServiceManagementMBeanProxy serviceManagementMBeanProxy = this.getServiceManagementMBeanProxy();
                    ServiceState serviceState = serviceManagementMBeanProxy.getState(serviceID);
                    if (serviceState.isActive()) {
                        this.log.warning("A service to be uninstalled was not deactivated by the test - services should be explicitly deactivated before uninstallation. serviceID=" + serviceID);
                        try {
                            serviceManagementMBeanProxy.deactivate(serviceID);
                        }
                        catch (InvalidStateException invalidStateException) {
                            this.log.warning("A service was just deactivated by another thread (detected during ensureServicesStopped())This indicates a race condition in the test. serviceID=" + serviceID);
                        }
                        serviceState = serviceManagementMBeanProxy.getState(serviceID);
                    }
                    if (serviceState.isInactive()) continue;
                    long l = System.currentTimeMillis();
                    long l2 = l + (long)this.getTestTimeout();
                    while (l < l2 && !serviceState.isInactive()) {
                        SleepUtil.sleepFor(Math.min(l2 - l, 500L));
                        serviceState = serviceManagementMBeanProxy.getState(serviceID);
                        l = System.currentTimeMillis();
                    }
                    if (!serviceState.isInactive()) {
                        throw new OperationTimedOutException("The timeout of " + this.getTestTimeout() + " ms  was reached while waiting for service to stop. serviceID=" + serviceID + " serviceState=" + serviceState);
                    }
                    this.log.finest("Service stopped successfully (during preparation to uninstall). serviceID=" + serviceID);
                    continue;
                }
                catch (UnrecognizedServiceException unrecognizedServiceException) {
                    this.log.warning("unrecognized service ID found for deployable unit. serviceID=" + serviceID + ". deployable unit=" + deployableUnitID);
                    this.log.warning(unrecognizedServiceException);
                    continue;
                }
                catch (ManagementException managementException) {
                    throw new TCKTestErrorException("ManagementException caught while trying to ensure service is stopped. serviceID=" + serviceID, (Exception)((Object)managementException));
                }
            }
            this.log.warning("null service ID encountered for deployable unit. deployable unit ID: " + deployableUnitID);
        }
    }

    private ServiceID[] getServices(DeployableUnitID deployableUnitID) throws TCKTestErrorException {
        try {
            DeployableUnitDescriptor deployableUnitDescriptor = this.getDeploymentMBeanProxy().getDescriptor(deployableUnitID);
            ComponentID[] componentIDArray = deployableUnitDescriptor.getComponents();
            ServiceID[] serviceIDArray = new ServiceID[componentIDArray.length];
            int n = 0;
            for (int i = 0; i < componentIDArray.length; ++i) {
                if (!(componentIDArray[i] instanceof ServiceID)) continue;
                serviceIDArray[n++] = (ServiceID)componentIDArray[i];
            }
            if (n < serviceIDArray.length) {
                ServiceID[] serviceIDArray2 = new ServiceID[n];
                System.arraycopy(serviceIDArray, 0, serviceIDArray2, 0, n);
                serviceIDArray = serviceIDArray2;
            }
            return serviceIDArray;
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Caught Exception while trying to get ServiceIDs from DeployableUnitID " + deployableUnitID, exception);
        }
    }

    private void setTraceLevelForSbbTree(SbbID sbbID, Level level) throws TCKTestErrorException {
        HashSet<SbbID> hashSet = new HashSet<SbbID>();
        hashSet.add(sbbID);
        this.setTraceLevelForSbbTree(sbbID, level, hashSet);
    }

    private void setTraceLevelForSbbTree(SbbID sbbID, Level level, HashSet hashSet) throws TCKTestErrorException {
        try {
            this.log.finest("Setting trace level to " + level + " for Sbb and all referenced Sbbs. SbbID=" + sbbID);
            SbbDescriptor sbbDescriptor = (SbbDescriptor)this.getDeploymentMBeanProxy().getDescriptor((ComponentID)sbbID);
            this.getTraceMBeanProxy().setTraceLevel((ComponentID)sbbID, level);
            SbbID[] sbbIDArray = sbbDescriptor.getSbbs();
            if (sbbIDArray != null) {
                for (int i = 0; i < sbbIDArray.length; ++i) {
                    if (!hashSet.add(sbbIDArray[i])) continue;
                    this.setTraceLevelForSbbTree(sbbIDArray[i], level, hashSet);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof TCKTestErrorException) {
                throw (TCKTestErrorException)exception;
            }
            throw new TCKTestErrorException("Caught Exception while trying to set trace level for SBB. sbbID=" + sbbID, exception);
        }
    }

    public void deactivateResourceAdaptorEntity(String string) throws TCKTestErrorException {
        ResourceManagementMBeanProxy resourceManagementMBeanProxy = this.getResourceManagementMBeanProxy();
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.getTestTimeout();
        boolean bl = false;
        while (System.currentTimeMillis() < l2) {
            try {
                ResourceAdaptorEntityState resourceAdaptorEntityState = resourceManagementMBeanProxy.getState(string);
                if (resourceAdaptorEntityState.isActive()) {
                    resourceManagementMBeanProxy.deactivateResourceAdaptorEntity(string);
                } else if (resourceAdaptorEntityState.isInactive()) {
                    bl = true;
                    break;
                }
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                throw new TCKTestErrorException("An exception occured while deactivating " + string + ": ", exception);
            }
        }
        if (!bl) {
            throw new TCKTestErrorException(string + " did not deactivate within test timeout period");
        }
    }

    public void deactivateService(ServiceID serviceID) throws TCKTestErrorException {
        ServiceState serviceState;
        ServiceManagementMBeanProxy serviceManagementMBeanProxy = this.getServiceManagementMBeanProxy();
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.getTestTimeout();
        boolean bl = false;
        try {
            serviceState = serviceManagementMBeanProxy.getState(serviceID);
            this.log.finer("deactivateService: Current state for service is: " + serviceState.toString());
            if (serviceState.isActive()) {
                serviceManagementMBeanProxy.deactivate(serviceID);
                serviceState = serviceManagementMBeanProxy.getState(serviceID);
                this.log.finer("deactivateService: New state for service is: " + serviceState.toString());
            }
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("An exception occured while deactivating " + serviceID + ": ", exception);
        }
        while (System.currentTimeMillis() < l2) {
            try {
                serviceState = serviceManagementMBeanProxy.getState(serviceID);
                if (serviceState.isInactive()) {
                    bl = true;
                    break;
                }
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                throw new TCKTestErrorException("An exception occured while obtaining state for Service: " + serviceID + ": ", exception);
            }
        }
        if (!bl) {
            throw new TCKTestErrorException(serviceID + " did not deactivate within test timeout period");
        }
    }
}

