/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.infra;

import com.opencloud.logging.Logable;
import com.opencloud.logging.PrintWriterLog;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.infra.SleeTCKComponentConstants;
import com.opencloud.sleetck.lib.infra.SleeTCKTestUtilsImpl;
import com.opencloud.sleetck.lib.infra.eventbridge.ClientSetup;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventListenerRegistry;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventSenderRemote;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemote;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeImpl;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistryImpl;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannelImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceTestInterfaceProxy;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.SleeStarter;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.impl.MBeanProxyFactoryImpl;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;

public class SleeTCKScript
extends Script {
    private ObjectName mgmtMBeanName;
    private MBeanFacadeImpl mBeanFacade;
    private MBeanProxyFactory mBeanProxyFactory;
    private TCKResourceTestInterfaceProxy resourceInterface;
    private Properties envParams;
    private Properties testParams;
    private Logable log;
    private int defaultTimeout;
    private int testTimeout;
    private TCKEventSenderRemote remoteSender;
    private SleeTCKTestUtils testUtils;
    private RMIObjectChannel rmiObjectChannel;
    private MessageHandlerRegistry messageHandlerRegistry;
    private static boolean isSleeStuckInStoppingState = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        Status status;
        TCKTestResult tCKTestResult;
        block43: {
            tCKTestResult = null;
            status = null;
            SleeTCKTest sleeTCKTest = null;
            Test test = null;
            try {
                this.prepare();
                Object object = this.loadTest();
                if (object instanceof SleeTCKTest) {
                    sleeTCKTest = (SleeTCKTest)this.loadTest();
                    sleeTCKTest.init(this.testUtils);
                } else if (object instanceof Test) {
                    test = (Test)object;
                } else {
                    throw new ClassCastException("Test " + object + " was not a SleeTCKTest or a com.sun.javatest.Test");
                }
                if (sleeTCKTest != null) {
                    block42: {
                        try {
                            String string = testDescription.getParameter("title");
                            String string2 = testDescription.getParameter("executeClass");
                            String string3 = testDescription.getParameter("assertions");
                            this.testUtils.getResourceInterface().log(1, "\n\n========================================================================================\n Test title: " + string + "\n" + " Test class: " + string2 + "\n" + " Assertions:  " + string3 + "\n" + "========================================================================================\n");
                        }
                        catch (Exception exception) {
                            this.log.error("An error occured while trying to log a test description to the TCK Resource");
                            this.log.error(exception);
                        }
                        try {
                            try {
                                this.testUtils.getResourceInterface().log(1, "\n\n============\n Test setup \n============");
                            }
                            catch (Exception exception) {
                                this.log.error("An error occured while trying to log a message to the TCK Resource");
                                this.log.error(exception);
                            }
                            sleeTCKTest.setUp();
                            try {
                                try {
                                    this.testUtils.getResourceInterface().log(1, "\n\n===========\n Test body \n===========");
                                }
                                catch (Exception exception) {
                                    this.log.error("An error occured while trying to log a message to the TCK Resource");
                                    this.log.error(exception);
                                }
                                tCKTestResult = sleeTCKTest.run();
                                if (tCKTestResult == null) {
                                    throw new TCKTestErrorException("Tests must return a non-null result from the run() method");
                                }
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof TCKTestFailureException) {
                                    tCKTestResult = TCKTestResult.failed((TCKTestFailureException)throwable);
                                    break block42;
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            try {
                                this.testUtils.getResourceInterface().log(1, "\n\n===============\n Test teardown \n===============");
                            }
                            catch (Exception exception) {
                                this.log.error("An error occured while trying to log a message to the TCK Resource");
                                this.log.error(exception);
                            }
                            sleeTCKTest.tearDown();
                        }
                    }
                    try {
                        this.testUtils.getResourceInterface().log(1, "\n=============\n End of test \n=============\n");
                    }
                    catch (Exception exception) {
                        this.log.error("An error occured while trying to log a message to the TCK Resource");
                        this.log.error(exception);
                    }
                    break block43;
                }
                String string = testDescription.getParameter("executeArgs");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray2[n++] = stringTokenizer.nextToken();
                }
                status = test.run(stringArray2, this.trOut, this.trOut);
            }
            catch (Throwable throwable) {
                this.log.warning(throwable);
                if (sleeTCKTest != null) {
                    if (tCKTestResult == null || tCKTestResult.isPassed()) {
                        tCKTestResult = TCKTestResult.error(throwable);
                    }
                } else if (status == null || status.isPassed()) {
                    status = Status.error((String)throwable.toString());
                }
            }
            finally {
                block44: {
                    try {
                        this.cleanUp();
                    }
                    catch (Throwable throwable) {
                        this.log.warning(throwable);
                        if (sleeTCKTest != null) {
                            if (tCKTestResult.isPassed()) {
                                tCKTestResult = TCKTestResult.error(throwable);
                            }
                        }
                        if (!status.isPassed()) break block44;
                        status = Status.error((String)throwable.toString());
                    }
                }
            }
        }
        return status != null ? status : this.resultToStatus(tCKTestResult);
    }

    private void prepare() throws Exception {
        this.log = new PrintWriterLog(this.trOut);
        this.initParameterMaps();
        int n = Integer.parseInt(this.envParams.getProperty("debugLevel"));
        this.log.setIgnoreLevel(n);
        this.initTimeouts();
        this.initMBeanFacade();
        this.initMgmtMBeanName();
        this.mBeanProxyFactory = new MBeanProxyFactoryImpl(this.mBeanFacade);
        this.lookupResourceInterface();
        this.bindRMIObjectChannel();
        this.bindMessageHandlerRegistry();
        this.testUtils = new SleeTCKTestUtilsImpl(this.testParams, this.envParams, this.mBeanFacade, this.mBeanProxyFactory, this.resourceInterface, this.rmiObjectChannel, this.messageHandlerRegistry, this.log, this.mgmtMBeanName, this.envParams.getProperty("componentUrlPrefix"), this.defaultTimeout, this.testTimeout);
        if (isSleeStuckInStoppingState && this.testUtils.getSleeManagementMBeanProxy().getState().isStopping()) {
            throw new TCKTestErrorException("The SLEE is stuck in the STOPPING state: a previous test timed out while waiting for the SLEE to restart, and the SLEE is still in the STOPPING state.");
        }
        isSleeStuckInStoppingState = false;
        try {
            SleeStarter.startSlee(this.testUtils.getSleeManagementMBeanProxy(), this.defaultTimeout);
        }
        catch (OperationTimedOutException operationTimedOutException) {
            String string = null;
            SleeState sleeState = this.testUtils.getSleeManagementMBeanProxy().getState();
            if (sleeState.isStopping()) {
                isSleeStuckInStoppingState = true;
                string = "Couldn't run the test, because the SLEE is stuck in the STOPPING state";
            } else {
                string = "Couldn't run the test, because the timeout was reached while waiting for the SLEE to reach the RUNNING state. Current state: " + sleeState;
            }
            throw new TCKTestErrorException(string, operationTimedOutException);
        }
        this.ensureCorrectTCKComponents();
        List list = new ProfileUtils(this.testUtils).getTCKStdAddressProfileTables();
        if (!list.isEmpty()) {
            String string = (String)list.get(0);
            throw new TCKTestErrorException("A tck created standard address profile table still exists in the SLEE. TableName=" + string + "\nOne of the pre-conditions of each test is that no such tables may exist prior to a test run.");
        }
    }

    private void cleanUp() throws Exception {
        Boolean bl;
        Vector<Exception> vector = new Vector<Exception>();
        if (this.resourceInterface != null) {
            try {
                this.resourceInterface.clearActivities();
                this.resourceInterface.releaseResources();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.trOut);
                vector.addElement(exception);
            }
            this.resourceInterface = null;
        }
        this.unbindRMIObjectChannel();
        this.unbindMessageHandlerRegistry();
        if (this.testUtils != null) {
            try {
                if (this.testUtils.deactivateAllServices()) {
                    this.log.warning("Test did not deactivate all its own services.");
                }
                if (this.testUtils.uninstallAll()) {
                    this.log.warning("Test did not uninstall all its own SLEE components.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.trOut);
                vector.addElement(exception);
            }
        }
        if (!isSleeStuckInStoppingState && (bl = Boolean.valueOf(this.envParams.getProperty("restartBetweenTests"))).booleanValue()) {
            try {
                this.log.finer("Restart Slee option specified. About to restart Slee...");
                SleeStarter.restartSlee(this.testUtils.getSleeManagementMBeanProxy(), this.defaultTimeout);
                this.log.finer("Slee restarted successfully");
            }
            catch (OperationTimedOutException operationTimedOutException) {
                try {
                    SleeState sleeState = this.testUtils.getSleeManagementMBeanProxy().getState();
                    if (sleeState.isStopping()) {
                        isSleeStuckInStoppingState = true;
                    }
                    throw new TCKTestErrorException("The timeout was reached while trying to restart the SLEE. Current state:" + sleeState);
                }
                catch (Exception exception) {
                    exception.printStackTrace(this.trOut);
                    vector.addElement(exception);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.trOut);
                vector.addElement(exception);
            }
        }
        if (this.remoteSender != null) {
            try {
                this.remoteSender.disconnectReceiver();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.trOut);
                vector.addElement(exception);
            }
            this.remoteSender = null;
        }
        if (this.mBeanFacade != null) {
            try {
                this.mBeanFacade.removeAllNotificationListeners();
            }
            catch (Exception exception) {
                exception.printStackTrace(this.trOut);
                vector.addElement(exception);
            }
            this.mBeanFacade = null;
            this.mBeanProxyFactory = null;
        }
        this.testUtils = null;
        if (vector.size() == 1) {
            throw (Exception)vector.firstElement();
        }
        if (vector.size() > 1) {
            throw new TCKTestErrorException("Multiple Exceptions caught during test cleanup. (Stack traces were written to the log)");
        }
    }

    private void initParameterMaps() throws Exception {
        this.testParams = new Properties();
        Iterator iterator = this.td.getParameterKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.td.getParameter(string);
            this.testParams.setProperty(string, string2);
        }
        this.envParams = new Properties();
        for (String string2 : this.env.keys()) {
            String[] stringArray = this.env.lookup(string2);
            if (stringArray == null || stringArray.length <= 0) continue;
            this.envParams.setProperty(string2, stringArray[0]);
        }
    }

    private void initMBeanFacade() throws Exception {
        try {
            String string = this.envParams.getProperty("jmxAgentHostIP");
            String string2 = this.envParams.getProperty("jmxAgentPort");
            String string3 = "//" + string + ":" + string2 + "/" + "infra.jmx.TCKEventSender";
            this.remoteSender = (TCKEventSenderRemote)Naming.lookup(string3);
            TCKEventListenerRegistry tCKEventListenerRegistry = ClientSetup.setupClient(this.remoteSender);
            this.mBeanFacade = new MBeanFacadeImpl(this.log);
            String string4 = "//" + string + ":" + string2 + "/" + "infra.jmx.MBeanFacadeAgent";
            MBeanFacadeAgentRemote mBeanFacadeAgentRemote = (MBeanFacadeAgentRemote)Naming.lookup(string4);
            this.mBeanFacade.setMBeanFacadeAgentRemote(mBeanFacadeAgentRemote);
            this.mBeanFacade.setListenerRegistry(tCKEventListenerRegistry);
        }
        catch (ConnectException connectException) {
            throw new TCKTestErrorException("Received ConnectException while trying to connect to TCK plugin. Check that the TCK Plugin MBean was successfully registered in the MBeanServer, and that the jmx agent properties are properly configured", connectException);
        }
    }

    private void initMgmtMBeanName() throws Exception {
        String string = this.envParams.getProperty("jmxAgentDomain");
        if (string == null) {
            string = "";
        }
        ObjectName objectName = new ObjectName(string + ":name=SleeTCKPlugin");
        this.mgmtMBeanName = (ObjectName)this.mBeanFacade.invoke(objectName, "getSleeManagementMBean", new Object[0], new String[0]);
    }

    private void initTimeouts() throws Exception {
        this.defaultTimeout = Integer.parseInt(this.envParams.getProperty("defaultTimeout"));
        String string = this.testParams.getProperty("timeout-multiplier");
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                if (d <= 0.0) {
                    throw new TCKTestErrorException("Invalid timeout-multiplier specified: " + d + ". Value must be a positive real number.");
                }
                this.testTimeout = (int)((double)this.defaultTimeout * d);
                this.log.fine("Test timeout value set to " + this.testTimeout + ". (Default timeout " + this.defaultTimeout + " multiplied by timeout-multiplier " + d + ")");
            }
            catch (NumberFormatException numberFormatException) {
                throw new TCKTestErrorException("Invalid timeout-multiplier specified: " + string + ". Value must be a positive real number.", numberFormatException);
            }
        } else {
            this.testTimeout = this.defaultTimeout;
        }
    }

    private void lookupResourceInterface() throws TCKTestErrorException {
        String string = this.envParams.getProperty("tckResourceHostIP");
        String string2 = this.envParams.getProperty("tckResourcePort");
        String string3 = "rmi://" + string + ":" + string2 + "/" + "TCKResourceTestInterface";
        try {
            TCKResourceTestInterface tCKResourceTestInterface = (TCKResourceTestInterface)Naming.lookup(string3);
            this.resourceInterface = new TCKResourceTestInterfaceProxy(tCKResourceTestInterface, this.log);
        }
        catch (RemoteException remoteException) {
            throw new TCKTestErrorException("Exception caught setting up resource interface: ", remoteException);
        }
        catch (NotBoundException notBoundException) {
            throw new TCKTestErrorException("Exception caught setting up resource interface: ", notBoundException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TCKTestErrorException("Exception caught setting up resource interface: ", malformedURLException);
        }
    }

    private void bindRMIObjectChannel() throws TCKTestErrorException {
        try {
            this.rmiObjectChannel = new RMIObjectChannelImpl();
            Naming.bind(this.getRMIObjectChannelName(), this.rmiObjectChannel);
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Exception caught setting up RMIObjectChannel: ", exception);
        }
    }

    private void unbindRMIObjectChannel() throws TCKTestErrorException {
        try {
            UnicastRemoteObject.unexportObject(this.rmiObjectChannel, true);
            Naming.unbind(this.getRMIObjectChannelName());
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Exception caught cleaning up RMIObjectChannel: ", exception);
        }
    }

    private String getRMIObjectChannelName() {
        String string = this.envParams.getProperty("tckResourceHostIP");
        String string2 = this.envParams.getProperty("tckResourcePort");
        String string3 = "rmi://" + string + ":" + string2 + "/" + "RMIObjectChannel";
        return string3;
    }

    private void bindMessageHandlerRegistry() throws TCKTestErrorException {
        try {
            this.messageHandlerRegistry = new MessageHandlerRegistryImpl();
            Naming.bind(this.getMessageHanglerRegistryName(), this.messageHandlerRegistry);
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Exception caught setting up MessageHandlerRegistry: ", exception);
        }
    }

    private void unbindMessageHandlerRegistry() throws TCKTestErrorException {
        try {
            UnicastRemoteObject.unexportObject(this.messageHandlerRegistry, true);
            Naming.unbind(this.getMessageHanglerRegistryName());
        }
        catch (Exception exception) {
            throw new TCKTestErrorException("Exception caught cleaning up MessageHandlerRegistry: ", exception);
        }
    }

    private String getMessageHanglerRegistryName() {
        String string = this.envParams.getProperty("tckResourceHostIP");
        String string2 = this.envParams.getProperty("tckResourcePort");
        String string3 = "rmi://" + string + ":" + string2 + "/" + "MessageHandlerRegistry";
        return string3;
    }

    private Object loadTest() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = this.testParams.getProperty("executeClass");
        Class<?> clazz = this.loader.loadClass(string);
        return clazz.newInstance();
    }

    private void ensureCorrectTCKComponents() throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        int n;
        DeploymentMBeanProxy deploymentMBeanProxy = this.testUtils.getDeploymentMBeanProxy();
        ComponentID[][] componentIDArrayArray = new ComponentID[][]{deploymentMBeanProxy.getEventTypes(), deploymentMBeanProxy.getProfileSpecifications(), deploymentMBeanProxy.getResourceAdaptorTypes(), deploymentMBeanProxy.getSbbs(), deploymentMBeanProxy.getServices()};
        Object[][] objectArray = SleeTCKComponentConstants.EXPECTED_TCK_COMPONENTS_INFO;
        HashMap<Object, Object[]> hashMap = new HashMap<Object, Object[]>();
        for (n = 0; n < objectArray.length; ++n) {
            hashMap.put(objectArray[n][1], objectArray[n]);
        }
        for (n = 0; n < componentIDArrayArray.length; ++n) {
            for (int i = 0; i < componentIDArrayArray[n].length; ++i) {
                Object[] objectArray2;
                Class clazz;
                ComponentID componentID = componentIDArrayArray[n][i];
                ComponentDescriptor componentDescriptor = deploymentMBeanProxy.getDescriptor(componentID);
                if (!"jain.slee.tck".equals(componentDescriptor.getVendor())) continue;
                boolean bl = false;
                String string = componentDescriptor.getName();
                if (hashMap.containsKey(string) && (clazz = (Class)(objectArray2 = (Object[])hashMap.get(string))[0]).isAssignableFrom(componentID.getClass()) && objectArray2[2].equals(componentDescriptor.getVersion())) {
                    bl = true;
                    hashMap.remove(string);
                }
                if (bl) continue;
                throw new TCKTestErrorException("Found unexpected TCK component still installed in the SLEE (probably left by a previous test). ComponentID=" + componentID);
            }
        }
        if (!hashMap.isEmpty()) {
            Object[] objectArray3 = (Object[])hashMap.values().iterator().next();
            StringBuffer stringBuffer = new StringBuffer("Name=" + objectArray3[1]);
            stringBuffer.append(",Type=" + objectArray3[0]);
            stringBuffer.append(",Version=" + objectArray3[2]);
            throw new TCKTestErrorException("Expected TCK component is not installed: " + stringBuffer.toString());
        }
    }

    private Status resultToStatus(TCKTestResult tCKTestResult) {
        Status status = null;
        switch (tCKTestResult.getType()) {
            case 0: {
                status = Status.passed((String)"Test passed");
                break;
            }
            case 1: {
                String string = this.formatFailure(tCKTestResult.getAssertionID(), tCKTestResult.getReason());
                status = Status.failed((String)string);
                break;
            }
            case 2: {
                status = Status.error((String)tCKTestResult.getReason());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal result type: " + tCKTestResult.getType());
            }
        }
        return status;
    }

    private String formatFailure(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Failed assertion ID: ").append(n);
        stringBuffer.append("\nFailure context/reason: ").append(string);
        return stringBuffer.toString();
    }
}

