/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import javax.slee.management.DeployableUnitID;

public abstract class AbstractSleeTCKTest
implements SleeTCKTest {
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils sleeTCKTestUtils) {
        this.utils = sleeTCKTestUtils;
    }

    public TCKTestResult run() throws Exception {
        FutureResult futureResult = new FutureResult(this.utils.getLog());
        this.run(futureResult);
        this.getLog().fine("Test thread is waiting for test result");
        return futureResult.waitForResult(this.utils.getTestTimeout(), "Test did not complete within timeout");
    }

    protected void run(FutureResult futureResult) throws Exception {
    }

    public void setUp() throws Exception {
        this.setupService("serviceDUPath", true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Ending and purging activities");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling all services");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    protected DeployableUnitID setupService(String string) throws Exception {
        return this.setupService(string, true);
    }

    protected DeployableUnitID setupService(String string, boolean bl) throws Exception {
        String string2 = this.utils.getTestParams().getProperty(string);
        this.utils.getLog().fine("Installing and activating service: " + string2);
        DeployableUnitID deployableUnitID = this.utils.install(string2);
        this.utils.activateServices(deployableUnitID, bl);
        return deployableUnitID;
    }

    protected SleeTCKTestUtils utils() {
        return this.utils;
    }

    protected Logable getLog() {
        return this.utils.getLog();
    }

    protected void setResourceListener(TCKResourceListener tCKResourceListener) throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.utils.getResourceInterface().setResourceListener(tCKResourceListener);
    }
}

