/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.logging;

import com.opencloud.logging.LogLevel;
import com.opencloud.logging.LogLevelUtil;
import com.opencloud.logging.Logable;

abstract class AbstractLog
implements Logable,
LogLevel {
    private int ignoreLevel = 1;
    private final boolean showTime;
    private final boolean showLevel;

    AbstractLog() {
        this(1);
    }

    AbstractLog(int n) {
        this(n, true, true);
    }

    AbstractLog(int n, boolean bl, boolean bl2) {
        this.ignoreLevel = LogLevelUtil.isValid(n) ? n : 1;
        this.showTime = bl;
        this.showLevel = bl2;
    }

    public final void debug(String string) {
        this.writeToLog(0, string);
    }

    public final void info(String string) {
        this.writeToLog(1, string);
    }

    public final void normal(String string) {
        this.writeToLog(2, string);
    }

    public final void warning(String string) {
        this.writeToLog(3, string);
    }

    public final void error(String string) {
        this.writeToLog(4, string);
    }

    public final void critical(String string) {
        this.writeToLog(5, string);
    }

    public final void debug(Throwable throwable) {
        this.writeToLog(0, throwable);
    }

    public final void info(Throwable throwable) {
        this.writeToLog(1, throwable);
    }

    public final void normal(Throwable throwable) {
        this.writeToLog(2, throwable);
    }

    public final void warning(Throwable throwable) {
        this.writeToLog(3, throwable);
    }

    public final void error(Throwable throwable) {
        this.writeToLog(4, throwable);
    }

    public final void critical(Throwable throwable) {
        this.writeToLog(5, throwable);
    }

    public void severe(String string) {
        this.writeToLog(11, string);
    }

    public void config(String string) {
        this.writeToLog(14, string);
    }

    public void fine(String string) {
        this.writeToLog(15, string);
    }

    public void finer(String string) {
        this.writeToLog(16, string);
    }

    public void finest(String string) {
        this.writeToLog(17, string);
    }

    public void severe(Throwable throwable) {
        this.writeToLog(11, throwable);
    }

    public void config(Throwable throwable) {
        this.writeToLog(14, throwable);
    }

    public void fine(Throwable throwable) {
        this.writeToLog(15, throwable);
    }

    public void finer(Throwable throwable) {
        this.writeToLog(16, throwable);
    }

    public void finest(Throwable throwable) {
        this.writeToLog(17, throwable);
    }

    public final synchronized void setIgnoreLevel(int n) {
        this.ignoreLevel = n;
    }

    protected final int getIgnoreLevel() {
        return this.ignoreLevel;
    }

    public final synchronized boolean isLogable(int n) {
        return LogLevelUtil.isLogable(n, this.ignoreLevel);
    }

    protected final boolean shouldShowTime() {
        return this.showTime;
    }

    protected final boolean shouldShowLevel() {
        return this.showLevel;
    }
}

