/*
 * Decompiled with CFR 0.152.
 */
package com.opencdk.view.viewpager;

import android.support.v4.view.ViewPager;
import android.view.View;
import com.nineoldandroids.view.ViewHelper;

public class ZoomOutPageTransformer
implements ViewPager.PageTransformer {
    private static float MIN_SCALE = 0.85f;
    private static float MIN_ALPHA = 0.5f;

    public void transformPage(View view, float position) {
        int pageWidth = view.getWidth();
        int pageHeight = view.getHeight();
        if (position < -1.0f) {
            ViewHelper.setAlpha((View)view, (float)0.0f);
        } else if (position <= 1.0f) {
            float scaleFactor = Math.max(MIN_SCALE, 1.0f - Math.abs(position));
            float vertMargin = (float)pageHeight * (1.0f - scaleFactor) / 2.0f;
            float horzMargin = (float)pageWidth * (1.0f - scaleFactor) / 2.0f;
            if (position < 0.0f) {
                ViewHelper.setTranslationX((View)view, (float)(horzMargin - vertMargin / 2.0f));
            } else {
                ViewHelper.setTranslationX((View)view, (float)(-horzMargin + vertMargin / 2.0f));
            }
            ViewHelper.setScaleX((View)view, (float)scaleFactor);
            ViewHelper.setScaleY((View)view, (float)scaleFactor);
            ViewHelper.setAlpha((View)view, (float)(MIN_ALPHA + (scaleFactor - MIN_SCALE) / (1.0f - MIN_SCALE) * (1.0f - MIN_ALPHA)));
        } else {
            ViewHelper.setAlpha((View)view, (float)0.0f);
        }
    }
}

