/*
 * Decompiled with CFR 0.152.
 */
package com.opencdk.view.viewpager;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.opencdk.view.viewpager.AutoScrollPagerAdapter;
import com.opencdk.view.viewpager.AutoScrollViewPager;
import com.opencdk.view.viewpager.IPagerAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class AutoScrollableView<T>
extends AutoScrollViewPager
implements IPagerAdapter {
    private static final String TAG = "AutoScrollableView";
    private ArrayList<T> mItemList = new ArrayList();
    private AutoScrollPagerAdapter<T> mScrollAdapter;

    public AutoScrollableView(Context context) {
        super(context);
    }

    public AutoScrollableView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void addItem(T item) {
        this.mItemList.add(item);
        this.mScrollAdapter.addItem(item);
    }

    public void addItems(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        if (this.mItemList != null && this.mItemList.isEmpty()) {
            this.mItemList.addAll(items);
        } else {
            this.mItemList.addAll(items);
        }
        this.mScrollAdapter = new AutoScrollPagerAdapter<T>(this.mItemList, this);
        this.setAdapter(this.mScrollAdapter);
    }

    public List<T> getItemList() {
        return this.mItemList;
    }

    public T getItem(int position) {
        return this.getItemList().get(position % this.mItemList.size());
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    @Override
    public void restoreState(Parcelable state, ClassLoader loader) {
    }

    @Override
    public Parcelable saveState() {
        return null;
    }
}

