/*
 * Decompiled with CFR 0.152.
 */
package com.opencdk.view.viewpager;

import android.content.Context;
import android.os.Handler;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import com.opencdk.view.viewpager.AutoScrollPagerAdapter;
import com.opencdk.view.viewpager.AutoScroller;
import com.opencdk.view.viewpager.ViewPagerCompat;
import java.lang.reflect.Field;

public class AutoScrollViewPager
extends ViewPagerCompat {
    private static final String TAG = "AutoScrollViewPager";
    private static final int SCROLL_PERIOD_DEFAULT = 3000;
    private long mScrollPeriod = 3000L;
    private int mBeginIndex = 0;
    private boolean mAutoScrollable = false;
    private boolean mStopped = false;
    private AutoScroller mAutoScroller;
    private Handler mHandler = new Handler();
    private Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            AutoScrollViewPager.this.scrollSelf();
            AutoScrollViewPager.this.mHandler.postDelayed((Runnable)this, AutoScrollViewPager.this.mScrollPeriod);
        }
    };

    public AutoScrollViewPager(Context context) {
        super(context);
        this.setUp();
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUp();
    }

    private void setUp() {
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (action == 0) {
            this.stopScroll();
        } else if (ev.getAction() == 1) {
            this.resumeScroll();
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setLoadingImage(int resid) {
    }

    public void startAutoScroll(int duration) {
        this.startAutoScroll(duration, 0);
    }

    public void startAutoScroll(int duration, int position) {
        this.mScrollPeriod = duration;
        this.mBeginIndex = this.getAdapter() instanceof AutoScrollPagerAdapter ? position + 10000 * ((AutoScrollPagerAdapter)this.getAdapter()).getCountReal() : position + 10000 * this.getAdapter().getCount();
        this.mAutoScrollable = true;
        this.setCurrentItem(this.mBeginIndex);
        this.mHandler.removeCallbacks(this.mScrollRunnable);
        this.mHandler.postDelayed(this.mScrollRunnable, this.mScrollPeriod);
    }

    public void resumeScroll() {
        if (this.mStopped) {
            this.mHandler.removeCallbacks(this.mScrollRunnable);
            this.mHandler.postDelayed(this.mScrollRunnable, this.mScrollPeriod);
        }
    }

    public void changeScrollPeriod(int duration) {
        this.mScrollPeriod = duration;
    }

    public void stopScroll() {
        this.mHandler.removeCallbacks(this.mScrollRunnable);
        this.mStopped = true;
    }

    protected void scrollSelf() {
        Field field = null;
        if (this.mAutoScroller == null) {
            this.mAutoScroller = new AutoScroller(this.getContext(), (Interpolator)new AccelerateInterpolator());
        }
        try {
            field = ViewPagerCompat.class.getDeclaredField("mScroller");
            field.setAccessible(true);
            field.set((Object)this, (Object)this.mAutoScroller);
            this.mAutoScroller.setFactor(6.0);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        int newPosition = this.getCurrentItem() + 1;
        this.setCurrentItem(newPosition, true);
        try {
            field = ViewPagerCompat.class.getDeclaredField("mScroller");
            field.setAccessible(true);
            field.set((Object)this, (Object)this.mAutoScroller);
            this.mAutoScroller.setFactor(2.0);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }
}

