/*
 * Decompiled with CFR 0.152.
 */
package com.opencdk.view.viewpager;

import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.opencdk.view.viewpager.IPagerAdapter;
import java.util.ArrayList;
import java.util.List;

public class AutoScrollPagerAdapter<T>
extends PagerAdapter {
    private List<T> mList = new ArrayList<T>();
    private IPagerAdapter mIPagerAdapter;

    public AutoScrollPagerAdapter(List<T> list, IPagerAdapter callback) {
        if (list != null) {
            this.mList = list;
        }
        this.mIPagerAdapter = callback;
    }

    public void addItem(T item) {
        this.mList.add(item);
        this.notifyDataSetChanged();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.mIPagerAdapter != null) {
            this.mIPagerAdapter.destroyItem(container, position, object);
        }
    }

    public int getCount() {
        return Integer.MAX_VALUE;
    }

    public int getCountReal() {
        return this.mList.size();
    }

    public Object instantiateItem(ViewGroup view, int position) {
        if (this.mIPagerAdapter != null) {
            return this.mIPagerAdapter.instantiateItem(view, position);
        }
        throw new NullPointerException("Returns a <NULL> representing the new page.");
    }

    public boolean isViewFromObject(View view, Object object) {
        if (this.mIPagerAdapter != null) {
            return this.mIPagerAdapter.isViewFromObject(view, object);
        }
        return false;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (this.mIPagerAdapter != null) {
            this.mIPagerAdapter.restoreState(state, loader);
        }
    }

    public Parcelable saveState() {
        if (this.mIPagerAdapter != null) {
            return this.mIPagerAdapter.saveState();
        }
        return super.saveState();
    }
}

