/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.os.Process;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.OpenAtlasUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenAtlasFileLock {
    static final Logger log = LoggerFactory.getInstance("OpenAtlasFileLock");
    private static String processName;
    private static OpenAtlasFileLock singleton;
    private Map<String, FileLockCount> mRefCountMap = new ConcurrentHashMap<String, FileLockCount>();

    public static OpenAtlasFileLock getInstance() {
        if (singleton == null) {
            singleton = new OpenAtlasFileLock();
        }
        return singleton;
    }

    private int RefCntInc(String filePath, FileLock fileLock, RandomAccessFile randomAccessFile, FileChannel fileChannel) {
        Integer valueOf;
        Integer.valueOf(0);
        if (this.mRefCountMap.containsKey(filePath)) {
            FileLockCount fileLockCount = this.mRefCountMap.get(filePath);
            int i = fileLockCount.mRefCount;
            fileLockCount.mRefCount = i + 1;
            valueOf = i;
        } else {
            valueOf = 1;
            this.mRefCountMap.put(filePath, new FileLockCount(fileLock, valueOf, randomAccessFile, fileChannel));
        }
        return valueOf;
    }

    private int RefCntDec(String filePath) {
        Integer valueOf = 0;
        if (this.mRefCountMap.containsKey(filePath)) {
            int i;
            FileLockCount fileLockCount = this.mRefCountMap.get(filePath);
            fileLockCount.mRefCount = i = fileLockCount.mRefCount - 1;
            valueOf = i;
            if (valueOf <= 0) {
                this.mRefCountMap.remove(filePath);
            }
        }
        return valueOf;
    }

    public boolean LockExclusive(File bundleDexFile) {
        if (bundleDexFile == null) {
            return false;
        }
        try {
            RandomAccessFile randomAccessFile;
            FileChannel channel;
            FileLock lock;
            File lockFile = new File(bundleDexFile.getParentFile().getAbsolutePath().concat("/lock"));
            if (!lockFile.exists()) {
                lockFile.createNewFile();
            }
            if (!(lock = (channel = (randomAccessFile = new RandomAccessFile(lockFile.getAbsolutePath(), "rw")).getChannel()).lock()).isValid()) {
                return false;
            }
            this.RefCntInc(lockFile.getAbsolutePath(), lock, randomAccessFile, channel);
            return true;
        }
        catch (Exception e) {
            log.error(processName + " FileLock " + bundleDexFile.getParentFile().getAbsolutePath().concat("/lock") + " Lock FAIL! " + e.getMessage());
            return false;
        }
    }

    public void unLock(File bundleDexFile) {
        FileLockCount fileLockCount;
        File lockFile = new File(bundleDexFile.getParentFile().getAbsolutePath().concat("/lock"));
        if (!lockFile.exists()) {
            return;
        }
        if ((lockFile == null || this.mRefCountMap.containsKey(lockFile.getAbsolutePath())) && (fileLockCount = this.mRefCountMap.get(lockFile.getAbsolutePath())) != null) {
            FileLock fileLock = fileLockCount.mFileLock;
            RandomAccessFile randomAccessFile = fileLockCount.fOs;
            FileChannel fileChannel = fileLockCount.fChannel;
            try {
                if (this.RefCntDec(lockFile.getAbsolutePath()) <= 0) {
                    if (fileLock != null && fileLock.isValid()) {
                        fileLock.release();
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
            }
            catch (IOException e) {
                log.error(processName + " FileLock " + bundleDexFile.getParentFile().getAbsolutePath().concat("/lock") + " unlock FAIL! " + e.getMessage());
            }
        }
    }

    static {
        if (RuntimeVariables.androidApplication.getApplicationContext() != null) {
            processName = OpenAtlasUtils.getProcessNameByPID(Process.myPid());
        }
    }

    private class FileLockCount {
        FileChannel fChannel;
        RandomAccessFile fOs;
        FileLock mFileLock;
        int mRefCount;

        FileLockCount(FileLock fileLock, int mRefCount, RandomAccessFile fOs, FileChannel fChannel) {
            this.mFileLock = fileLock;
            this.mRefCount = mRefCount;
            this.fOs = fOs;
            this.fChannel = fChannel;
        }
    }
}

