/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import com.openatlas.hack.AssertionArrayException;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.PackageLite;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ApkUtils {
    static final int SYSTEM_ROOT_STATE_DISABLE = 0;
    static final int SYSTEM_ROOT_STATE_ENABLE = 1;
    static final int SYSTEM_ROOT_STATE_UNKNOW = -1;
    static final Logger log = LoggerFactory.getInstance("ApkUtils");
    private static int systemRootState = -1;

    private static boolean assertAtlasHacks() {
        try {
            return OpenAtlasHacks.defineAndVerify();
        }
        catch (AssertionArrayException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final PackageInfo parsePackageInfo(Context context, String path) {
        if (!ApkUtils.assertAtlasHacks()) {
            return null;
        }
        try {
            PackageLite parse = PackageLite.parse(new File(path));
            PackageInfo packageInfo = new PackageInfo();
            packageInfo.packageName = parse.packageName;
            packageInfo.versionCode = parse.versionCode;
            packageInfo.versionName = parse.versionName;
            packageInfo.applicationInfo = new ApplicationInfo();
            packageInfo.applicationInfo.metaData = parse.metaData;
            return packageInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getApkPublicKey(String apkPath) {
        JarFile jarFile = null;
        try {
            Certificate[] loadCertificates;
            jarFile = new JarFile(apkPath);
            JarEntry jarEntry = jarFile.getJarEntry("classes.dex");
            if (jarEntry != null && (loadCertificates = ApkUtils.loadCertificates(jarFile, jarEntry, new byte[4096])) != null) {
                String[] strArr = new String[loadCertificates.length];
                for (int i = 0; i < loadCertificates.length; ++i) {
                    strArr[i] = ApkUtils.bytesToHexString(loadCertificates[i].getPublicKey().getEncoded());
                }
            }
        }
        catch (IOException e) {
            jarFile = null;
            log.warn("Exception reading public key from apk file " + apkPath, (Throwable)e);
            String[] stringArray = null;
            return stringArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
            jarFile = null;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    private static Certificate[] loadCertificates(JarFile jarFile, JarEntry jarEntry, byte[] bytes) {
        Certificate[] certificates = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            while (((InputStream)bufferedInputStream).read(bytes, 0, bytes.length) != -1) {
            }
            ((InputStream)bufferedInputStream).close();
            if (jarEntry != null) {
                certificates = jarEntry.getCertificates();
            }
        }
        catch (Throwable e) {
            log.warn("Exception reading " + jarEntry.getName() + " in " + jarFile.getName(), e);
        }
        return certificates;
    }

    private static final String bytesToHexString(byte[] bArr) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bArr == null || bArr.length <= 0) {
            return null;
        }
        for (int i = 0; i < bArr.length; ++i) {
            String toHexString = Integer.toHexString(bArr[i] & 0xFF);
            if (toHexString.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(toHexString);
        }
        return stringBuilder.toString();
    }

    public static final void chmod(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
            try {
                Runtime.getRuntime().exec("chmod 555 " + file.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isRootSystem() {
        if (systemRootState == -1) {
            String[] strArr = new String[]{"/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
            int length = strArr.length;
            for (int i = 0; i < length; ++i) {
                if (!new File(strArr[i], "su").exists()) continue;
                systemRootState = 1;
                return true;
            }
            return false;
        }
        return systemRootState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            int read;
            fileOutputStream = new FileOutputStream(file);
            fileChannel = fileOutputStream.getChannel();
            byte[] bArr = new byte[4096];
            while ((read = inputStream.read(bArr)) > 0) {
                fileChannel.write(ByteBuffer.wrap(bArr, 0, read));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e22) {
                    e22.printStackTrace();
                }
            }
        }
    }

    public static boolean validFileMD5(String path, String md5Sum) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            File mFile = new File(path);
            if (mFile == null || !mFile.exists() || !mFile.isFile()) {
                return false;
            }
            FileInputStream in = new FileInputStream(mFile);
            FileChannel ch = in.getChannel();
            MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, mFile.length());
            messageDigest.update(byteBuffer);
            String digest = String.format("%032x", new BigInteger(1, messageDigest.digest()));
            return md5Sum.equals(digest.toString());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

