/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.Fragment;
import android.app.Instrumentation;
import android.app.UiAutomation;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.framework.BundleClassLoader;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.hack.Hack;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.log.OpenAtlasMonitor;
import com.openatlas.runtime.ClassLoadFromBundle;
import com.openatlas.runtime.ContextImplHook;
import com.openatlas.runtime.DelegateClassLoader;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.DelegateResources;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.osgi.framework.BundleException;

public class InstrumentationHook
extends Instrumentation {
    static final Logger log = LoggerFactory.getInstance("InstrumentationHook");
    private Context context;
    private Instrumentation mBase;
    private Hack.HackedClass<Object> mInstrumentationInvoke;
    private Hack.HackedMethod mExecStartActivity;
    private Hack.HackedMethod mExecStartActivityFragment;

    public InstrumentationHook(Instrumentation instrumentation, Context context) {
        this.context = context;
        this.mBase = instrumentation;
        try {
            this.mInstrumentationInvoke = Hack.into("android.app.Instrumentation");
            this.mExecStartActivity = Build.VERSION.SDK_INT > 15 ? this.mInstrumentationInvoke.method("execStartActivity", Context.class, IBinder.class, IBinder.class, Activity.class, Intent.class, Integer.TYPE, Bundle.class) : this.mInstrumentationInvoke.method("execStartActivity", Context.class, IBinder.class, IBinder.class, Activity.class, Intent.class, Integer.TYPE);
            if (Build.VERSION.SDK_INT > 22) {
                log.debug("current  sdk  > LOLLIPOP,skip hack");
            } else {
                this.mExecStartActivityFragment = Build.VERSION.SDK_INT > 15 ? this.mInstrumentationInvoke.method("execStartActivity", Context.class, IBinder.class, IBinder.class, Fragment.class, Intent.class, Integer.TYPE, Bundle.class) : this.mInstrumentationInvoke.method("execStartActivity", Context.class, IBinder.class, IBinder.class, Fragment.class, Intent.class, Integer.TYPE);
            }
        }
        catch (Hack.HackDeclaration.HackAssertionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void HandleResourceNotFound(Activity activity, Bundle bundle, Exception exception) {
        if (OpenAtlasHacks.ContextThemeWrapper_mResources != null) {
            String detailMessage;
            try {
                List<String> assetPathFromResources = this.getAssetPathFromResources(OpenAtlasHacks.ContextThemeWrapper_mResources.get((ContextThemeWrapper)activity));
                detailMessage = "(1)Paths in ContextThemeWrapper_mResources:" + assetPathFromResources + " paths in runtime:" + DelegateResources.getAssetHistoryPaths();
            }
            catch (Exception e) {
                detailMessage = "(2)paths in runtime:" + DelegateResources.getAssetHistoryPaths() + " getAssetPath fail: " + e;
            }
            throw new RuntimeException(detailMessage, exception);
        }
        throw new RuntimeException("(3)ContextThemeWrapper_mResources is null paths in runtime:" + DelegateResources.getAssetHistoryPaths(), exception);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
        return this.execStartActivityInternal(this.context, intent, new ExecStartActivityCallbackImpl(who, contextThread, token, target, intent, requestCode));
    }

    @TargetApi(value=16)
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle bundle) {
        return this.execStartActivityInternal(this.context, intent, new ExecStartActivityCallbackImpl_JELLY_BEAN(who, contextThread, token, target, intent, requestCode, bundle));
    }

    @TargetApi(value=14)
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment fragment, Intent intent, int requestCode) {
        return this.execStartActivityInternal(this.context, intent, new ExecStartFrgmentImpl_ICE_CREAM_SANDWICH(who, contextThread, token, fragment, intent, requestCode));
    }

    @TargetApi(value=16)
    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment fragment, Intent intent, int requestCode, Bundle bundle) {
        return this.execStartActivityInternal(this.context, intent, new ExecStartFrgmentImpl_JELLY_BEAN(who, contextThread, token, fragment, intent, requestCode, bundle));
    }

    private Instrumentation.ActivityResult execStartActivityInternal(Context context, Intent intent, ExecStartActivityCallback execStartActivityCallback) {
        String packageName = null;
        String mComponentName = null;
        Instrumentation.ActivityResult activityResult = null;
        if (intent.getComponent() != null) {
            packageName = intent.getComponent().getPackageName();
            mComponentName = intent.getComponent().getClassName();
        } else {
            ResolveInfo resolveActivity = context.getPackageManager().resolveActivity(intent, 0);
            if (resolveActivity != null && resolveActivity.activityInfo != null) {
                packageName = resolveActivity.activityInfo.packageName;
                mComponentName = resolveActivity.activityInfo.name;
            }
        }
        if (mComponentName == null) {
            try {
                return execStartActivityCallback.execStartActivity();
            }
            catch (Exception e) {
                log.error("Failed to start Activity for " + packageName + " " + mComponentName + e);
                return activityResult;
            }
        }
        try {
            ClassLoadFromBundle.checkInstallBundleIfNeed(mComponentName);
            if (!StringUtils.equals(context.getPackageName(), packageName)) {
                return execStartActivityCallback.execStartActivity();
            }
            if (DelegateComponent.locateComponent(mComponentName) != null) {
                return execStartActivityCallback.execStartActivity();
            }
            try {
                if (Framework.getSystemClassLoader().loadClass(mComponentName) != null) {
                    return execStartActivityCallback.execStartActivity();
                }
                return activityResult;
            }
            catch (ClassNotFoundException e) {
                OpenAtlasMonitor.getInstance().trace(-1, mComponentName, "", "Failed to load bundle even in system classloader", (Throwable)e);
                log.error("Can't find class " + mComponentName);
                this.fallBackToClassNotFoundCallback(context, intent, mComponentName);
                return activityResult;
            }
        }
        catch (Exception e3) {
            log.error("Failed to load bundle for " + mComponentName + e3);
            this.fallBackToClassNotFoundCallback(context, intent, mComponentName);
            return activityResult;
        }
    }

    private void fallBackToClassNotFoundCallback(Context context, Intent intent, String className) {
        if (Framework.getClassNotFoundCallback() != null) {
            if (intent.getComponent() == null && !TextUtils.isEmpty((CharSequence)className)) {
                intent.setClassName(context, className);
            }
            if (intent.getComponent() != null) {
                Framework.getClassNotFoundCallback().returnIntent(intent);
            }
        }
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo activityInfo, CharSequence title, Activity parent, String id, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        Activity newActivity = this.mBase.newActivity(clazz, context, token, application, intent, activityInfo, title, parent, id, lastNonConfigurationInstance);
        if (RuntimeVariables.androidApplication.getPackageName().equals(activityInfo.packageName) && OpenAtlasHacks.ContextThemeWrapper_mResources != null) {
            OpenAtlasHacks.ContextThemeWrapper_mResources.set((ContextThemeWrapper)newActivity, RuntimeVariables.delegateResources);
        }
        return newActivity;
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Activity newActivity;
        String defaultBootActivityName = null;
        try {
            newActivity = this.mBase.newActivity(cl, className, intent);
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundException classNotFoundException = e;
            String property = Framework.getProperty("com.openatlas.welcome.Welcome", "com.openatlas.launcher.welcome");
            if (TextUtils.isEmpty((CharSequence)property)) {
                defaultBootActivityName = "com.openatlas.launcher.welcome";
            } else {
                String string = property;
            }
            if (TextUtils.isEmpty((CharSequence)defaultBootActivityName)) {
                throw classNotFoundException;
            }
            List runningTasks = ((ActivityManager)this.context.getSystemService("activity")).getRunningTasks(1);
            if (runningTasks != null && runningTasks.size() > 0 && ((ActivityManager.RunningTaskInfo)runningTasks.get((int)0)).numActivities > 1 && Framework.getClassNotFoundCallback() != null) {
                if (intent.getComponent() == null) {
                    intent.setClassName(this.context, className);
                }
                Framework.getClassNotFoundCallback().returnIntent(intent);
            }
            log.warn("Could not find activity class: " + className);
            log.warn("Redirect to welcome activity: " + defaultBootActivityName);
            newActivity = this.mBase.newActivity(cl, defaultBootActivityName, intent);
        }
        if (cl instanceof DelegateClassLoader && OpenAtlasHacks.ContextThemeWrapper_mResources != null) {
            OpenAtlasHacks.ContextThemeWrapper_mResources.set((ContextThemeWrapper)newActivity, RuntimeVariables.delegateResources);
        }
        return newActivity;
    }

    private List<String> getAssetPathFromResources(Resources resources) {
        try {
            return DelegateResources.getOriginAssetsPath((AssetManager)OpenAtlasHacks.Resources_mAssets.get(resources));
        }
        catch (Exception e) {
            log.debug("DelegateResource" + e.getCause());
            return null;
        }
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        if (RuntimeVariables.androidApplication.getPackageName().equals(activity.getPackageName())) {
            String property;
            ContextImplHook contextImplHook = new ContextImplHook(activity.getBaseContext(), activity.getClass().getClassLoader());
            if (OpenAtlasHacks.ContextThemeWrapper_mBase != null && OpenAtlasHacks.ContextThemeWrapper_mBase.getField() != null) {
                OpenAtlasHacks.ContextThemeWrapper_mBase.set((ContextThemeWrapper)activity, (Object)contextImplHook);
            }
            OpenAtlasHacks.ContextWrapper_mBase.set((ContextWrapper)activity, (Object)contextImplHook);
            if (activity.getClass().getClassLoader() instanceof BundleClassLoader) {
                try {
                    ((BundleClassLoader)activity.getClass().getClassLoader()).getBundle().startBundle();
                }
                catch (BundleException e) {
                    log.error(e.getMessage() + " Caused by: ", e.getNestedException());
                }
            }
            if (TextUtils.isEmpty((CharSequence)(property = Framework.getProperty("com.openatlas.welcome.Welcome", "com.openatlas.welcome.Welcome")))) {
                property = "com.openatlas.welcome.Welcome";
            }
            try {
                this.ensureResourcesInjected(activity);
                this.mBase.callActivityOnCreate(activity, icicle);
                return;
            }
            catch (Exception e2) {
                if (!e2.toString().contains("android.content.res.Resources") || e2.toString().contains("OutOfMemoryError")) {
                    e2.printStackTrace();
                }
                this.HandleResourceNotFound(activity, icicle, e2);
                return;
            }
        }
        this.mBase.callActivityOnCreate(activity, icicle);
    }

    @TargetApi(value=18)
    public UiAutomation getUiAutomation() {
        return this.mBase.getUiAutomation();
    }

    public void onCreate(Bundle bundle) {
        this.mBase.onCreate(bundle);
    }

    public void start() {
        this.mBase.start();
    }

    public void onStart() {
        this.mBase.onStart();
    }

    public boolean onException(Object obj, Throwable th) {
        return this.mBase.onException(obj, th);
    }

    public void sendStatus(int i, Bundle bundle) {
        this.mBase.sendStatus(i, bundle);
    }

    public void finish(int i, Bundle bundle) {
        this.mBase.finish(i, bundle);
    }

    public void setAutomaticPerformanceSnapshots() {
        this.mBase.setAutomaticPerformanceSnapshots();
    }

    public void startPerformanceSnapshot() {
        this.mBase.startPerformanceSnapshot();
    }

    public void endPerformanceSnapshot() {
        this.mBase.endPerformanceSnapshot();
    }

    private void ensureResourcesInjected(Activity activity) {
        ContextImplHook contextImplHook = new ContextImplHook(activity.getBaseContext(), activity.getClass().getClassLoader());
        if (OpenAtlasHacks.ContextThemeWrapper_mResources != null) {
            try {
                this.validateActivityResource(activity);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            OpenAtlasHacks.ContextThemeWrapper_mResources.set((ContextThemeWrapper)activity, RuntimeVariables.delegateResources);
        }
        if (OpenAtlasHacks.ContextThemeWrapper_mBase != null && OpenAtlasHacks.ContextThemeWrapper_mBase.getField() != null) {
            OpenAtlasHacks.ContextThemeWrapper_mBase.set((ContextThemeWrapper)activity, (Object)contextImplHook);
        }
        OpenAtlasHacks.ContextWrapper_mBase.set((ContextWrapper)activity, (Object)contextImplHook);
    }

    private boolean validateActivityResource(Activity activity) {
        Resources delegateResource;
        String logInfo = null;
        BundleImpl bundleImpl = (BundleImpl)Framework.getBundle(BundleInfoList.getInstance().getBundleNameForComponet(activity.getLocalClassName()));
        String absolutePath = bundleImpl != null ? bundleImpl.getArchive().getArchiveFile().getAbsolutePath() : null;
        Resources resources = OpenAtlasHacks.ContextThemeWrapper_mResources != null ? OpenAtlasHacks.ContextThemeWrapper_mResources.get((ContextThemeWrapper)activity) : activity.getResources();
        if (resources == (delegateResource = RuntimeVariables.delegateResources)) {
            return true;
        }
        List<String> assetPathFromResources = this.getAssetPathFromResources(resources);
        String assetHistoryPaths = DelegateResources.getAssetHistoryPaths();
        List<String> assetPathFromDelegateResources = this.getAssetPathFromResources(delegateResource);
        if (absolutePath != null && assetPathFromResources != null && !assetPathFromResources.contains(absolutePath)) {
            logInfo = "Activity Resources path not contains:" + bundleImpl.getArchive().getArchiveFile().getAbsolutePath();
            if (!assetHistoryPaths.contains(absolutePath)) {
                logInfo = logInfo + "paths in history not contains:" + bundleImpl.getArchive().getArchiveFile().getAbsolutePath();
            }
            if (!assetPathFromDelegateResources.contains(absolutePath)) {
                logInfo = logInfo + "paths in runtime not contains:" + bundleImpl.getArchive().getArchiveFile().getAbsolutePath();
            }
            if (!bundleImpl.getArchive().getArchiveFile().exists()) {
                logInfo = logInfo + "  Bundle archive file not exist:" + bundleImpl.getArchive().getArchiveFile().getAbsolutePath();
            }
            logInfo = logInfo + " Activity Resources paths length:" + assetPathFromResources.size();
        }
        if (logInfo == null) {
            return true;
        }
        OpenAtlasMonitor.getInstance().trace(-4, "", "", logInfo);
        return false;
    }

    public void onDestroy() {
        this.mBase.onDestroy();
    }

    public Context getContext() {
        return this.mBase.getContext();
    }

    public ComponentName getComponentName() {
        return this.mBase.getComponentName();
    }

    public Context getTargetContext() {
        return this.mBase.getTargetContext();
    }

    public boolean isProfiling() {
        return this.mBase.isProfiling();
    }

    public void startProfiling() {
        this.mBase.startProfiling();
    }

    public void stopProfiling() {
        this.mBase.stopProfiling();
    }

    public void setInTouchMode(boolean inTouch) {
        this.mBase.setInTouchMode(inTouch);
    }

    public void waitForIdle(Runnable runnable) {
        this.mBase.waitForIdle(runnable);
    }

    public void waitForIdleSync() {
        this.mBase.waitForIdleSync();
    }

    public void runOnMainSync(Runnable runnable) {
        this.mBase.runOnMainSync(runnable);
    }

    public Activity startActivitySync(Intent intent) {
        return this.mBase.startActivitySync(intent);
    }

    public void addMonitor(Instrumentation.ActivityMonitor monitor) {
        this.mBase.addMonitor(monitor);
    }

    public Instrumentation.ActivityMonitor addMonitor(IntentFilter filter, Instrumentation.ActivityResult result, boolean block) {
        return this.mBase.addMonitor(filter, result, block);
    }

    public Instrumentation.ActivityMonitor addMonitor(String cls, Instrumentation.ActivityResult result, boolean block) {
        return this.mBase.addMonitor(cls, result, block);
    }

    public boolean checkMonitorHit(Instrumentation.ActivityMonitor monitor, int minHits) {
        return this.mBase.checkMonitorHit(monitor, minHits);
    }

    public Activity waitForMonitor(Instrumentation.ActivityMonitor monitor) {
        return this.mBase.waitForMonitor(monitor);
    }

    public Activity waitForMonitorWithTimeout(Instrumentation.ActivityMonitor monitor, long timeOut) {
        return this.mBase.waitForMonitorWithTimeout(monitor, timeOut);
    }

    public void removeMonitor(Instrumentation.ActivityMonitor monitor) {
        this.mBase.removeMonitor(monitor);
    }

    public boolean invokeMenuActionSync(Activity targetActivity, int id, int flag) {
        return this.mBase.invokeMenuActionSync(targetActivity, id, flag);
    }

    public boolean invokeContextMenuAction(Activity targetActivity, int id, int flag) {
        return this.mBase.invokeContextMenuAction(targetActivity, id, flag);
    }

    public void sendStringSync(String text) {
        this.mBase.sendStringSync(text);
    }

    public void sendKeySync(KeyEvent keyEvent) {
        this.mBase.sendKeySync(keyEvent);
    }

    public void sendKeyDownUpSync(int key) {
        this.mBase.sendKeyDownUpSync(key);
    }

    public void sendCharacterSync(int keyCode) {
        this.mBase.sendCharacterSync(keyCode);
    }

    public void sendPointerSync(MotionEvent motionEvent) {
        this.mBase.sendPointerSync(motionEvent);
    }

    public void sendTrackballEventSync(MotionEvent motionEvent) {
        this.mBase.sendTrackballEventSync(motionEvent);
    }

    public Application newApplication(ClassLoader classLoader, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.mBase.newApplication(classLoader, className, context);
    }

    public void callApplicationOnCreate(Application application) {
        this.mBase.callApplicationOnCreate(application);
    }

    public void callActivityOnDestroy(Activity activity) {
        this.mBase.callActivityOnDestroy(activity);
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle) {
        this.mBase.callActivityOnRestoreInstanceState(activity, bundle);
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle) {
        this.mBase.callActivityOnPostCreate(activity, bundle);
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        this.mBase.callActivityOnNewIntent(activity, intent);
    }

    public void callActivityOnStart(Activity activity) {
        this.mBase.callActivityOnStart(activity);
    }

    public void callActivityOnRestart(Activity activity) {
        this.mBase.callActivityOnRestart(activity);
    }

    public void callActivityOnResume(Activity activity) {
        this.mBase.callActivityOnResume(activity);
    }

    public void callActivityOnStop(Activity activity) {
        this.mBase.callActivityOnStop(activity);
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle) {
        this.mBase.callActivityOnSaveInstanceState(activity, bundle);
    }

    public void callActivityOnPause(Activity activity) {
        this.mBase.callActivityOnPause(activity);
    }

    public void callActivityOnUserLeaving(Activity activity) {
        this.mBase.callActivityOnUserLeaving(activity);
    }

    public void startAllocCounting() {
        this.mBase.startAllocCounting();
    }

    public void stopAllocCounting() {
        this.mBase.stopAllocCounting();
    }

    public Bundle getAllocCounts() {
        return this.mBase.getAllocCounts();
    }

    public Bundle getBinderCounts() {
        return this.mBase.getBinderCounts();
    }

    class ExecStartFrgmentImpl_JELLY_BEAN
    implements ExecStartActivityCallback {
        final IBinder contextThread;
        final Intent intent;
        final Bundle options;
        final int requestCode;
        final Fragment target;
        final IBinder token;
        final Context who;

        ExecStartFrgmentImpl_JELLY_BEAN(Context context, IBinder contextThread, IBinder token, Fragment fragment, Intent intent, int requestCode, Bundle options) {
            this.who = context;
            this.contextThread = contextThread;
            this.token = token;
            this.target = fragment;
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = options;
        }

        @Override
        public Instrumentation.ActivityResult execStartActivity() {
            if (InstrumentationHook.this.mExecStartActivityFragment == null) {
                throw new NullPointerException("could not hook Instrumentation!");
            }
            try {
                return (Instrumentation.ActivityResult)InstrumentationHook.this.mExecStartActivityFragment.invoke(InstrumentationHook.this.mBase, this.who, this.contextThread, this.token, this.target, this.intent, this.requestCode, this.options);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class ExecStartFrgmentImpl_ICE_CREAM_SANDWICH
    implements ExecStartActivityCallback {
        final IBinder contextThread;
        final Intent intent;
        final int requestCode;
        final Fragment target;
        final IBinder token;
        final Context who;

        ExecStartFrgmentImpl_ICE_CREAM_SANDWICH(Context context, IBinder contextThread, IBinder token, Fragment fragment, Intent intent, int requestCode) {
            this.who = context;
            this.contextThread = contextThread;
            this.token = token;
            this.target = fragment;
            this.intent = intent;
            this.requestCode = requestCode;
        }

        @Override
        public Instrumentation.ActivityResult execStartActivity() {
            if (InstrumentationHook.this.mExecStartActivityFragment == null) {
                throw new NullPointerException("could not hook Instrumentation!");
            }
            try {
                return (Instrumentation.ActivityResult)InstrumentationHook.this.mExecStartActivityFragment.invoke(InstrumentationHook.this.mBase, this.who, this.contextThread, this.token, this.target, this.intent, this.requestCode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class ExecStartActivityCallbackImpl_JELLY_BEAN
    implements ExecStartActivityCallback {
        final IBinder contextThread;
        final Intent intent;
        final Bundle options;
        final int requestCode;
        final Activity target;
        final IBinder token;
        final Context who;

        ExecStartActivityCallbackImpl_JELLY_BEAN(Context context, IBinder contextThread, IBinder token, Activity activity, Intent intent, int requestCode, Bundle options) {
            this.who = context;
            this.contextThread = contextThread;
            this.token = token;
            this.target = activity;
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = options;
        }

        @Override
        public Instrumentation.ActivityResult execStartActivity() {
            if (InstrumentationHook.this.mExecStartActivity == null) {
                throw new NullPointerException("could not hook Instrumentation!");
            }
            try {
                return (Instrumentation.ActivityResult)InstrumentationHook.this.mExecStartActivity.invoke(InstrumentationHook.this.mBase, this.who, this.contextThread, this.token, this.target, this.intent, this.requestCode, this.options);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class ExecStartActivityCallbackImpl
    implements ExecStartActivityCallback {
        final IBinder contextThread;
        final Intent intent;
        final int requestCode;
        final Activity target;
        final IBinder token;
        final Context who;

        ExecStartActivityCallbackImpl(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
            this.who = InstrumentationHook.this.context;
            this.contextThread = contextThread;
            this.token = token;
            this.target = target;
            this.intent = intent;
            this.requestCode = requestCode;
        }

        @Override
        public Instrumentation.ActivityResult execStartActivity() {
            if (InstrumentationHook.this.mExecStartActivity == null) {
                throw new NullPointerException("could not hook Instrumentation!");
            }
            try {
                if (Build.VERSION.SDK_INT > 15) {
                    return (Instrumentation.ActivityResult)InstrumentationHook.this.mExecStartActivity.invoke(InstrumentationHook.this.mBase, this.who, this.contextThread, this.token, this.target, this.intent, this.requestCode, null);
                }
                return (Instrumentation.ActivityResult)InstrumentationHook.this.mExecStartActivity.invoke(InstrumentationHook.this.mBase, this.who, this.contextThread, this.token, this.target, this.intent, this.requestCode);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static interface ExecStartActivityCallback {
        public Instrumentation.ActivityResult execStartActivity();
    }
}

