/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.app.Application;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.openatlas.framework.Framework;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.BundleLifecycleHandler;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.DelegateResources;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.StringUtils;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class FrameworkLifecycleHandler
implements FrameworkListener {
    static final Logger log = LoggerFactory.getInstance("FrameworkLifecycleHandler");

    @Override
    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        switch (frameworkEvent.getType()) {
            case 0: {
                this.starting();
                break;
            }
            case 1: {
                this.started();
                break;
            }
            default: {
                log.warn("frameworkEvent unsupported event >>" + frameworkEvent.getType());
            }
        }
    }

    private void starting() {
        String string;
        Bundle bundle;
        long currentTimeMillis = System.currentTimeMillis();
        try {
            bundle = RuntimeVariables.androidApplication.getPackageManager().getApplicationInfo((String)RuntimeVariables.androidApplication.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            bundle = null;
        }
        if (bundle != null && StringUtils.isNotEmpty(string = bundle.getString("application"))) {
            String[] split;
            if (log.isDebugEnabled()) {
                log.debug("Found extra application: " + string);
            }
            if ((split = StringUtils.split(string, ",")) == null || split.length == 0) {
                split = new String[]{string};
            }
            for (String extraApplication : split) {
                try {
                    Application newApplication = BundleLifecycleHandler.newApplication(extraApplication, Framework.getSystemClassLoader());
                    newApplication.onCreate();
                    DelegateComponent.apkApplications.put("system:" + extraApplication, newApplication);
                }
                catch (Throwable e) {
                    log.error("Error to start application", e);
                }
            }
        }
        log.info("starting() spend " + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds");
    }

    private void started() {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            DelegateResources.newDelegateResources(RuntimeVariables.androidApplication, RuntimeVariables.delegateResources, null);
        }
        catch (Throwable e) {
            log.error("Failed to newDelegateResources", e);
        }
        log.info("started() spend " + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds");
    }
}

