/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.app.Application;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.hack.AndroidHack;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.log.OpenAtlasMonitor;
import com.openatlas.runtime.RuntimeVariables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;

public class DelegateResources
extends Resources {
    private static final String WebViewGoogleAssetPath = "/system/app/WebViewGoogle/WebViewGoogle.apk";
    private static Set<String> assetPathsHistory;
    private static Object lock;
    static final Logger log;
    private static boolean ignoreOpt;
    private static final String[] ignoreOptBrands;
    private static List<String> mOriginAssetsPath;
    private Map<String, Integer> resIdentifierMap = new ConcurrentHashMap<String, Integer>();

    public DelegateResources(AssetManager assetManager, Resources resources) {
        super(assetManager, resources.getDisplayMetrics(), resources.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newDelegateResources(Application application, Resources resources, String newPath) throws Exception {
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            DelegateResources.newDelegateResourcesInternal(application, resources, newPath);
            return;
        }
        Object object = lock;
        synchronized (object) {
            new Handler(Looper.getMainLooper()).post((Runnable)new DelegateResourcesGetter(application, resources, newPath));
            lock.wait();
        }
    }

    private static void newDelegateResourcesInternal(Application application, Resources resources, String newPath) throws Exception {
        if (ignoreOpt || Build.VERSION.SDK_INT <= 20 || assetPathsHistory == null) {
            Set<String> generateNewAssetPaths = DelegateResources.generateNewAssetPaths(application, newPath);
            if (generateNewAssetPaths != null) {
                DelegateResources delegateResources;
                AssetManager assetManager = (AssetManager)AssetManager.class.newInstance();
                for (String assetPath : generateNewAssetPaths) {
                    try {
                        if (Integer.parseInt(OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, assetPath).toString()) != 0) continue;
                        for (int i = 0; i < 3 && Integer.parseInt(OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, assetPath).toString()) == 0; ++i) {
                            if (i != 3) continue;
                            OpenAtlasMonitor.getInstance().trace(-1, assetPath, "", "Add asset path failed");
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                if (resources == null || !resources.getClass().getName().equals("android.content.res.MiuiResources")) {
                    delegateResources = new DelegateResources(assetManager, resources);
                } else {
                    Constructor<?> declaredConstructor = Class.forName("android.content.res.MiuiResources").getDeclaredConstructor(AssetManager.class, DisplayMetrics.class, Configuration.class);
                    declaredConstructor.setAccessible(true);
                    delegateResources = (Resources)declaredConstructor.newInstance(assetManager, resources.getDisplayMetrics(), resources.getConfiguration());
                }
                RuntimeVariables.delegateResources = delegateResources;
                AndroidHack.injectResources(application, delegateResources);
                assetPathsHistory = generateNewAssetPaths;
                if (log.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("newDelegateResources [");
                    for (String append : generateNewAssetPaths) {
                        stringBuffer.append(append).append(",");
                    }
                    stringBuffer.append("]");
                    if (newPath != null) {
                        stringBuffer.append("Add new path:" + newPath);
                    }
                    log.debug(stringBuffer.toString());
                    return;
                }
                return;
            }
            return;
        }
        AssetManager assetManager = application.getAssets();
        if (!TextUtils.isEmpty((CharSequence)newPath) && !assetPathsHistory.contains(newPath)) {
            OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, newPath);
            assetPathsHistory.add(newPath);
        }
    }

    public static List<String> getOriginAssetsPath(AssetManager assetManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Method declaredMethod = assetManager.getClass().getDeclaredMethod("getStringBlockCount", new Class[0]);
            declaredMethod.setAccessible(true);
            int intValue = (Integer)declaredMethod.invoke((Object)assetManager, new Object[0]);
            for (int i = 0; i < intValue; ++i) {
                String cookieName = (String)assetManager.getClass().getMethod("getCookieName", Integer.TYPE).invoke((Object)assetManager, i + 1);
                if (TextUtils.isEmpty((CharSequence)cookieName)) continue;
                arrayList.add(cookieName);
            }
            return arrayList;
        }
        catch (Exception th) {
            th.printStackTrace();
            arrayList.clear();
            return arrayList;
        }
    }

    public static String getAssetHistoryPaths() {
        if (assetPathsHistory == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("newDelegateResources [");
        for (String append : assetPathsHistory) {
            stringBuffer.append(append).append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static Set<String> generateNewAssetPaths(Application application, String newPath) {
        if (newPath != null && assetPathsHistory != null && assetPathsHistory.contains(newPath)) {
            return null;
        }
        LinkedHashSet<String> mGenerateNewSet = new LinkedHashSet<String>();
        mGenerateNewSet.add(application.getApplicationInfo().sourceDir);
        if (ignoreOpt && Build.VERSION.SDK_INT > 20) {
            mGenerateNewSet.add(WebViewGoogleAssetPath);
        }
        try {
            if (mOriginAssetsPath == null && Build.VERSION.SDK_INT > 20 && !ignoreOpt) {
                mOriginAssetsPath = DelegateResources.getOriginAssetsPath(application.getResources().getAssets());
                mGenerateNewSet.addAll(mOriginAssetsPath);
            }
        }
        catch (Throwable th) {
            log.error("get original asset path exception:", th);
            OpenAtlasMonitor.getInstance().trace(-4, newPath, "", "get original asset path exception:", th);
        }
        if (assetPathsHistory != null) {
            mGenerateNewSet.addAll(assetPathsHistory);
        }
        if (newPath != null) {
            mGenerateNewSet.add(newPath);
        }
        return mGenerateNewSet;
    }

    public int getIdentifier(String name, String defType, String defPackage) {
        int identifier = super.getIdentifier(name, defType, defPackage);
        if (identifier != 0) {
            return identifier;
        }
        if (Build.VERSION.SDK_INT <= 19) {
            return 0;
        }
        if (defType == null && defPackage == null) {
            String substring = name.substring(name.indexOf("/") + 1);
            defType = name.substring(name.indexOf(":") + 1, name.indexOf("/"));
            name = substring;
        }
        if (TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)defType)) {
            return 0;
        }
        List<Bundle> bundles = Framework.getBundles();
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : Framework.getBundles()) {
                ClassLoader classLoader;
                int intValue;
                String location = bundle.getLocation();
                String nameWithPkg = location + ":" + name;
                if (!this.resIdentifierMap.isEmpty() && this.resIdentifierMap.containsKey(nameWithPkg) && (intValue = this.resIdentifierMap.get(nameWithPkg).intValue()) != 0) {
                    return intValue;
                }
                BundleImpl bundleImpl = (BundleImpl)bundle;
                if (!bundleImpl.getArchive().isDexOpted() || (classLoader = bundleImpl.getClassLoader()) == null) continue;
                try {
                    StringBuilder stringBuilder = new StringBuilder(location);
                    stringBuilder.append(".R$");
                    stringBuilder.append(defType);
                    identifier = DelegateResources.getFieldValueOfR(classLoader.loadClass(stringBuilder.toString()), name);
                    if (identifier == 0) continue;
                    this.resIdentifierMap.put(nameWithPkg, identifier);
                    return identifier;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return 0;
    }

    public String getString(int id) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT < 21 || id != 0x2040002 && id != 262146 && id != 50593794) {
            return super.getString(id);
        }
        return "Web View";
    }

    private static int getFieldValueOfR(Class<?> cls, String name) {
        if (cls != null) {
            try {
                Field declaredField = cls.getDeclaredField(name);
                if (declaredField != null) {
                    if (!declaredField.isAccessible()) {
                        declaredField.setAccessible(true);
                    }
                    return (Integer)declaredField.get(null);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        ignoreOptBrands = new String[]{"Sony", "SEMC"};
        log = LoggerFactory.getInstance("DelegateResources");
        lock = new Object();
        for (String mBrand : ignoreOptBrands) {
            if (!Build.BRAND.equalsIgnoreCase(mBrand)) continue;
            ignoreOpt = true;
            break;
        }
        mOriginAssetsPath = null;
    }

    static class DelegateResourcesGetter
    implements Runnable {
        Application application;
        String newPath;
        Resources res;

        public DelegateResourcesGetter(Application application, Resources res, String newPath) {
            this.application = application;
            this.res = res;
            this.newPath = newPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DelegateResources.newDelegateResourcesInternal(this.application, this.res, this.newPath);
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        }
    }
}

