/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.text.TextUtils;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.ClassLoadFromBundle;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.StringUtils;
import org.osgi.framework.BundleException;

public class ContextImplHook
extends ContextWrapper {
    static final Logger log = LoggerFactory.getInstance("ContextImplHook");
    private ClassLoader classLoader = null;

    public ContextImplHook(Context context, ClassLoader classLoader) {
        super(context);
        this.classLoader = classLoader;
    }

    public Resources getResources() {
        return RuntimeVariables.delegateResources;
    }

    public AssetManager getAssets() {
        return RuntimeVariables.delegateResources.getAssets();
    }

    public PackageManager getPackageManager() {
        return this.getApplicationContext().getPackageManager();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return super.getClassLoader();
    }

    public void startActivity(Intent intent) {
        block12: {
            String packageName;
            String mComponentName = null;
            if (intent.getComponent() != null) {
                packageName = intent.getComponent().getPackageName();
                mComponentName = intent.getComponent().getClassName();
            } else {
                ResolveInfo resolveActivity = this.getBaseContext().getPackageManager().resolveActivity(intent, 0);
                if (resolveActivity == null || resolveActivity.activityInfo == null) {
                    packageName = null;
                } else {
                    packageName = resolveActivity.activityInfo.packageName;
                    mComponentName = resolveActivity.activityInfo.name;
                }
            }
            ClassLoadFromBundle.checkInstallBundleIfNeed(mComponentName);
            if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
                super.startActivity(intent);
            } else if (DelegateComponent.locateComponent(mComponentName) != null) {
                super.startActivity(intent);
            } else {
                try {
                    if (Framework.getSystemClassLoader().loadClass(mComponentName) != null) {
                        super.startActivity(intent);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error("Can't find class " + mComponentName);
                    if (Framework.getClassNotFoundCallback() == null) break block12;
                    if (intent.getComponent() == null && !TextUtils.isEmpty((CharSequence)mComponentName)) {
                        intent.setClassName((Context)this, mComponentName);
                    }
                    if (intent.getComponent() == null) break block12;
                    Framework.getClassNotFoundCallback().returnIntent(intent);
                }
            }
        }
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        String packageName;
        String mComponentName = null;
        if (service.getComponent() != null) {
            packageName = service.getComponent().getPackageName();
            mComponentName = service.getComponent().getClassName();
        } else {
            ResolveInfo resolveService = this.getBaseContext().getPackageManager().resolveService(service, 0);
            if (resolveService == null || resolveService.serviceInfo == null) {
                packageName = null;
            } else {
                packageName = resolveService.serviceInfo.packageName;
                mComponentName = resolveService.serviceInfo.name;
            }
        }
        if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
            return super.bindService(service, conn, flags);
        }
        ClassLoadFromBundle.checkInstallBundleIfNeed(mComponentName);
        packageName = DelegateComponent.locateComponent(mComponentName);
        if (packageName != null) {
            BundleImpl bundleImpl = (BundleImpl)Framework.getBundle(packageName);
            if (bundleImpl != null) {
                try {
                    bundleImpl.startBundle();
                }
                catch (BundleException e) {
                    log.error(e.getMessage() + " Caused by: ", e.getNestedException());
                }
            }
            return super.bindService(service, conn, flags);
        }
        try {
            if (Framework.getSystemClassLoader().loadClass(mComponentName) != null) {
                return super.bindService(service, conn, flags);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Can't find class " + mComponentName);
        }
        return false;
    }

    public ComponentName startService(Intent service) {
        String mComponentName;
        String packageName;
        if (service.getComponent() != null) {
            packageName = service.getComponent().getPackageName();
            mComponentName = service.getComponent().getClassName();
        } else {
            ResolveInfo resolveService = this.getBaseContext().getPackageManager().resolveService(service, 0);
            if (resolveService == null || resolveService.serviceInfo == null) {
                mComponentName = null;
                packageName = null;
            } else {
                packageName = resolveService.serviceInfo.packageName;
                mComponentName = resolveService.serviceInfo.name;
            }
        }
        if (!StringUtils.equals(this.getBaseContext().getPackageName(), packageName)) {
            return super.startService(service);
        }
        ClassLoadFromBundle.checkInstallBundleIfNeed(mComponentName);
        packageName = DelegateComponent.locateComponent(mComponentName);
        if (packageName != null) {
            BundleImpl bundleImpl = (BundleImpl)Framework.getBundle(packageName);
            if (bundleImpl != null) {
                try {
                    bundleImpl.startBundle();
                }
                catch (BundleException e) {
                    log.error(e.getMessage() + " Caused by: ", e.getNestedException());
                }
            }
            return super.startService(service);
        }
        try {
            if (Framework.getSystemClassLoader().loadClass(mComponentName) != null) {
                return super.startService(service);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error("Can't find class " + mComponentName);
            return null;
        }
    }
}

