/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.Handler;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.framework.OpenAtlas;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.log.OpenAtlasMonitor;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.PackageLite;
import com.openatlas.runtime.RuntimeVariables;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;

public class ClassLoadFromBundle {
    private static final String TAG = "ClassLoadFromBundle";
    private static Hashtable<Integer, String> classNotFoundReason;
    private static int reasonCnt;
    public static List<String> sInternalBundles;
    static ZipFile sZipFile;
    static Logger log;

    public static String getClassNotFoundReason(String className) {
        for (int i = 0; i < classNotFoundReason.size(); ++i) {
            if (!(classNotFoundReason.get(i) + "").contains(className + "")) continue;
            return classNotFoundReason.get(i) + "";
        }
        return "";
    }

    private static void insertToReasonList(String className, String reason) {
        int i;
        classNotFoundReason.put(reasonCnt, " Not found class " + className + " because " + reason);
        reasonCnt = i = reasonCnt + 1;
        reasonCnt = i % 10;
    }

    public static String getPackageNameFromEntryName(String pkgName) {
        String archive = "lib/" + AtlasConfig.PRELOAD_DIR + "/lib";
        return pkgName.substring(pkgName.indexOf(archive) + archive.length(), pkgName.indexOf(".so")).replace("_", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void resolveInternalBundles() {
        Class<ClassLoadFromBundle> clazz = ClassLoadFromBundle.class;
        synchronized (ClassLoadFromBundle.class) {
            if (sInternalBundles == null || sInternalBundles.size() == 0) {
                String str = "lib/" + AtlasConfig.PRELOAD_DIR + "/libcom_";
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    sZipFile = new ZipFile(RuntimeVariables.androidApplication.getApplicationInfo().sourceDir);
                    Enumeration<? extends ZipEntry> entries = sZipFile.entries();
                    while (entries.hasMoreElements()) {
                        String name = entries.nextElement().getName();
                        if (!name.startsWith(str) || !name.endsWith(".so")) continue;
                        arrayList.add(ClassLoadFromBundle.getPackageNameFromEntryName(name));
                    }
                    sInternalBundles = arrayList;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception while get bundles in assets or lib", (Throwable)e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static Class<?> loadFromInstalledBundles(String componet) throws ClassNotFoundException {
        BundleImpl bundleImpl;
        Class<?> cls = null;
        List<Bundle> bundles = Framework.getBundles();
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : bundles) {
                bundleImpl = (BundleImpl)bundle;
                PackageLite packageLite = DelegateComponent.getPackage(bundleImpl.getLocation());
                if (packageLite == null || !packageLite.components.contains(componet)) continue;
                bundleImpl.getArchive().optDexFile();
                ClassLoader classLoader = bundleImpl.getClassLoader();
                if (classLoader != null) {
                    try {
                        cls = classLoader.loadClass(componet);
                        if (cls != null) {
                            return cls;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Can't find class " + componet + " in BundleClassLoader: " + bundleImpl.getLocation() + " [" + (bundles == null ? 0 : bundles.size()) + "]" + "classloader is: " + (classLoader == null ? "null" : "not null") + " packageversion " + ClassLoadFromBundle.getPackageVersion() + " exception:" + e.getMessage());
                    }
                }
                StringBuilder append = new StringBuilder().append("Can't find class ").append(componet).append(" in BundleClassLoader: ").append(bundleImpl.getLocation()).append(" [");
                throw new ClassNotFoundException(append.append(bundles.size()).append("]").append(classLoader == null ? "classloader is null" : "classloader not null").append(" packageversion ").append(ClassLoadFromBundle.getPackageVersion()).toString());
            }
        }
        if (bundles != null && !bundles.isEmpty()) {
            for (Bundle bundle : Framework.getBundles()) {
                ClassLoader classLoader;
                bundleImpl = (BundleImpl)bundle;
                if (!bundleImpl.getArchive().isDexOpted() || (classLoader = bundleImpl.getClassLoader()) == null) continue;
                try {
                    cls = classLoader.loadClass(componet);
                    if (cls == null) continue;
                    return cls;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return cls;
    }

    public static void checkInstallBundleAndDependency(String location) {
        List<String> dependencyForBundle = BundleInfoList.getInstance().getDependencyForBundle(location);
        if (dependencyForBundle != null && dependencyForBundle.size() > 0) {
            for (int i = 0; i < dependencyForBundle.size(); ++i) {
                ClassLoadFromBundle.checkInstallBundleAndDependency(dependencyForBundle.get(i));
            }
        }
        if (OpenAtlas.getInstance().getBundle(location) == null) {
            String concat = "lib".concat(location.replace(".", "_")).concat(".so");
            File file = new File(new File(Framework.getProperty("com.openatlas.AppDirectory"), "lib"), concat);
            if (file.exists()) {
                try {
                    if (ClassLoadFromBundle.checkAvailableDisk()) {
                        OpenAtlas.getInstance().installBundle(location, file);
                        return;
                    }
                    log.error("disk size not enough");
                    OpenAtlasMonitor.getInstance().trace(-1, location, "", "disk size not enough");
                }
                catch (Throwable e) {
                    log.error("failed to install bundle " + location, e);
                    OpenAtlasMonitor.getInstance().trace(-1, location, "", "failed to install bundle ", e);
                    throw new RuntimeException("OpenAtlas failed to install bundle " + location, e);
                }
                return;
            }
            if (sInternalBundles == null) {
                ClassLoadFromBundle.resolveInternalBundles();
            }
            if (sInternalBundles == null || !sInternalBundles.contains(location)) {
                log.error(" can not find the library " + concat + " for bundle" + location);
                OpenAtlasMonitor.getInstance().trace(-1, "" + location, "", "can not find the library " + concat);
            } else {
                ClassLoadFromBundle.installFromApkZip(location, concat);
            }
        }
    }

    private static void installFromApkZip(String location, String fileName) {
        try {
            if (ClassLoadFromBundle.checkAvailableDisk()) {
                OpenAtlas.getInstance().installBundle(location, sZipFile.getInputStream(sZipFile.getEntry("lib/" + AtlasConfig.PRELOAD_DIR + "/" + fileName)));
            }
        }
        catch (Exception e) {
            log.debug("Failed to install bundle " + fileName + " from APK zipfile ");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInstallBundleIfNeed(String componet) {
        String string = componet;
        synchronized (string) {
            String location;
            if (sInternalBundles == null) {
                ClassLoadFromBundle.resolveInternalBundles();
            }
            if (TextUtils.isEmpty((CharSequence)(location = BundleInfoList.getInstance().getBundleNameForComponet(componet)))) {
                Log.e((String)TAG, (String)("Failed to find the bundle in BundleInfoList for component " + componet));
                ClassLoadFromBundle.insertToReasonList(componet, "not found in BundleInfoList!");
            }
            if (sInternalBundles == null || sInternalBundles.contains(location)) {
                ClassLoadFromBundle.checkInstallBundleAndDependency(location);
                return;
            }
        }
    }

    private static long getAvailableInternalMemorySize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
    }

    private static boolean checkAvailableDisk() {
        if (ClassLoadFromBundle.getAvailableInternalMemorySize() >= 0x200000L) {
            return true;
        }
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)RuntimeVariables.androidApplication, (CharSequence)"checkAvailableDisk error", (int)0).show();
            }
        });
        return false;
    }

    private static int getPackageVersion() {
        PackageInfo packageInfo;
        try {
            packageInfo = RuntimeVariables.androidApplication.getPackageManager().getPackageInfo(RuntimeVariables.androidApplication.getPackageName(), 0);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Error to get PackageInfo >>>", (Throwable)e);
            packageInfo = new PackageInfo();
        }
        return packageInfo.versionCode;
    }

    static {
        sZipFile = null;
        classNotFoundReason = new Hashtable();
        reasonCnt = 0;
        log = LoggerFactory.getInstance(TAG);
    }
}

