/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.runtime;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.DelegateComponent;
import com.openatlas.runtime.DelegateResources;
import com.openatlas.runtime.PackageLite;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class BundleLifecycleHandler
implements SynchronousBundleListener {
    static final Logger log = LoggerFactory.getInstance("BundleLifecycleHandler");

    @Override
    @SuppressLint(value={"NewApi"})
    public void bundleChanged(BundleEvent bundleEvent) {
        switch (bundleEvent.getType()) {
            case 0: {
                this.loaded(bundleEvent.getBundle());
                break;
            }
            case 1: {
                this.installed(bundleEvent.getBundle());
                break;
            }
            case 2: {
                if (this.isLewaOS()) {
                    if (Looper.myLooper() == null) {
                        Looper.prepare();
                    }
                    this.started(bundleEvent.getBundle());
                    break;
                }
                if (Framework.isFrameworkStartupShutdown()) {
                    BundleStartTask bundleStartTask = new BundleStartTask();
                    if (Build.VERSION.SDK_INT > 11) {
                        bundleStartTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Bundle[]{bundleEvent.getBundle()});
                        return;
                    }
                    bundleStartTask.execute(new Bundle[]{bundleEvent.getBundle()});
                    break;
                }
                this.started(bundleEvent.getBundle());
                break;
            }
            case 4: {
                this.stopped(bundleEvent.getBundle());
                break;
            }
            case 8: {
                this.updated(bundleEvent.getBundle());
                break;
            }
            case 16: {
                this.uninstalled(bundleEvent.getBundle());
                break;
            }
        }
    }

    private void loaded(Bundle bundle) {
        long currentTimeMillis = System.currentTimeMillis();
        BundleImpl bundleImpl = (BundleImpl)bundle;
        try {
            DelegateResources.newDelegateResources(RuntimeVariables.androidApplication, RuntimeVariables.delegateResources, bundleImpl.getArchive().getArchiveFile().getAbsolutePath());
        }
        catch (Throwable e) {
            log.error("Could not load resource in bundle " + bundleImpl.getLocation(), e);
        }
        if (DelegateComponent.getPackage(bundle.getLocation()) == null) {
            PackageLite parse = PackageLite.parse(bundleImpl.getArchive().getArchiveFile());
            log.info("Bundle installation info " + bundle.getLocation() + ":" + parse.components);
            DelegateComponent.putPackage(bundle.getLocation(), parse);
        }
        log.info("loaded() spend " + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds");
    }

    private void installed(Bundle bundle) {
    }

    private void updated(Bundle bundle) {
    }

    private void uninstalled(Bundle bundle) {
        DelegateComponent.removePackage(bundle.getLocation());
    }

    private void started(Bundle bundle) {
        String applicationClassName;
        BundleImpl bundleImpl = (BundleImpl)bundle;
        long currentTimeMillis = System.currentTimeMillis();
        PackageLite packageLite = DelegateComponent.getPackage(bundleImpl.getLocation());
        if (packageLite != null && StringUtils.isNotEmpty(applicationClassName = packageLite.applicationClassName)) {
            try {
                BundleLifecycleHandler.newApplication(applicationClassName, bundleImpl.getClassLoader()).onCreate();
            }
            catch (Throwable throwable) {
                log.error("Error to start application >>>", throwable);
            }
        }
        log.info("started() spend " + (System.currentTimeMillis() - currentTimeMillis) + " milliseconds");
    }

    protected static Application newApplication(String applicationClassName, ClassLoader classLoader) throws Exception {
        Class<?> loadClass = classLoader.loadClass(applicationClassName);
        if (loadClass == null) {
            throw new ClassNotFoundException(applicationClassName);
        }
        Application application = (Application)loadClass.newInstance();
        OpenAtlasHacks.Application_attach.invoke(application, RuntimeVariables.androidApplication);
        return application;
    }

    private void stopped(Bundle bundle) {
        Application application = DelegateComponent.apkApplications.get(bundle.getLocation());
        if (application != null) {
            application.onTerminate();
            DelegateComponent.apkApplications.remove(bundle.getLocation());
        }
    }

    public void handleLowMemory() {
    }

    private boolean isLewaOS() {
        try {
            return StringUtils.isNotEmpty((String)Class.forName("android.os.SystemProperties").getDeclaredMethod("get", String.class).invoke(null, "ro.lewa.version"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private class BundleStartTask
    extends AsyncTask<Bundle, Void, Void> {
        private BundleStartTask() {
        }

        protected Void doInBackground(Bundle ... bundles) {
            BundleLifecycleHandler.this.started(bundles[0]);
            return null;
        }
    }
}

