/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.log;

import com.openatlas.log.IMonitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public class OpenAtlasMonitor
implements IMonitor {
    public static final int BUNDLE_INSTALL_FAIL = -1;
    public static final int DELETE_STORAGE_FAIL = -2;
    public static final int RESOURCES_FAIL = -4;
    public static final int WRITE_META_FAIL = -3;
    private static IMonitor externalMonitor;
    private static OpenAtlasMonitor singleton;

    public static OpenAtlasMonitor getInstance() {
        if (singleton == null) {
            singleton = new OpenAtlasMonitor();
        }
        return singleton;
    }

    public static void setExternalMonitor(IMonitor iMonitor) {
        externalMonitor = iMonitor;
    }

    public void trace(String monitorType, String bundleName, String voidTag, String info, Throwable th) {
        if (th != null) {
            StringWriter stringWriter = new StringWriter();
            th.printStackTrace(new PrintWriter(stringWriter));
            String stringWriter2 = ((Object)stringWriter).toString();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("errorStr", stringWriter2);
            this.trace(monitorType, bundleName, voidTag, info + " " + ((Object)hashMap).toString());
            return;
        }
        this.trace(monitorType, bundleName, voidTag, info);
    }

    public void trace(Integer monitorType, String bundleName, String voidTag, String info, Throwable th) {
        this.trace(monitorType.toString(), bundleName, voidTag, info, th);
    }

    @Override
    public void trace(String monitorType, String bundleName, String voidTag, String info) {
        if (externalMonitor != null) {
            externalMonitor.trace(monitorType, bundleName, voidTag, info);
        }
    }

    @Override
    public void trace(Integer monitorType, String bundleName, String voidTag, String info) {
        if (externalMonitor != null) {
            externalMonitor.trace(monitorType, bundleName, voidTag, info);
        }
    }
}

