/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.log;

import android.util.Log;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;

public class AndroidLogger
implements Logger {
    private final String category;

    public AndroidLogger(String str) {
        this.category = str;
    }

    public AndroidLogger(Class<?> cls) {
        this(cls.getSimpleName());
    }

    @Override
    public void verbose(String message) {
        Log.v((String)this.category, (String)message);
    }

    @Override
    public void debug(String message) {
        Log.d((String)this.category, (String)message);
    }

    @Override
    public void info(String message) {
        Log.i((String)this.category, (String)message);
    }

    @Override
    public void warn(String message) {
        Log.w((String)this.category, (String)message);
    }

    @Override
    public void warn(String message, Throwable th) {
        Log.w((String)message, (Throwable)th);
    }

    @Override
    public void warn(StringBuffer stringBuffer, Throwable th) {
        this.warn(stringBuffer.toString(), th);
    }

    @Override
    public void error(String message) {
        Log.e((String)this.category, (String)message);
    }

    @Override
    public void error(String message, Throwable th) {
        Log.e((String)this.category, (String)message, (Throwable)th);
    }

    @Override
    public void error(StringBuffer stringBuffer, Throwable th) {
        this.error(stringBuffer.toString(), th);
    }

    @Override
    public void fatal(String message) {
        this.error(message);
    }

    @Override
    public void fatal(String message, Throwable th) {
        this.error(message, th);
    }

    @Override
    public boolean isVerboseEnabled() {
        return LoggerFactory.logLevel <= 2;
    }

    @Override
    public boolean isDebugEnabled() {
        return LoggerFactory.logLevel <= 3;
    }

    @Override
    public boolean isInfoEnabled() {
        return LoggerFactory.logLevel <= 4;
    }

    @Override
    public boolean isWarnEnabled() {
        return LoggerFactory.logLevel <= 5;
    }

    @Override
    public boolean isErrorEnabled() {
        return LoggerFactory.logLevel <= 6;
    }

    @Override
    public boolean isFatalEnabled() {
        return LoggerFactory.logLevel <= 6;
    }
}

