/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework.bundlestorage;

import android.content.res.AssetManager;
import android.os.Build;
import android.text.TextUtils;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.dexopt.InitExecutor;
import com.openatlas.framework.Framework;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.ApkUtils;
import com.openatlas.util.OpenAtlasFileLock;
import com.openatlas.util.StringUtils;
import dalvik.system.DexClassLoader;
import dalvik.system.DexFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleArchiveRevision {
    static final String BUNDLE_FILE_NAME = "bundle.zip";
    static final String BUNDLE_LEX_FILE = "bundle.lex";
    static final String BUNDLE_ODEX_FILE = "bundle.dex";
    static final String FILE_PROTOCOL = "file:";
    static final String REFERENCE_PROTOCOL = "reference:";
    static final Logger log = LoggerFactory.getInstance("BundleArchiveRevision");
    private final File bundleFile;
    private ClassLoader dexClassLoader;
    private DexFile dexFile;
    private boolean isDexFileUsed;
    private Manifest manifest;
    private final File revisionDir;
    private final String revisionLocation;
    private final long revisionNum;
    private ZipFile zipFile;

    BundleArchiveRevision(String location, long revisionNum, File revisionDir, InputStream inputStream) throws IOException {
        boolean withNativeLib = false;
        this.revisionNum = revisionNum;
        this.revisionDir = revisionDir;
        if (!this.revisionDir.exists()) {
            this.revisionDir.mkdirs();
        }
        this.revisionLocation = FILE_PROTOCOL;
        this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
        ApkUtils.copyInputStreamToFile(inputStream, this.bundleFile);
        BundleInfoList instance = BundleInfoList.getInstance();
        instance.dumpBundleInfos();
        withNativeLib = instance.getHasSO(location);
        if (withNativeLib) {
            this.installSoLib(this.bundleFile);
        }
        this.updateMetadata();
    }

    BundleArchiveRevision(String packageName, long revisionNum, File revisionDir, File archiveFile) throws IOException {
        boolean hasSO = false;
        this.revisionNum = revisionNum;
        this.revisionDir = revisionDir;
        BundleInfoList instance = BundleInfoList.getInstance();
        if (instance != null && instance.getHasSO(packageName)) {
            hasSO = true;
        }
        if (!this.revisionDir.exists()) {
            this.revisionDir.mkdirs();
        }
        if (archiveFile.canWrite()) {
            if (this.isSameDriver(revisionDir, archiveFile)) {
                this.revisionLocation = FILE_PROTOCOL;
                this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
                archiveFile.renameTo(this.bundleFile);
            } else {
                this.revisionLocation = FILE_PROTOCOL;
                this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
                ApkUtils.copyInputStreamToFile(new FileInputStream(archiveFile), this.bundleFile);
            }
            if (hasSO) {
                this.installSoLib(this.bundleFile);
            }
        } else if (Build.HARDWARE.toLowerCase().contains("mt6592") && archiveFile.getName().endsWith(".so")) {
            this.revisionLocation = FILE_PROTOCOL;
            this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
            Runtime.getRuntime().exec(String.format("ln -s %s %s", archiveFile.getAbsolutePath(), this.bundleFile.getAbsolutePath()));
            if (hasSO) {
                this.installSoLib(archiveFile);
            }
        } else if (OpenAtlasHacks.LexFile == null || OpenAtlasHacks.LexFile.getmClass() == null) {
            this.revisionLocation = REFERENCE_PROTOCOL + archiveFile.getAbsolutePath();
            this.bundleFile = archiveFile;
            if (hasSO) {
                this.installSoLib(archiveFile);
            }
        } else {
            this.revisionLocation = FILE_PROTOCOL;
            this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
            ApkUtils.copyInputStreamToFile(new FileInputStream(archiveFile), this.bundleFile);
            if (hasSO) {
                this.installSoLib(this.bundleFile);
            }
        }
        this.updateMetadata();
    }

    BundleArchiveRevision(String location, long revisionNum, File revisionDir) throws IOException {
        File metaFile = new File(revisionDir, "meta");
        if (metaFile.exists()) {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(metaFile));
            this.revisionLocation = dataInputStream.readUTF();
            dataInputStream.close();
            this.revisionNum = revisionNum;
            this.revisionDir = revisionDir;
            if (!this.revisionDir.exists()) {
                this.revisionDir.mkdirs();
            }
            if (StringUtils.startWith(this.revisionLocation, REFERENCE_PROTOCOL)) {
                this.bundleFile = new File(StringUtils.substringAfter(this.revisionLocation, REFERENCE_PROTOCOL));
                return;
            }
            this.bundleFile = new File(revisionDir, BUNDLE_FILE_NAME);
            return;
        }
        throw new IOException("Could not find meta file in " + revisionDir.getAbsolutePath());
    }

    /*
     * Loose catch block
     */
    void updateMetadata() throws IOException {
        File metaFile = new File(this.revisionDir, "meta");
        FilterOutputStream dataOutputStream = null;
        try {
            if (!metaFile.getParentFile().exists()) {
                metaFile.getParentFile().mkdirs();
            }
            dataOutputStream = new DataOutputStream(new FileOutputStream(metaFile));
            ((DataOutputStream)dataOutputStream).writeUTF(this.revisionLocation);
            ((DataOutputStream)dataOutputStream).flush();
            try {
                dataOutputStream.close();
                return;
            }
            catch (IOException e) {
                block16: {
                    e.printStackTrace();
                    if (dataOutputStream == null) break block16;
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return;
                catch (IOException e3) {
                    throw new IOException("Could not save meta data " + metaFile.getAbsolutePath(), e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long getRevisionNum() {
        return this.revisionNum;
    }

    public File getRevisionDir() {
        return this.revisionDir;
    }

    public File getRevisionFile() {
        return this.bundleFile;
    }

    public File findSoLibrary(String str) {
        File file = new File(String.format("%s%s%s%s", this.revisionDir, File.separator, "lib", File.separator), str);
        return file.exists() && file.isFile() ? file : null;
    }

    public boolean isDexOpted() {
        if (OpenAtlasHacks.LexFile == null || OpenAtlasHacks.LexFile.getmClass() == null) {
            return new File(this.revisionDir, BUNDLE_ODEX_FILE).exists();
        }
        return new File(this.revisionDir, BUNDLE_LEX_FILE).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void optDexFile() {
        if (this.isDexOpted()) return;
        if (OpenAtlasHacks.LexFile == null || OpenAtlasHacks.LexFile.getmClass() == null) {
            File oDexFile = new File(this.revisionDir, BUNDLE_ODEX_FILE);
            long currentTimeMillis = System.currentTimeMillis();
            try {
                if (!OpenAtlasFileLock.getInstance().LockExclusive(oDexFile)) {
                    log.error("Failed to get file lock for " + this.bundleFile.getAbsolutePath());
                }
                if (oDexFile.length() > 0L) return;
                InitExecutor.optDexFile(this.bundleFile.getAbsolutePath(), oDexFile.getAbsolutePath());
                this.loadDex(oDexFile);
                OpenAtlasFileLock.getInstance().unLock(oDexFile);
                return;
            }
            catch (Throwable e) {
                log.error("Failed optDexFile '" + this.bundleFile.getAbsolutePath() + "' >>> ", e);
                return;
            }
            finally {
                OpenAtlasFileLock mAtlasFileLock = OpenAtlasFileLock.getInstance();
                mAtlasFileLock.unLock(oDexFile);
            }
        } else {
            DexClassLoader dexClassLoader = new DexClassLoader(this.bundleFile.getAbsolutePath(), this.revisionDir.getAbsolutePath(), null, ClassLoader.getSystemClassLoader());
        }
    }

    private synchronized void loadDex(File file) throws IOException {
        if (this.dexFile == null) {
            this.dexFile = DexFile.loadDex((String)this.bundleFile.getAbsolutePath(), (String)file.getAbsolutePath(), (int)0);
        }
    }

    public void installSoLib(File archiveFile) {
        try {
            ZipFile zipFile = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                File abiFolder;
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                String abi = "armeabi";
                if (Build.CPU_ABI.contains("x86")) {
                    abi = "x86";
                }
                if (name.indexOf(String.format("%s%s", "lib/", abi)) == -1) continue;
                abi = String.format("%s%s%s%s%s", this.revisionDir, File.separator, "lib", File.separator, name.substring(name.lastIndexOf(File.separator) + 1, name.length()));
                if (zipEntry.isDirectory()) {
                    abiFolder = new File(abi);
                    if (abiFolder.exists()) continue;
                    abiFolder.mkdirs();
                    continue;
                }
                abiFolder = new File(abi.substring(0, abi.lastIndexOf("/")));
                if (!abiFolder.exists()) {
                    abiFolder.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(abi));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] bArr = new byte[4096];
                int read = bufferedInputStream.read(bArr);
                while (read != -1) {
                    bufferedOutputStream.write(bArr, 0, read);
                    read = bufferedInputStream.read(bArr);
                }
                bufferedOutputStream.close();
            }
            zipFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream openAssetInputStream(String fileName) throws IOException {
        try {
            AssetManager assetManager = (AssetManager)AssetManager.class.newInstance();
            if ((Integer)OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, this.bundleFile.getAbsolutePath()) != 0) {
                return assetManager.open(fileName);
            }
        }
        catch (Throwable e) {
            log.error("Exception while openNonAssetInputStream >>>", e);
        }
        return null;
    }

    public InputStream openNonAssetInputStream(String assetName) throws IOException {
        try {
            AssetManager assetManager = (AssetManager)AssetManager.class.newInstance();
            int intValue = (Integer)OpenAtlasHacks.AssetManager_addAssetPath.invoke(assetManager, this.bundleFile.getAbsolutePath());
            if (intValue != 0) {
                return assetManager.openNonAssetFd(intValue, assetName).createInputStream();
            }
        }
        catch (Throwable e) {
            log.error("Exception while openNonAssetInputStream >>>", e);
        }
        return null;
    }

    Class<?> findClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            if (OpenAtlasHacks.LexFile == null || OpenAtlasHacks.LexFile.getmClass() == null) {
                if (!this.isDexOpted()) {
                    this.optDexFile();
                }
                if (this.dexFile == null) {
                    this.loadDex(new File(this.revisionDir, BUNDLE_ODEX_FILE));
                }
                Class loadClass = this.dexFile.loadClass(name, classLoader);
                this.isDexFileUsed = true;
                return loadClass;
            }
            if (this.dexClassLoader == null) {
                File file = new File(RuntimeVariables.androidApplication.getFilesDir().getParentFile(), "lib");
                this.dexClassLoader = new BundleArchiveRevisionClassLoader(this.bundleFile.getAbsolutePath(), this.revisionDir.getAbsolutePath(), file.getAbsolutePath(), classLoader);
            }
            return (Class)OpenAtlasHacks.DexClassLoader_findClass.invoke(this.dexClassLoader, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (Throwable e) {
            if (!(e instanceof ClassNotFoundException)) {
                if (e instanceof DexLoadException) {
                    throw (DexLoadException)e;
                }
                log.error("Exception while find class in archive revision: " + this.bundleFile.getAbsolutePath(), e);
            }
            return null;
        }
    }

    List<URL> getResources(String name) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        this.ensureZipFile();
        if (this.zipFile != null && this.zipFile.getEntry(name) != null) {
            try {
                arrayList.add(new URL("jar:" + this.bundleFile.toURL() + "!/" + name));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return arrayList;
    }

    void close() throws Exception {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
        if (this.dexFile != null) {
            this.dexFile.close();
        }
    }

    private boolean isSameDriver(File file, File file2) {
        return StringUtils.equals(StringUtils.substringBetween(file.getAbsolutePath(), "/", "/"), StringUtils.substringBetween(file2.getAbsolutePath(), "/", "/"));
    }

    private void ensureZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.bundleFile, 1);
        }
    }

    public static class DexLoadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DexLoadException(String str) {
            super(str);
        }
    }

    class BundleArchiveRevisionClassLoader
    extends DexClassLoader {
        BundleArchiveRevisionClassLoader(String dexPath, String optimizedDirectory, String libraryPath, ClassLoader parent) {
            super(dexPath, optimizedDirectory, libraryPath, parent);
        }

        public String findLibrary(String name) {
            String findLibrary = super.findLibrary(name);
            if (!TextUtils.isEmpty((CharSequence)findLibrary)) {
                return findLibrary;
            }
            File findSoLibrary = BundleArchiveRevision.this.findSoLibrary(System.mapLibraryName(name));
            if (findSoLibrary != null && findSoLibrary.exists()) {
                return findSoLibrary.getAbsolutePath();
            }
            try {
                return (String)OpenAtlasHacks.ClassLoader_findLibrary.invoke(Framework.getSystemClassLoader(), name);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

