/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import com.openatlas.framework.BundleClassLoader;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.bundlestorage.BundleArchive;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.log.OpenAtlasMonitor;
import com.openatlas.runtime.ClassNotFoundInterceptorCallback;
import com.openatlas.runtime.RuntimeVariables;
import com.openatlas.util.BundleLock;
import com.openatlas.util.FileUtils;
import com.openatlas.util.OpenAtlasFileLock;
import com.openatlas.util.OpenAtlasUtils;
import com.openatlas.util.StringUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.startlevel.StartLevel;

public final class Framework {
    private static final AdminPermission ADMIN_PERMISSION = new AdminPermission();
    private static String BASEDIR = null;
    private static String BUNDLE_LOCATION = null;
    static int CLASSLOADER_BUFFER_SIZE = 0;
    static boolean DEBUG_BUNDLES = true;
    static boolean DEBUG_CLASSLOADING = true;
    static boolean DEBUG_PACKAGES = true;
    static boolean DEBUG_SERVICES = true;
    static final String FRAMEWORK_VERSION = "1.0.0";
    private static final String DOWN_GRADE_FILE = "down_grade_list";
    static int LOG_LEVEL;
    static String STORAGE_LOCATION;
    private static boolean STRICT_STARTUP;
    static List<BundleListener> bundleListeners;
    static Map<String, Bundle> bundles;
    private static ClassNotFoundInterceptorCallback classNotFoundCallback;
    static List<FrameworkListener> frameworkListeners;
    static boolean frameworkStartupShutdown;
    static int initStartlevel;
    static final Logger log;
    static Properties properties;
    static boolean restart;
    static int startlevel;
    static List<BundleListener> syncBundleListeners;
    static SystemBundle systemBundle;
    static ClassLoader systemClassLoader;
    static List<String> writeAheads;

    static BundleImpl installNewBundle(String location, File apkFile) throws BundleException {
        BundleImpl bundleImpl;
        File mBundleArchiveFile = null;
        try {
            BundleLock.WriteLock(location);
            bundleImpl = (BundleImpl)Framework.getBundle(location);
            if (bundleImpl != null) {
                BundleLock.WriteUnLock(location);
            } else {
                mBundleArchiveFile = new File(STORAGE_LOCATION, location);
                OpenAtlasFileLock.getInstance().LockExclusive(mBundleArchiveFile);
                if (mBundleArchiveFile.exists() && (bundleImpl = Framework.restoreFromExistedBundle(location, mBundleArchiveFile)) != null) {
                    BundleLock.WriteUnLock(location);
                    if (mBundleArchiveFile != null) {
                        OpenAtlasFileLock.getInstance().unLock(mBundleArchiveFile);
                    }
                }
                bundleImpl = new BundleImpl(mBundleArchiveFile, location, null, apkFile, true);
                Framework.storeMetadata();
                BundleLock.WriteUnLock(location);
                if (mBundleArchiveFile != null) {
                    OpenAtlasFileLock.getInstance().unLock(mBundleArchiveFile);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            BundleLock.WriteUnLock(location);
            throw new BundleException(e.getMessage());
        }
        return bundleImpl;
    }

    static boolean restoreBundle(String[] packageNames) {
        try {
            for (String pkgName : packageNames) {
                File archiveFile = new File(STORAGE_LOCATION, pkgName);
                if (archiveFile.exists() && BundleArchive.downgradeRevision(archiveFile)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static BundleImpl installNewBundle(String location, InputStream archiveInputStream) throws BundleException {
        BundleImpl bundleImpl = null;
        File mBundleArchiveFile = null;
        try {
            BundleLock.WriteLock(location);
            bundleImpl = (BundleImpl)Framework.getBundle(location);
            if (bundleImpl != null) {
                BundleLock.WriteUnLock(location);
            } else {
                mBundleArchiveFile = new File(STORAGE_LOCATION, location);
                OpenAtlasFileLock.getInstance().LockExclusive(mBundleArchiveFile);
                if (mBundleArchiveFile.exists() && (bundleImpl = Framework.restoreFromExistedBundle(location, mBundleArchiveFile)) != null) {
                    BundleLock.WriteUnLock(location);
                    if (location != null) {
                        OpenAtlasFileLock.getInstance().unLock(mBundleArchiveFile);
                    }
                }
                bundleImpl = new BundleImpl(mBundleArchiveFile, location, archiveInputStream, null, true);
                Framework.storeMetadata();
                BundleLock.WriteUnLock(location);
                if (mBundleArchiveFile != null) {
                    OpenAtlasFileLock.getInstance().unLock(mBundleArchiveFile);
                }
            }
        }
        catch (Throwable v0) {
            BundleLock.WriteUnLock(location);
        }
        return bundleImpl;
    }

    private Framework() {
    }

    static void startup(Properties properties) throws BundleException {
        if (properties == null) {
            properties = new Properties();
        }
        Framework.properties = properties;
        Framework.startup();
    }

    private static void startup() throws BundleException {
        int startlevel;
        frameworkStartupShutdown = true;
        System.out.println("---------------------------------------------------------");
        System.out.println("  OpenAtlas OSGi 1.0.0  Pre-Release on " + Build.MODEL + "/" + Build.CPU_ABI + "/" + Build.VERSION.RELEASE + " SDK version " + Build.VERSION.SDK_INT + " starting ...");
        System.out.println("---------------------------------------------------------");
        long currentTimeMillis = System.currentTimeMillis();
        Framework.initialize();
        Framework.launch();
        boolean init = Framework.getProperty("osgi.init", false);
        if (init) {
            startlevel = -1;
        } else {
            startlevel = Framework.restoreProfile();
            restart = true;
        }
        if (startlevel == -1) {
            restart = false;
            File file = new File(STORAGE_LOCATION);
            if (init && file.exists()) {
                System.out.println("Purging storage ...");
                try {
                    Framework.deleteDirectory(file);
                }
                catch (Throwable e) {
                    throw new RuntimeException("deleteDirectory failed", e);
                }
            }
            try {
                file.mkdirs();
                Integer.getInteger("osgi.maxLevel", (Integer)1).intValue();
                initStartlevel = Framework.getProperty("osgi.startlevel.bundle", 1);
                startlevel = Framework.getProperty("osgi.startlevel.framework", 1);
            }
            catch (Throwable e) {
                throw new RuntimeException("mkdirs failed", e);
            }
        }
        Framework.notifyFrameworkListeners(0, systemBundle, null);
        Framework.systemBundle.setLevel(Framework.getBundles().toArray(new Bundle[Framework.bundles.size()]), startlevel, false);
        frameworkStartupShutdown = false;
        if (!restart) {
            try {
                Framework.storeProfile();
            }
            catch (Throwable e) {
                throw new RuntimeException("storeProfile failed", e);
            }
        }
        long currentTimeMillis2 = System.currentTimeMillis() - currentTimeMillis;
        System.out.println("---------------------------------------------------------");
        System.out.println("  Framework " + (restart ? "restarted" : "started") + " in " + currentTimeMillis2 + " milliseconds.");
        System.out.println("---------------------------------------------------------");
        System.out.flush();
        Framework.systemBundle.state = 32;
        try {
            Framework.notifyFrameworkListeners(1, systemBundle, null);
        }
        catch (Throwable e) {
            throw new RuntimeException("notifyFrameworkListeners failed", e);
        }
    }

    public static ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Bundle> getBundles() {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundles.size());
        Map<String, Bundle> map = bundles;
        synchronized (map) {
            arrayList.addAll(bundles.values());
        }
        return arrayList;
    }

    public static Bundle getBundle(String location) {
        return bundles.get(location);
    }

    public static Bundle getBundle(long j) {
        return null;
    }

    static void shutdown(boolean restart) {
        System.out.println("---------------------------------------------------------");
        System.out.println("  OpenAtlas OSGi shutting down ...");
        System.out.println("  Bye !");
        System.out.println("---------------------------------------------------------");
        Framework.systemBundle.state = 16;
        Framework.systemBundle.setLevel(Framework.getBundles().toArray(new Bundle[Framework.bundles.size()]), 0, true);
        bundles.clear();
        Framework.systemBundle.state = 1;
        if (restart) {
            try {
                Framework.startup();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void initialize() {
        File filesDir = RuntimeVariables.androidApplication.getFilesDir();
        if (filesDir == null || !filesDir.exists()) {
            filesDir = RuntimeVariables.androidApplication.getFilesDir();
        }
        BASEDIR = properties.getProperty("com.openatlas.basedir", filesDir.getAbsolutePath());
        BUNDLE_LOCATION = properties.getProperty("com.openatlas.jars", "file:" + BASEDIR);
        CLASSLOADER_BUFFER_SIZE = Framework.getProperty("com.openatlas.classloader.buffersize", 10240);
        LOG_LEVEL = Framework.getProperty("com.openatlas.log.level", 6);
        DEBUG_BUNDLES = Framework.getProperty("com.openatlas.debug.bundles", false);
        DEBUG_PACKAGES = Framework.getProperty("com.openatlas.debug.packages", false);
        DEBUG_SERVICES = Framework.getProperty("com.openatlas.debug.services", false);
        DEBUG_CLASSLOADING = Framework.getProperty("com.openatlas.debug.classloading", false);
        if (Framework.getProperty("com.openatlas.debug", false)) {
            System.out.println("SETTING ALL DEBUG FLAGS");
            LOG_LEVEL = 3;
            DEBUG_BUNDLES = true;
            DEBUG_PACKAGES = true;
            DEBUG_SERVICES = true;
            DEBUG_CLASSLOADING = true;
        }
        STRICT_STARTUP = Framework.getProperty("com.openatlas.strictStartup", false);
        String property = properties.getProperty("org.osgi.framework.system.packages");
        if (property != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(property, ",");
            int countTokens = stringTokenizer.countTokens();
            for (int i = 0; i < countTokens; ++i) {
                BundleClassLoader.FRAMEWORK_PACKAGES.add(stringTokenizer.nextToken().trim());
            }
        }
        properties.put("org.osgi.framework.executionenvironment", System.getProperty("java.specification.name") + "/" + System.getProperty("java.specification.version"));
        String key = "org.osgi.framework.os.name";
        property = System.getProperty("os.name");
        if (property == null) {
            property = "undefined";
        }
        properties.put(key, property);
        key = "org.osgi.framework.os.version";
        property = System.getProperty("os.version");
        if (property == null) {
            property = "undefined";
        }
        properties.put(key, property);
        key = "org.osgi.framework.processor";
        property = System.getProperty("os.arch");
        if (property == null) {
            property = "undefined";
        }
        properties.put(key, property);
        properties.put("org.osgi.framework.version", FRAMEWORK_VERSION);
        properties.put("org.osgi.framework.vendor", "OpenAtlas");
        property = Locale.getDefault().getLanguage();
        key = "org.osgi.framework.language";
        if (property == null) {
            property = "en";
        }
        properties.put(key, property);
    }

    private static void launch() {
        STORAGE_LOCATION = properties.getProperty("com.openatlas.storage", properties.getProperty("org.osgi.framework.dir", BASEDIR + File.separatorChar + "storage")) + File.separatorChar;
        systemBundle = new SystemBundle();
        Framework.systemBundle.state = 8;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String value = (String)properties.get(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    public static int getProperty(String key, int defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String value = (String)properties.get(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static String getProperty(String key) {
        if (properties == null) {
            return null;
        }
        return (String)properties.get(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties == null ? defaultValue : (String)properties.get(key);
    }

    protected static void warning(String message) throws RuntimeException {
        if (Framework.getProperty("com.openatlas.strictStartup", false)) {
            throw new RuntimeException(message);
        }
        System.err.println("WARNING: " + message);
    }

    private static void storeProfile() {
        BundleImpl[] bundleImplArr;
        for (BundleImpl updateMetadata : bundleImplArr = Framework.getBundles().toArray(new BundleImpl[bundles.size()])) {
            updateMetadata.updateMetadata();
        }
        Framework.storeMetadata();
    }

    static void storeMetadata() {
        try {
            File metaFile = new File(STORAGE_LOCATION, "meta");
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(metaFile));
            dataOutputStream.writeInt(startlevel);
            String join = StringUtils.join(writeAheads.toArray(), ",");
            if (join == null) {
                join = "";
            }
            dataOutputStream.writeUTF(join);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException e) {
            OpenAtlasMonitor.getInstance().trace(-3, "", "", "storeMetadata failed ", (Throwable)e);
            log.error("Could not save meta data.", (Throwable)e);
        }
    }

    private static int restoreProfile() {
        try {
            System.out.println("Restoring profile");
            File meta = new File(STORAGE_LOCATION, "meta");
            if (meta.exists()) {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(meta));
                int readInt = dataInputStream.readInt();
                String[] split = StringUtils.split(dataInputStream.readUTF(), ",");
                if (split != null) {
                    writeAheads.addAll(Arrays.asList(split));
                }
                dataInputStream.close();
                if (!Framework.getProperty("com.openatlas.auto.load", true)) {
                    return readInt;
                }
                File storageLocation = new File(STORAGE_LOCATION);
                Framework.mergeWalsDir(new File(STORAGE_LOCATION, "wal"), storageLocation);
                Framework.MergeWirteAheads(storageLocation);
                File[] listFiles = storageLocation.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String str) {
                        return !str.matches("^[0-9]*");
                    }
                });
                for (int i = 0; i < listFiles.length; ++i) {
                    if (!listFiles[i].isDirectory() || !new File(listFiles[i], "meta").exists()) continue;
                    try {
                        System.out.println("RESTORED BUNDLE " + new BundleImpl((File)listFiles[i]).location);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e.getCause());
                    }
                }
                return readInt;
            }
            System.out.println("Profile not found, performing clean start ...");
            return -1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static void mergeWalsDir(File walFile, File storageLocation) {
        if (writeAheads != null && writeAheads.size() > 0) {
            for (int i = 0; i < writeAheads.size(); ++i) {
                block9: {
                    if (writeAheads.get(i) == null) continue;
                    File mHeadDir = new File(walFile, writeAheads.get(i));
                    if (mHeadDir != null) {
                        try {
                            File[] mHeadFiles;
                            if (!mHeadDir.exists() || (mHeadFiles = mHeadDir.listFiles()) == null) break block9;
                            for (File mHeadFile : mHeadFiles) {
                                if (!mHeadFile.isDirectory()) continue;
                                File targetFile = new File(storageLocation, mHeadFile.getName());
                                if (targetFile.exists()) {
                                    File[] reversionList = mHeadFile.listFiles(new FilenameFilter(){

                                        @Override
                                        public boolean accept(File file, String str) {
                                            return str.startsWith("version");
                                        }
                                    });
                                    if (reversionList == null) continue;
                                    for (File mFile : reversionList) {
                                        if (!new File(mFile, "meta").exists()) continue;
                                        mFile.renameTo(new File(targetFile, mFile.getName()));
                                    }
                                    continue;
                                }
                                mHeadFile.renameTo(targetFile);
                            }
                        }
                        catch (Throwable e) {
                            log.error("Error while merge wal dir", e);
                        }
                    }
                }
                writeAheads.set(i, null);
            }
        }
        if (walFile.exists()) {
            walFile.delete();
        }
    }

    public static void deleteDirectory(File mDirectory) {
        File[] listFiles = mDirectory.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            if (listFiles[i].isDirectory()) {
                Framework.deleteDirectory(listFiles[i]);
                continue;
            }
            listFiles[i].delete();
        }
        mDirectory.delete();
    }

    static BundleImpl installNewBundle(String bundleName) throws BundleException {
        try {
            String location = bundleName.indexOf(":") > -1 ? bundleName : BUNDLE_LOCATION + File.separatorChar + bundleName;
            return Framework.installNewBundle(location, new URL(location).openConnection().getInputStream());
        }
        catch (Throwable e) {
            throw new BundleException("Cannot retrieve bundle from " + bundleName, e);
        }
    }

    private static BundleImpl restoreFromExistedBundle(String location, File file) {
        try {
            return new BundleImpl(file);
        }
        catch (Throwable e) {
            OpenAtlasMonitor.getInstance().trace(-1, "", "", "restore bundle failed " + location + e);
            log.error("restore bundle failed" + location, e);
            return null;
        }
    }

    static void installOrUpdate(String[] locations, File[] archiveFiles) throws BundleException {
        if (locations == null || archiveFiles == null || locations.length != archiveFiles.length) {
            throw new IllegalArgumentException("locations and files must not be null and must be same length");
        }
        String valueOf = String.valueOf(System.currentTimeMillis());
        File file = new File(new File(STORAGE_LOCATION, "wal"), valueOf);
        file.mkdirs();
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] == null || archiveFiles[i] == null) continue;
            try {
                BundleLock.WriteLock(locations[i]);
                Bundle bundle = Framework.getBundle(locations[i]);
                if (bundle != null) {
                    bundle.update(archiveFiles[i]);
                } else {
                    BundleImpl bundleImpl = new BundleImpl(new File(file, locations[i]), locations[i], null, archiveFiles[i], false);
                }
                BundleLock.WriteUnLock(locations[i]);
                continue;
            }
            catch (Throwable th) {
                BundleLock.WriteUnLock(locations[i]);
            }
        }
        writeAheads.add(valueOf);
        Framework.storeMetadata();
    }

    static void notifyBundleListeners(int event, Bundle bundle) {
        if (!syncBundleListeners.isEmpty() || !bundleListeners.isEmpty()) {
            BundleListener[] bundleListenerArr;
            BundleEvent bundleEvent = new BundleEvent(event, bundle);
            for (BundleListener bundleChanged : bundleListenerArr = syncBundleListeners.toArray(new BundleListener[syncBundleListeners.size()])) {
                bundleChanged.bundleChanged(bundleEvent);
            }
            if (!bundleListeners.isEmpty()) {
                for (BundleListener bundleListener : bundleListenerArr = bundleListeners.toArray(new BundleListener[bundleListeners.size()])) {
                    bundleListener.bundleChanged(bundleEvent);
                }
            }
        }
    }

    static void addFrameworkListener(FrameworkListener frameworkListener) {
        frameworkListeners.add(frameworkListener);
    }

    static void removeFrameworkListener(FrameworkListener frameworkListener) {
        frameworkListeners.remove(frameworkListener);
    }

    private static void restoreBundles() throws IOException {
        File file = new File(STORAGE_LOCATION, DOWN_GRADE_FILE);
        for (String pkg : FileUtils.getStrings(file)) {
            File locationFolder = new File(STORAGE_LOCATION, pkg);
            if (!locationFolder.exists()) continue;
            String[] list = locationFolder.list();
            String version = null;
            if (list != null) {
                for (String string : list) {
                    if (!string.startsWith("version") && Long.parseLong(StringUtils.substringAfter(string, ".")) > 0L) continue;
                    version = string;
                }
            }
            if (version == null) {
                FileUtils.deleteFile(locationFolder.getAbsolutePath());
                continue;
            }
            File tmp = new File(locationFolder, version);
            if (!tmp.exists()) continue;
            FileUtils.deleteFile(tmp.getAbsolutePath());
        }
        if (file.exists()) {
            FileUtils.deleteFile(file.getAbsolutePath());
        }
    }

    private static void MergeWirteAheads(File storageLocation) {
        block3: {
            try {
                File wal = new File(STORAGE_LOCATION, "wal");
                String curProcessName = OpenAtlasUtils.getProcessNameByPID(Process.myPid());
                log.debug("restoreProfile in process " + curProcessName);
                String packageName = RuntimeVariables.androidApplication.getPackageName();
                if (curProcessName != null && packageName != null && curProcessName.equals(packageName)) {
                    Framework.mergeWalsDir(wal, storageLocation);
                }
            }
            catch (Throwable th) {
                if (Build.MODEL != null && Build.MODEL.equals("HTC 802w")) break block3;
                log.error(th.getMessage(), th.getCause());
                return;
            }
        }
    }

    static void addBundleListener(BundleListener bundleListener) {
        bundleListeners.add(bundleListener);
    }

    static void removeBundleListener(BundleListener bundleListener) {
        bundleListeners.remove(bundleListener);
    }

    static void notifyFrameworkListeners(int event, Bundle bundle, Throwable th) {
        if (!frameworkListeners.isEmpty()) {
            FrameworkListener[] frameworkListenerArr;
            FrameworkEvent frameworkEvent = new FrameworkEvent(event, bundle, th);
            for (FrameworkListener frameworkListener : frameworkListenerArr = frameworkListeners.toArray(new FrameworkListener[frameworkListeners.size()])) {
                frameworkListener.frameworkEvent(frameworkEvent);
            }
        }
    }

    static void clearBundleTrace(BundleImpl bundleImpl) {
        if (bundleImpl.registeredFrameworkListeners != null) {
            frameworkListeners.removeAll(bundleImpl.registeredFrameworkListeners);
            bundleImpl.registeredFrameworkListeners = null;
        }
        if (bundleImpl.registeredBundleListeners != null) {
            bundleListeners.removeAll(bundleImpl.registeredBundleListeners);
            syncBundleListeners.removeAll(bundleImpl.registeredBundleListeners);
            bundleImpl.registeredBundleListeners = null;
        }
    }

    static void addValue(Map map, Object key, Object value) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
        }
        list.add(value);
        map.put(key, list);
    }

    static void removeValue(Map map, Object[] objArr, Object obj) {
        for (int i = 0; i < objArr.length; ++i) {
            List list = (List)map.get(objArr[i]);
            if (list == null) continue;
            list.remove(obj);
            if (list.isEmpty()) {
                map.remove(objArr[i]);
                continue;
            }
            map.put(objArr[i], list);
        }
    }

    public static boolean isFrameworkStartupShutdown() {
        return frameworkStartupShutdown;
    }

    public static ClassNotFoundInterceptorCallback getClassNotFoundCallback() {
        return classNotFoundCallback;
    }

    public static void setClassNotFoundCallback(ClassNotFoundInterceptorCallback classNotFoundInterceptorCallback) {
        classNotFoundCallback = classNotFoundInterceptorCallback;
    }

    static {
        bundleListeners = new ArrayList<BundleListener>();
        bundles = new ConcurrentHashMap<String, Bundle>();
        frameworkListeners = new ArrayList<FrameworkListener>();
        frameworkStartupShutdown = false;
        initStartlevel = 1;
        log = LoggerFactory.getInstance("Framework");
        restart = false;
        startlevel = 0;
        syncBundleListeners = new ArrayList<BundleListener>();
        writeAheads = new ArrayList<String>();
    }

    private static final class SystemBundle
    implements Bundle,
    StartLevel {
        private final Dictionary<String, String> props = new Hashtable<String, String>();
        int state;

        SystemBundle() {
            this.props.put("Bundle-Name", "System Bundle");
            this.props.put("Bundle-Version", Framework.FRAMEWORK_VERSION);
            this.props.put("Bundle-Vendor", "OpenAtlas");
        }

        @Override
        public long getBundleId() {
            return 0L;
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return this.props;
        }

        @Override
        public String getLocation() {
            return "System Bundle";
        }

        @Override
        public URL getResource(String name) {
            return this.getClass().getResource(name);
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public boolean hasPermission(Object permission) {
            return true;
        }

        @Override
        public void start() throws BundleException {
        }

        @Override
        public void stop() throws BundleException {
            this.shutdownThread(false);
        }

        @Override
        public void uninstall() throws BundleException {
            throw new BundleException("Cannot uninstall the System Bundle");
        }

        @Override
        public void update() throws BundleException {
            this.shutdownThread(true);
        }

        private void shutdownThread(boolean z) {
            new ShutdownThread(z).start();
        }

        @Override
        public void update(InputStream inputStream) throws BundleException {
            this.shutdownThread(true);
        }

        @Override
        public void update(File file) throws BundleException {
            this.shutdownThread(true);
        }

        @Override
        public int getBundleStartLevel(Bundle bundle) {
            if (bundle == this) {
                return 0;
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state != 1) {
                return bundleImpl.currentStartlevel;
            }
            throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
        }

        @Override
        public int getInitialBundleStartLevel() {
            return initStartlevel;
        }

        @Override
        public int getStartLevel() {
            return startlevel;
        }

        @Override
        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            if (bundle == this) {
                return true;
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state != 1) {
                return bundleImpl.persistently;
            }
            throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
        }

        @Override
        public void setBundleStartLevel(Bundle bundle, int level) {
            if (bundle == this) {
                throw new IllegalArgumentException("Cannot set the start level for the system bundle.");
            }
            BundleImpl bundleImpl = (BundleImpl)bundle;
            if (bundleImpl.state == 1) {
                throw new IllegalArgumentException("Bundle " + bundle + " has been uninstalled");
            }
            if (level <= 0) {
                throw new IllegalArgumentException("Start level " + level + " is not Component valid level");
            }
            bundleImpl.currentStartlevel = level;
            bundleImpl.updateMetadata();
            if (level <= startlevel && bundle.getState() != 32 && bundleImpl.persistently) {
                try {
                    bundleImpl.startBundle();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Framework.notifyFrameworkListeners(2, bundle, e);
                }
            } else if (level > startlevel && (bundle.getState() != 4 || bundle.getState() != 2)) {
                try {
                    bundleImpl.stopBundle();
                }
                catch (Throwable e2) {
                    Framework.notifyFrameworkListeners(2, bundle, e2);
                }
            }
        }

        @Override
        public void setInitialBundleStartLevel(int level) {
            if (level <= 0) {
                throw new IllegalArgumentException("Start level " + level + " is not Component valid level");
            }
            initStartlevel = level;
        }

        @Override
        public void setStartLevel(int i) {
            if (i <= 0) {
                throw new IllegalArgumentException("Start level " + i + " is not Component valid level");
            }
            new UpdateLevelThread(i).start();
        }

        @SuppressLint(value={"UseSparseArrays"})
        private void setLevel(Bundle[] bundles, int startlevel, boolean z) {
            if (Framework.startlevel != startlevel) {
                boolean iStartlevelHigh = startlevel > Framework.startlevel;
                int levelDiff = iStartlevelHigh ? startlevel - Framework.startlevel : Framework.startlevel - startlevel;
                HashMap hashMap = new HashMap(0);
                for (Bundle mBundle : bundles) {
                    if (mBundle == systemBundle || !z && !((BundleImpl)mBundle).persistently) continue;
                    BundleImpl bundleImpl = (BundleImpl)mBundle;
                    int mLevelDiff = iStartlevelHigh ? bundleImpl.currentStartlevel - Framework.startlevel - 1 : Framework.startlevel - bundleImpl.currentStartlevel;
                    if (mLevelDiff < 0 || mLevelDiff >= levelDiff) continue;
                    Framework.addValue(hashMap, mLevelDiff, bundleImpl);
                }
                for (int j = 0; j < levelDiff; ++j) {
                    Framework.startlevel = iStartlevelHigh ? ++Framework.startlevel : --Framework.startlevel;
                    List list = (List)hashMap.get(j);
                    if (list == null) continue;
                    BundleImpl[] bundleImplArr = list.toArray(new BundleImpl[list.size()]);
                    for (int i = 0; i < bundleImplArr.length; ++i) {
                        if (iStartlevelHigh) {
                            try {
                                System.out.println("STARTING " + bundleImplArr[i].location);
                                bundleImplArr[i].startBundle();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                e.printStackTrace();
                                Framework.notifyFrameworkListeners(2, systemBundle, e);
                            }
                            continue;
                        }
                        if (bundleImplArr[i].getState() == 1) continue;
                        System.out.println("STOPPING " + bundleImplArr[i].location);
                        try {
                            bundleImplArr[bundleImplArr.length - i - 1].stopBundle();
                            continue;
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Framework.startlevel = startlevel;
            }
        }

        public void refreshPackages(Bundle[] bundleArr) {
            new RefreshBundlesThread(bundleArr).start();
        }

        public String toString() {
            return "SystemBundle";
        }

        class RefreshBundlesThread
        extends Thread {
            final Bundle[] bundleArray;

            RefreshBundlesThread(Bundle[] bundleArr) {
                this.bundleArray = bundleArr;
            }

            @Override
            public void run() {
            }
        }

        class UpdateLevelThread
        extends Thread {
            final int targetLevel;

            UpdateLevelThread(int i) {
                this.targetLevel = i;
            }

            @Override
            public void run() {
                List<Bundle> bundles = Framework.getBundles();
                SystemBundle.this.setLevel(bundles.toArray(new Bundle[bundles.size()]), this.targetLevel, false);
                Framework.notifyFrameworkListeners(8, systemBundle, null);
                Framework.storeMetadata();
            }
        }

        class ShutdownThread
        extends Thread {
            final boolean restart;

            ShutdownThread(boolean restart) {
                this.restart = restart;
            }

            @Override
            public void run() {
                Framework.shutdown(this.restart);
            }
        }
    }
}

