/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleClassLoader;
import com.openatlas.framework.Framework;
import com.openatlas.framework.bundlestorage.Archive;
import com.openatlas.framework.bundlestorage.BundleArchive;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;

public final class BundleImpl
implements Bundle {
    static final Logger log = LoggerFactory.getInstance("BundleImpl");
    Archive archive;
    final File bundleDir;
    BundleClassLoader classloader;
    int currentStartlevel;
    ProtectionDomain domain;
    Hashtable<String, String> headers = new Hashtable();
    final String location;
    boolean persistently;
    List<BundleListener> registeredBundleListeners;
    List<FrameworkListener> registeredFrameworkListeners;
    int state = 0;
    boolean isValid = true;

    BundleImpl(File bundleDir, String location, InputStream archiveInputStream, File archiveFile, boolean isInstall) throws BundleException, IOException {
        this.persistently = false;
        this.domain = null;
        this.registeredFrameworkListeners = null;
        this.registeredBundleListeners = null;
        long currentTimeMillis = System.currentTimeMillis();
        this.location = location;
        this.currentStartlevel = Framework.initStartlevel;
        this.bundleDir = bundleDir;
        if (archiveInputStream != null) {
            this.archive = new BundleArchive(location, bundleDir, archiveInputStream);
        } else if (archiveFile != null) {
            try {
                this.archive = new BundleArchive(location, bundleDir, archiveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.state = 2;
        this.updateMetadata();
        if (isInstall) {
            Framework.bundles.put(location, this);
            this.resolveBundle(false);
            Framework.notifyBundleListeners(1, this);
        }
        if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
            log.info("Framework: Bundle " + this.toString() + " created. " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
        }
    }

    BundleImpl(File file) throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(new File(file, "meta")));
        this.location = dataInputStream.readUTF();
        this.currentStartlevel = dataInputStream.readInt();
        this.persistently = dataInputStream.readBoolean();
        dataInputStream.close();
        this.bundleDir = file;
        this.state = 2;
        try {
            this.archive = new BundleArchive(this.location, file);
            this.resolveBundle(false);
            Framework.bundles.put(this.location, this);
            Framework.notifyBundleListeners(1, this);
            if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                log.info("Framework: Bundle " + this.toString() + " loaded. " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
            }
        }
        catch (Exception e) {
            throw new BundleException("Could not load bundle " + this.location, e.getCause());
        }
    }

    private synchronized void resolveBundle(boolean recursive) throws BundleException {
        if (this.state != 4) {
            if (this.classloader == null) {
                this.classloader = new BundleClassLoader(this);
            }
            if (recursive) {
                this.classloader.resolveBundle(true, new HashSet<BundleClassLoader>(0));
                this.state = 4;
            } else if (this.classloader.resolveBundle(false, null)) {
                this.state = 4;
            }
            Framework.notifyBundleListeners(0, this);
        }
    }

    @Override
    public long getBundleId() {
        return 0L;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    public URL getResource(String name) {
        if (this.state != 1) {
            return this.classloader.getResource(name);
        }
        throw new IllegalStateException("Bundle " + this.toString() + " has been uninstalled");
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean hasPermission(Object permission) {
        if (this.state != 1) {
            return true;
        }
        throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
    }

    @Override
    public synchronized void start() throws BundleException {
        this.persistently = true;
        this.updateMetadata();
        if (this.currentStartlevel <= Framework.startlevel) {
            this.startBundle();
        }
    }

    public synchronized void startBundle() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot start uninstalled bundle " + this.toString());
        }
        if (this.state != 32) {
            if (this.state == 2) {
                this.resolveBundle(true);
            }
            this.state = 8;
            try {
                this.isValid = true;
                this.state = 32;
                Framework.notifyBundleListeners(2, this);
                if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                    log.info("Framework: Bundle " + this.toString() + " started.");
                }
            }
            catch (Throwable th) {
                Framework.clearBundleTrace(this);
                this.state = 4;
                String msg = "Error starting bundle " + this.toString();
                BundleException bundleException = new BundleException(msg, th);
            }
        }
    }

    @Override
    public synchronized void stop() throws BundleException {
        this.persistently = false;
        this.updateMetadata();
        this.stopBundle();
    }

    public synchronized void stopBundle() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
        }
        if (this.state == 32) {
            this.state = 16;
            try {
                if (Framework.DEBUG_BUNDLES && log.isInfoEnabled()) {
                    log.info("Framework: Bundle " + this.toString() + " stopped.");
                }
                Framework.clearBundleTrace(this);
                this.state = 4;
                Framework.notifyBundleListeners(4, this);
                this.isValid = false;
            }
            catch (Throwable th) {
                Framework.clearBundleTrace(this);
                this.state = 4;
                Framework.notifyBundleListeners(4, this);
                this.isValid = false;
            }
        }
    }

    @Override
    public synchronized void uninstall() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + " is already uninstalled.");
        }
        if (this.state == 32) {
            try {
                this.stopBundle();
            }
            catch (Throwable th) {
                Framework.notifyFrameworkListeners(2, this, th);
            }
        }
        this.state = 1;
        new File(this.bundleDir, "meta").delete();
        if (this.classloader.originalExporter != null) {
            this.classloader.originalExporter.cleanup(true);
            this.classloader.originalExporter = null;
        }
        this.classloader.cleanup(true);
        this.classloader = null;
        Framework.bundles.remove(this);
        Framework.notifyBundleListeners(16, this);
        this.isValid = false;
    }

    @Override
    public synchronized void update() throws BundleException {
        String locationUpdate = this.headers.get("Bundle-UpdateLocation");
        try {
            if (locationUpdate == null) {
                locationUpdate = this.location;
            }
            this.update(new URL(locationUpdate).openConnection().getInputStream());
        }
        catch (Throwable e) {
            throw new BundleException("Could not update " + this.toString() + " from " + locationUpdate, e);
        }
    }

    @Override
    public synchronized void update(InputStream inputStream) throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
        }
        try {
            this.archive.newRevision(this.location, this.bundleDir, inputStream);
        }
        catch (Throwable e) {
            throw new BundleException("Could not update bundle " + this.toString(), e);
        }
    }

    @Override
    public synchronized void update(File bundleFile) throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
        }
        try {
            this.archive.newRevision(this.location, this.bundleDir, bundleFile);
        }
        catch (Throwable e) {
            throw new BundleException("Could not update bundle " + this.toString(), e);
        }
    }

    public synchronized void refresh() throws BundleException {
        if (this.state == 1) {
            throw new IllegalStateException("Cannot refresh uninstalled bundle " + this.toString());
        }
        boolean isResolved = false;
        if (this.state == 32) {
            this.stopBundle();
            isResolved = true;
        }
        try {
            this.archive = new BundleArchive(this.location, this.bundleDir);
            BundleClassLoader bundleClassLoader = new BundleClassLoader(this);
            this.classloader.cleanup(true);
            this.classloader = bundleClassLoader;
            this.state = this.classloader.resolveBundle(false, null) ? 4 : 2;
            Framework.notifyBundleListeners(8, this);
            if (isResolved) {
                this.startBundle();
            }
        }
        catch (BundleException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BundleException("Could not refresh bundle " + this.toString(), e);
        }
    }

    public synchronized void optDexFile() {
        this.getArchive().optDexFile();
    }

    public synchronized void purge() throws BundleException {
        try {
            this.getArchive().purge();
        }
        catch (Throwable e) {
            throw new BundleException("Could not purge bundle " + this.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMetadata() {
        File file = new File(this.bundleDir, "meta");
        FilterOutputStream dataOutputStream = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            dataOutputStream = new DataOutputStream(fileOutputStream);
            ((DataOutputStream)dataOutputStream).writeUTF(this.location);
            ((DataOutputStream)dataOutputStream).writeInt(this.currentStartlevel);
            ((DataOutputStream)dataOutputStream).writeBoolean(this.persistently);
            ((DataOutputStream)dataOutputStream).flush();
            fileOutputStream.getFD().sync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toString() {
        return this.location;
    }
}

