/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.framework;

import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.Framework;
import com.openatlas.framework.bundlestorage.Archive;
import com.openatlas.framework.bundlestorage.BundleArchiveRevision;
import com.openatlas.hack.OpenAtlasHacks;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.osgi.framework.BundleException;

public final class BundleClassLoader
extends ClassLoader {
    private static final List<URL> EMPTY_LIST;
    static final HashSet<String> FRAMEWORK_PACKAGES;
    static final Logger log;
    final Archive archive;
    BundleImpl bundle;
    private File[] nativeLibraryDirectories;
    BundleClassLoader originalExporter;

    BundleClassLoader(BundleImpl bundleImpl) throws BundleException {
        super(Object.class.getClassLoader());
        this.bundle = bundleImpl;
        this.archive = bundleImpl.archive;
        if (this.archive == null) {
            throw new BundleException("Not Component valid bundle: " + bundleImpl.location);
        }
    }

    public BundleImpl getBundle() {
        return this.bundle;
    }

    @Deprecated
    private void checkExecutionEnviroment(String[] requireEnv, String[] execEnv) throws BundleException {
        if (requireEnv.length != 0) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(execEnv));
            for (int i = 0; i < requireEnv.length; ++i) {
                if (!hashSet.contains(requireEnv[i])) {
                    continue;
                }
                return;
            }
            throw new BundleException("Platform does not provide EEs " + Arrays.asList(requireEnv));
        }
    }

    boolean resolveBundle(boolean resolve, HashSet<BundleClassLoader> hashSet) throws BundleException {
        if (Framework.DEBUG_CLASSLOADING && log.isInfoEnabled()) {
            log.info("BundleClassLoader: Resolving " + this.bundle + (resolve ? " (critical)" : " (not critical)"));
        }
        return true;
    }

    void cleanup(boolean staleExportedPackage) {
        ArrayList arrayList = new ArrayList();
        if (this.bundle != null) {
            // empty if block
        }
        this.originalExporter = null;
        if (staleExportedPackage && arrayList.size() == 0) {
            this.bundle = null;
        }
    }

    @Override
    protected Class<?> findClass(String clazz) throws ClassNotFoundException {
        if (FRAMEWORK_PACKAGES.contains(BundleClassLoader.packageOf(clazz))) {
            return Framework.systemClassLoader.loadClass(clazz);
        }
        Class<?> findOwnClass = this.findOwnClass(clazz);
        if (findOwnClass != null) {
            return findOwnClass;
        }
        try {
            findOwnClass = Framework.systemClassLoader.loadClass(clazz);
            if (findOwnClass != null) {
                return findOwnClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ClassNotFoundException("Can't find class " + clazz + " in BundleClassLoader: " + this.bundle.getLocation());
    }

    private Class<?> findOwnClass(String clazz) {
        try {
            return this.archive.findClass(clazz, this);
        }
        catch (Exception e) {
            if (!(e instanceof BundleArchiveRevision.DexLoadException)) {
                return null;
            }
            throw (BundleArchiveRevision.DexLoadException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> findDelegatedClass(BundleClassLoader bundleClassLoader, String clazz) {
        Class<?> findLoadedClass;
        BundleClassLoader bundleClassLoader2 = bundleClassLoader;
        synchronized (bundleClassLoader2) {
            findLoadedClass = bundleClassLoader.findLoadedClass(clazz);
            if (findLoadedClass == null) {
                findLoadedClass = bundleClassLoader.findOwnClass(clazz);
            }
        }
        return findLoadedClass;
    }

    @Override
    protected URL findResource(String name) {
        String stripTrailing = BundleClassLoader.stripTrailing(name);
        List<URL> findOwnResources = this.findOwnResources(stripTrailing, false);
        if (findOwnResources.size() > 0) {
            return findOwnResources.get(0);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        String stripTrailing = BundleClassLoader.stripTrailing(name);
        List<URL> findOwnResources = this.findOwnResources(stripTrailing, true);
        return Collections.enumeration(findOwnResources);
    }

    private List<URL> findOwnResources(String name, boolean z) {
        try {
            return this.archive.getResources(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return EMPTY_LIST;
        }
    }

    @Override
    protected String findLibrary(String nickname) {
        File findLibrary;
        String mapLibraryName = System.mapLibraryName(nickname);
        if (this.nativeLibraryDirectories != null) {
            for (File file : this.nativeLibraryDirectories) {
                File file2 = new File(file, mapLibraryName);
                if (!file2.canRead()) continue;
                return file2.getAbsolutePath();
            }
        }
        if ((findLibrary = this.archive.findLibrary(mapLibraryName)) != null) {
            return findLibrary.getAbsolutePath();
        }
        try {
            return (String)OpenAtlasHacks.ClassLoader_findLibrary.invoke(Framework.systemClassLoader, nickname);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "BundleClassLoader[Bundle" + this.bundle + "]";
    }

    private static String[] readProperty(Attributes attributes, String name) throws BundleException {
        String value = attributes.getValue(name);
        if (value == null || !value.equals("")) {
            return BundleClassLoader.splitString(value);
        }
        return new String[0];
    }

    private static String[] splitString(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 0) {
            return new String[]{string};
        }
        String[] strArr = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = stringTokenizer.nextToken().trim();
        }
        return strArr;
    }

    private static String stripTrailing(String name) {
        return name.startsWith("/") || name.startsWith("\\") ? name.substring(1) : name;
    }

    private static String packageOf(String name) {
        int lastIndexOf = name.lastIndexOf(46);
        return lastIndexOf > -1 ? name.substring(0, lastIndexOf) : "";
    }

    private static String pseudoClassname(String name) {
        return BundleClassLoader.stripTrailing(name).replace('.', '-').replace('/', '.').replace('\\', '.');
    }

    static {
        log = LoggerFactory.getInstance("BundleClassLoader");
        FRAMEWORK_PACKAGES = new HashSet();
        FRAMEWORK_PACKAGES.add("com.openatlas.framework");
        FRAMEWORK_PACKAGES.add("org.osgi.framework");
        FRAMEWORK_PACKAGES.add("org.osgi.service.packageadmin");
        FRAMEWORK_PACKAGES.add("org.osgi.service.startlevel");
        EMPTY_LIST = new ArrayList<URL>();
    }

    @Deprecated
    private static final class BundleURLHandler
    extends URLStreamHandler {
        private final InputStream inputStream;

        private BundleURLHandler(final InputStream inputStream) {
            this.inputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return inputStream.read();
                }

                @Override
                public int read(byte[] buffer) throws IOException {
                    return inputStream.read(buffer);
                }
            };
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new URLConnection(url){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return BundleURLHandler.this.inputStream;
                }
            };
        }

        @Override
        protected int hashCode(URL url) {
            return this.inputStream.hashCode();
        }
    }
}

