/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.dexopt;

import android.os.Build;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.util.HashMap;
import java.util.Map;

public class InitExecutor {
    static final Logger log;
    private static boolean sDexOptLoaded;
    static boolean isART;
    private static Map<String, String> ABI_TO_INSTRUCTION_SET_MAP;
    static String defaultInstruction;

    private static native void dexopt(String var0, String var1, boolean var2, String var3);

    public static boolean optDexFile(String srcDexPath, String oDexFilePath) {
        try {
            if (sDexOptLoaded) {
                if (isART && AtlasConfig.optART) {
                    InitExecutor.dexopt(srcDexPath, oDexFilePath, true, defaultInstruction);
                } else {
                    InitExecutor.dexopt(srcDexPath, oDexFilePath, false, "");
                }
                return true;
            }
        }
        catch (Throwable e) {
            log.error("Exception while try to call native dexopt >>>", e);
        }
        return false;
    }

    static {
        isART = false;
        ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>();
        String vm = System.getProperty("java.vm.version");
        isART = Character.getNumericValue(vm.charAt(0)) >= 2;
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips", "mips");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips64", "mips64");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
        defaultInstruction = ABI_TO_INSTRUCTION_SET_MAP.get(Build.CPU_ABI);
        log = LoggerFactory.getInstance("InitExecutor");
        ABI_TO_INSTRUCTION_SET_MAP.clear();
        ABI_TO_INSTRUCTION_SET_MAP = null;
        sDexOptLoaded = false;
        try {
            System.loadLibrary("dexopt");
            sDexOptLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }
}

