/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.task;

import android.os.AsyncTask;
import android.os.Build;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Pattern;

public class SaturativeExecutor
extends ThreadPoolExecutor {
    private static final boolean DEBUG = false;
    static final Pattern PATTERN_CPU_ENTRIES = Pattern.compile("cpu[0-9]+");
    static final String TAG = "SatuExec";
    private static SaturationAwareBlockingQueue<Runnable> mQueue;
    private static final HashSet<Thread> mThreads;
    private static final ThreadFactory sThreadFactory;

    @Override
    public void execute(Runnable runnable) {
        super.execute(new CountedTask(runnable));
    }

    public static final boolean installAsDefaultAsyncTaskExecutor(ThreadPoolExecutor threadPoolExecutor) {
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Field declaredField = AsyncTask.class.getDeclaredField("THREAD_POOL_EXECUTOR");
                declaredField.setAccessible(true);
                declaredField.set(null, threadPoolExecutor);
            }
            catch (Exception declaredField) {
                // empty catch block
            }
        }
        try {
            Method method = AsyncTask.class.getMethod("setDefaultExecutor", Executor.class);
            method.setAccessible(true);
            method.invoke(null, threadPoolExecutor);
            return true;
        }
        catch (Exception e2) {
            try {
                Field declaredField = AsyncTask.class.getDeclaredField("sDefaultExecutor");
                declaredField.setAccessible(true);
                declaredField.set(null, threadPoolExecutor);
                return true;
            }
            catch (Exception e3) {
                try {
                    Field declaredField = AsyncTask.class.getDeclaredField("sExecutor");
                    declaredField.setAccessible(true);
                    declaredField.set(null, threadPoolExecutor);
                    return true;
                }
                catch (Exception e4) {
                    return false;
                }
            }
        }
    }

    public SaturativeExecutor() {
        this(SaturativeExecutor.determineBestMinPoolSize());
    }

    public SaturativeExecutor(int corePoolSize) {
        super(corePoolSize, 128, 1L, TimeUnit.SECONDS, new SaturationAwareBlockingQueue<Runnable>(1024), sThreadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        mQueue = (SaturationAwareBlockingQueue)this.getQueue();
        ((SaturationAwareBlockingQueue)this.getQueue()).setExecutor(this);
    }

    protected boolean isReallyUnsaturated() {
        if (this.isSaturated()) {
            return false;
        }
        LockSupport.parkNanos(10L);
        return !this.isSaturated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSaturated() {
        if (this.getPoolSize() <= 3) {
            return false;
        }
        int corePoolSize = this.getCorePoolSize();
        int i = CountedTask.mNumRunning.get();
        int size = mThreads.size();
        if (i < corePoolSize || i < size) {
            return true;
        }
        HashSet<Thread> hashSet = mThreads;
        synchronized (hashSet) {
            Iterator<Thread> it = mThreads.iterator();
            size = 0;
            while (it.hasNext()) {
                Thread.State state = it.next().getState();
                if (state == Thread.State.RUNNABLE || state == Thread.State.NEW) {
                    i = size + 1;
                } else {
                    if (state == Thread.State.TERMINATED) {
                        it.remove();
                    }
                    i = size;
                }
                size = i;
            }
        }
        boolean z = size >= corePoolSize;
        return z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectThread(Thread thread) {
        HashSet<Thread> hashSet = mThreads;
        synchronized (hashSet) {
            mThreads.add(thread);
        }
    }

    private static int determineBestMinPoolSize() {
        int countCpuCores = SaturativeExecutor.countCpuCores();
        return countCpuCores > 0 ? countCpuCores : Runtime.getRuntime().availableProcessors() * 2;
    }

    private static int countCpuCores() {
        try {
            return new File("/sys/devices/system/cpu/").listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return PATTERN_CPU_ENTRIES.matcher(file.getName()).matches();
                }
            }).length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    static {
        sThreadFactory = new ThreadFactory(){
            private final AtomicInteger a = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "SaturativeThread #" + this.a.getAndIncrement());
                SaturativeExecutor.collectThread(thread);
                return thread;
            }
        };
        mThreads = new HashSet();
    }

    protected static class SaturationAwareBlockingQueue<T>
    extends LinkedBlockingQueue<T> {
        private static final long serialVersionUID = 1L;
        private SaturativeExecutor mExecutor;

        public SaturationAwareBlockingQueue(int i) {
            super(i);
        }

        void setExecutor(SaturativeExecutor saturativeExecutor) {
            this.mExecutor = saturativeExecutor;
        }

        @Override
        public boolean add(T t) {
            if (!this.mExecutor.isReallyUnsaturated()) {
                return super.add(t);
            }
            throw new IllegalStateException("Unsaturated");
        }

        @Override
        public boolean offer(T t) {
            return this.mExecutor.isReallyUnsaturated() ? false : super.offer(t);
        }

        @Override
        public void put(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(T t, long j, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class CountedTask
    implements Runnable {
        static final AtomicInteger mNumRunning = new AtomicInteger();
        Runnable mRunnable;

        public CountedTask(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            mNumRunning.incrementAndGet();
            try {
                this.mRunnable.run();
            }
            finally {
                mNumRunning.decrementAndGet();
            }
        }
    }
}

