/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.app.Application;
import android.content.Intent;
import android.util.Log;
import com.openatlas.android.initializer.Utils;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.framework.BundleImpl;
import com.openatlas.framework.OpenAtlas;
import com.openatlas.framework.bundlestorage.BundleArchiveRevision;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import org.osgi.framework.Bundle;

public class OptDexProcess {
    Logger log = LoggerFactory.getInstance("OptDexProcess");
    private static OptDexProcess instance;
    private Application mApplication;
    private boolean isInitialized;
    private boolean notifyInstalled;

    OptDexProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OptDexProcess getInstance() {
        Class<OptDexProcess> clazz = OptDexProcess.class;
        synchronized (OptDexProcess.class) {
            if (instance == null) {
                instance = new OptDexProcess();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void init(Application application) {
        this.mApplication = application;
        this.isInitialized = true;
    }

    public synchronized void processPackages(boolean onlyOptAutos, boolean noNeedNotifyUI) {
        if (!this.isInitialized) {
            Log.e((String)"OptDexProcess", (String)"Bundle Installer not initialized yet, process abort!");
        } else if (!this.notifyInstalled || noNeedNotifyUI) {
            if (onlyOptAutos) {
                long currentTimeMillis = System.currentTimeMillis();
                this.runOptDexAuto();
                if (!noNeedNotifyUI) {
                    this.finishInstalled();
                }
                this.log.debug("dexopt auto start bundles cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                this.runOptDexNonDelay();
                this.log.debug("dexopt bundles not delayed cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
                if (!noNeedNotifyUI) {
                    this.finishInstalled();
                }
                currentTimeMillis = System.currentTimeMillis();
                OptDexProcess.getInstance().runOptDexDelay();
                this.log.debug("dexopt delayed bundles cost time = " + (System.currentTimeMillis() - currentTimeMillis) + " ms");
            }
            if (!noNeedNotifyUI) {
                this.notifyInstalled = true;
            }
        }
    }

    private void finishInstalled() {
        Utils.saveAtlasInfoBySharedPreferences(this.mApplication);
        System.setProperty("BUNDLES_INSTALLED", "true");
        this.mApplication.sendBroadcast(new Intent("com.openatlas.action.BUNDLES_INSTALLED"));
    }

    private void runOptDexNonDelay() {
        for (Bundle bundle : OpenAtlas.getInstance().getBundles()) {
            if (bundle == null || this.contains(AtlasConfig.STORE, bundle.getLocation())) continue;
            try {
                ((BundleImpl)bundle).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private void runOptDexDelay() {
        for (String location : AtlasConfig.STORE) {
            Bundle bundle = OpenAtlas.getInstance().getBundle(location);
            if (bundle == null) continue;
            try {
                ((BundleImpl)bundle).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private void runOptDexAuto() {
        for (String location : AtlasConfig.AUTO) {
            Bundle mBundle = OpenAtlas.getInstance().getBundle(location);
            if (mBundle == null) continue;
            try {
                ((BundleImpl)mBundle).optDexFile();
            }
            catch (Throwable e) {
                if (e instanceof BundleArchiveRevision.DexLoadException) {
                    throw (RuntimeException)e;
                }
                Log.e((String)"OptDexProcess", (String)"Error while dexopt >>>", (Throwable)e);
            }
        }
    }

    private boolean contains(String[] bundles, String bundle) {
        if (bundles == null || bundle == null) {
            return false;
        }
        for (String tmp : bundles) {
            if (tmp == null || !tmp.equals(bundle)) continue;
            return true;
        }
        return false;
    }
}

