/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.util.Log;
import com.openatlas.android.initializer.BundleDebug;
import com.openatlas.android.initializer.BundlesInstaller;
import com.openatlas.android.initializer.ClassNotFoundInterceptor;
import com.openatlas.android.initializer.InstallPolicy;
import com.openatlas.android.initializer.OptDexProcess;
import com.openatlas.android.initializer.SecurityBundleListner;
import com.openatlas.android.initializer.Utils;
import com.openatlas.android.task.Coordinator;
import com.openatlas.bundleInfo.BundleInfoList;
import com.openatlas.framework.OpenAtlas;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.Globals;
import com.openatlas.util.ApkUtils;
import java.util.Properties;

public class OpenAtlasInitializer {
    Logger log = LoggerFactory.getInstance("OpenAtlasInitializer");
    private static long initStartTime = 0L;
    private static boolean inTargetApp;
    private Application mApplication;
    private String mPackageName;
    private BundleDebug mDebug;
    private boolean tryInstall;
    private Properties mProperties = new Properties();
    private boolean isUpdate = false;

    public OpenAtlasInitializer(Application application, String packagename, boolean isUpdate) {
        this.mApplication = application;
        this.mPackageName = packagename;
        this.isUpdate = isUpdate;
        if (application.getPackageName().equals(packagename)) {
            inTargetApp = true;
        }
    }

    public void init() {
        initStartTime = System.currentTimeMillis();
        try {
            OpenAtlas.getInstance().init(this.mApplication);
            this.log.debug("OpenAtlas framework inited end " + this.mPackageName + " " + (System.currentTimeMillis() - initStartTime) + " ms");
        }
        catch (Throwable e) {
            Log.e((String)"OpenAtlasInitializer", (String)"Could not init atlas framework !!!", (Throwable)e);
            throw new RuntimeException("atlas initialization fail" + e.getMessage());
        }
    }

    public void startUp() {
        this.mProperties.put("com.openatlas.welcome.Welcome", "com.openatlas.welcome.Welcome");
        this.mProperties.put("com.openatlas.debug.bundles", "true");
        this.mProperties.put("com.openatlas.AppDirectory", this.mApplication.getFilesDir().getParent());
        try {
            Globals.init(this.mApplication, OpenAtlas.getInstance().getDelegateClassLoader());
            this.mDebug = new BundleDebug();
            if (this.mApplication.getPackageName().equals(this.mPackageName)) {
                if (!this.verifyRuntime() && ApkUtils.isRootSystem()) {
                    this.mProperties.put("com.openatlas.publickey", "");
                    OpenAtlas.getInstance().addBundleListener(new SecurityBundleListner());
                }
                if (this.isUpdate || this.mDebug.isDebugable()) {
                    this.mProperties.put("osgi.init", "true");
                }
            }
            BundlesInstaller mBundlesInstaller = BundlesInstaller.getInstance();
            OptDexProcess mOptDexProcess = OptDexProcess.getInstance();
            if (this.mApplication.getPackageName().equals(this.mPackageName) && (this.isUpdate || this.mDebug.isDebugable())) {
                mBundlesInstaller.init(this.mApplication, this.mDebug, inTargetApp);
                mOptDexProcess.init(this.mApplication);
            }
            this.log.debug("OpenAtlas framework prepare starting in process " + this.mPackageName + " " + (System.currentTimeMillis() - initStartTime) + " ms");
            OpenAtlas.getInstance().setClassNotFoundInterceptorCallback(new ClassNotFoundInterceptor());
            if (InstallPolicy.install_when_findclass && BundleInfoList.getInstance().getBundles() == null) {
                InstallPolicy.install_when_oncreate = true;
                this.tryInstall = true;
            }
            try {
                OpenAtlas.getInstance().startup(this.mProperties);
                this.installBundles(mBundlesInstaller, mOptDexProcess);
                this.log.debug("OpenAtlas framework end startUp in process " + this.mPackageName + " " + (System.currentTimeMillis() - initStartTime) + " ms");
            }
            catch (Throwable e) {
                Log.e((String)"OpenAtlasInitializer", (String)"Could not start up atlas framework !!!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not set Globals !!!", e);
        }
    }

    private void installBundles(final BundlesInstaller mBundlesInstaller, final OptDexProcess mOptDexProcess) {
        if (this.mDebug.isDebugable()) {
            InstallPolicy.install_when_oncreate = true;
        }
        if (this.mApplication.getPackageName().equals(this.mPackageName)) {
            if (InstallPolicy.install_when_oncreate) {
                // empty if block
            }
            if (this.isUpdate || this.mDebug.isDebugable()) {
                if (InstallPolicy.install_when_oncreate) {
                    Coordinator.postTask(new Coordinator.TaggedRunnable("AtlasStartup"){

                        @Override
                        public void run() {
                            mBundlesInstaller.process(true, false);
                            mOptDexProcess.processPackages(true, false);
                        }
                    });
                    return;
                }
                Utils.notifyBundleInstalled(this.mApplication);
                Utils.updatePackageVersion(this.mApplication);
                Utils.saveAtlasInfoBySharedPreferences(this.mApplication);
            } else if (!this.isUpdate) {
                if (this.tryInstall) {
                    Coordinator.postTask(new Coordinator.TaggedRunnable("AtlasStartup"){

                        @Override
                        public void run() {
                            mBundlesInstaller.process(false, false);
                            mOptDexProcess.processPackages(false, false);
                        }
                    });
                    return;
                }
                Utils.notifyBundleInstalled(this.mApplication);
            }
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private boolean verifyRuntime() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().contains("xiaomi") && Build.HARDWARE != null && Build.HARDWARE.toLowerCase().contains("mt65") || Build.VERSION.SDK_INT < 14;
    }
}

