/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.util.Log;
import android.widget.Toast;
import com.openatlas.android.initializer.BundleDebug;
import com.openatlas.android.initializer.Utils;
import com.openatlas.framework.AtlasConfig;
import com.openatlas.framework.OpenAtlas;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import com.openatlas.runtime.RuntimeVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;

public class BundlesInstaller {
    Logger log = LoggerFactory.getInstance("BundlesInstaller");
    private static boolean isTargetApp;
    private static BundlesInstaller instance;
    BundleDebug bundleDebug;
    private Application application;
    private boolean isInitialized;
    private boolean isDone;

    BundlesInstaller() {
    }

    void init(Application application, BundleDebug bundleDebug, boolean inTargetApp) {
        this.application = application;
        this.bundleDebug = bundleDebug;
        isTargetApp = inTargetApp;
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized BundlesInstaller getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<BundlesInstaller> clazz = BundlesInstaller.class;
        synchronized (BundlesInstaller.class) {
            if (instance == null) {
                instance = new BundlesInstaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(boolean onlyProcessAutos, boolean reInstall) {
        if (!this.isInitialized) {
            Log.e((String)"BundlesInstaller", (String)"Bundle Installer not initialized yet, process abort!");
        } else if (!this.isDone || reInstall) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.application.getApplicationInfo().sourceDir);
                List<String> bundleList = this.fetchBundleFileList(zipFile, "lib/" + AtlasConfig.PRELOAD_DIR + "/libcom_", ".so");
                if (bundleList != null && bundleList.size() > 0 && this.getAvailableSize() < (long)(bundleList.size() * 2 * 1024 * 1024)) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)RuntimeVariables.androidApplication, (CharSequence)"Ops  No Space ", (int)0).show();
                        }
                    });
                }
                if (onlyProcessAutos) {
                    ArrayList<String> bundles = new ArrayList<String>();
                    for (String location : bundleList) {
                        for (String replace : AtlasConfig.AUTO) {
                            if (!location.contains(replace.replace(".", "_"))) continue;
                            bundles.add(location);
                        }
                    }
                    this.processAutoStartBundles(zipFile, bundles, this.application);
                } else {
                    this.installBundle(zipFile, bundleList, this.application);
                }
                if (!reInstall) {
                    Utils.updatePackageVersion(this.application);
                }
            }
            catch (IOException e) {
                Log.e((String)"BundlesInstaller", (String)"IOException while processLibsBundles >>>", (Throwable)e);
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (reInstall) {
                    this.isDone = true;
                }
            }
            if (reInstall) {
                this.isDone = true;
            }
        }
    }

    private List<String> fetchBundleFileList(ZipFile zipFile, String prefix, String suffix) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                arrayList.add(name);
            }
        }
        catch (Throwable e) {
            Log.e((String)"BundlesInstaller", (String)"Exception while get bundles in assets or lib", (Throwable)e);
        }
        return arrayList;
    }

    private long getAvailableSize() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
    }

    public void processAutoStartBundles(ZipFile zipFile, List<String> bundles, Application application) {
        for (String location : bundles) {
            this.installBundle(zipFile, location, application);
        }
        if (isTargetApp) {
            for (String location : AtlasConfig.AUTO) {
                Bundle bundle = OpenAtlas.getInstance().getBundle(location);
                if (bundle == null) continue;
                try {
                    bundle.start();
                }
                catch (Throwable e) {
                    Log.e((String)"BundlesInstaller", (String)("Could not auto start bundle: " + bundle.getLocation()), (Throwable)e);
                }
            }
        }
    }

    private void installBundle(ZipFile zipFile, List<String> bundles, Application application) {
        for (String location : AtlasConfig.DELAY) {
            String mLocation = this.contains(bundles, location.replace(".", "_"));
            if (mLocation == null || mLocation.length() <= 0) continue;
            this.installBundle(zipFile, mLocation, application);
            bundles.remove(mLocation);
        }
        for (String location : bundles) {
            this.installBundle(zipFile, location, application);
        }
        if (isTargetApp) {
            String[] auto;
            for (String location : auto = AtlasConfig.AUTO) {
                Bundle bundle = OpenAtlas.getInstance().getBundle(location);
                if (bundle == null) continue;
                try {
                    bundle.start();
                }
                catch (Throwable e) {
                    Log.e((String)"BundlesInstaller", (String)("Could not auto start bundle: " + bundle.getLocation()), (Throwable)e);
                }
            }
        }
    }

    private String contains(List<String> bundles, String location) {
        if (bundles == null || location == null) {
            return null;
        }
        for (String mLocation : bundles) {
            if (!mLocation.contains(location)) continue;
            return mLocation;
        }
        return null;
    }

    private boolean installBundle(ZipFile zipFile, String location, Application application) {
        this.log.info("processLibsBundle entryName " + location);
        this.bundleDebug.installExternalBundle(location);
        String fileNameFromEntryName = Utils.getFileNameFromEntryName(location);
        String packageNameFromEntryName = Utils.getPackageNameFromEntryName(location);
        if (packageNameFromEntryName == null || packageNameFromEntryName.length() <= 0) {
            return false;
        }
        File archvieFile = new File(new File(application.getFilesDir().getParentFile(), "lib"), fileNameFromEntryName);
        if (OpenAtlas.getInstance().getBundle(packageNameFromEntryName) != null) {
            return false;
        }
        try {
            if (archvieFile.exists()) {
                OpenAtlas.getInstance().installBundle(packageNameFromEntryName, archvieFile);
            } else {
                OpenAtlas.getInstance().installBundle(packageNameFromEntryName, zipFile.getInputStream(zipFile.getEntry(location)));
            }
            this.log.info("Succeed to install bundle " + packageNameFromEntryName);
            return true;
        }
        catch (Throwable e) {
            Log.e((String)"BundlesInstaller", (String)"Could not install bundle.", (Throwable)e);
            return false;
        }
    }
}

