/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.initializer;

import android.os.Environment;
import android.util.Log;
import com.openatlas.android.initializer.Utils;
import com.openatlas.framework.OpenAtlas;
import com.openatlas.log.Logger;
import com.openatlas.log.LoggerFactory;
import java.io.File;
import java.util.ArrayList;

class BundleDebug {
    Logger log = LoggerFactory.getInstance("Debug");
    boolean isDebugable = false;
    private boolean isDebug = false;
    private ArrayList<String> debugBundles = new ArrayList();
    private final String debugFolder = Environment.getExternalStorageDirectory().getAbsolutePath() + "/bundle-debug";

    public boolean isDebugable() {
        if (!this.isDebug) {
            return false;
        }
        File file = new File(this.debugFolder);
        if (file.isDirectory()) {
            File[] listFiles;
            for (File mFile : listFiles = file.listFiles()) {
                if (!mFile.isFile() || !mFile.getName().endsWith(".so")) continue;
                this.debugBundles.add(mFile.getAbsolutePath());
                this.log.debug("found external bundle " + mFile.getAbsolutePath());
                this.isDebugable = true;
            }
        }
        return this.isDebugable;
    }

    public boolean installExternalBundle(String location) {
        if (!this.isDebug || this.debugBundles.size() <= 0) {
            return false;
        }
        for (String bundle : this.debugBundles) {
            this.log.debug("processLibsBundle filePath " + bundle);
            if (!bundle.contains(Utils.getFileNameFromEntryName(location).substring(3))) continue;
            File file = new File(bundle);
            String replace = Utils.getBaseFileName(file.getName()).replace("_", ".");
            if (OpenAtlas.getInstance().getBundle(replace) == null) {
                try {
                    OpenAtlas.getInstance().installBundle(replace, file);
                }
                catch (Throwable th) {
                    Log.e((String)"BundleDebug", (String)"Could not install external bundle.", (Throwable)th);
                }
                this.log.debug("Succeed to install external bundle " + replace);
            }
            file.delete();
            return true;
        }
        return false;
    }
}

