/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.compat;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import com.openatlas.runtime.Globals;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ProviderProxy
extends ContentProvider {
    ContentProvider mContentProvider;
    String mTargetProvider;

    public ProviderProxy(String mTargetProvider) {
        this.mTargetProvider = mTargetProvider;
    }

    protected ContentProvider getContentProvider() {
        if (this.mContentProvider != null) {
            return this.mContentProvider;
        }
        try {
            Class<?> loadClass = Globals.getClassLoader().loadClass(this.mTargetProvider);
            if (loadClass != null) {
                Constructor<?> constructor = loadClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.mContentProvider = (ContentProvider)constructor.newInstance(new Object[0]);
                Field declaredField = ContentProvider.class.getDeclaredField("mContext");
                declaredField.setAccessible(true);
                declaredField.set(this.mContentProvider, this.getContext());
                declaredField = ContentProvider.class.getDeclaredField("mReadPermission");
                declaredField.setAccessible(true);
                declaredField.set(this.mContentProvider, this.getReadPermission());
                declaredField = ContentProvider.class.getDeclaredField("mWritePermission");
                declaredField.setAccessible(true);
                declaredField.set(this.mContentProvider, this.getWritePermission());
                declaredField = ContentProvider.class.getDeclaredField("mPathPermissions");
                declaredField.setAccessible(true);
                declaredField.set(this.mContentProvider, this.getPathPermissions());
                this.mContentProvider.onCreate();
                return this.mContentProvider;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        ContentProvider mContentProvider = this.getContentProvider();
        if (mContentProvider != null) {
            return mContentProvider.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        return null;
    }

    public String getType(Uri uri) {
        ContentProvider mContentProvider = this.getContentProvider();
        if (mContentProvider != null) {
            return mContentProvider.getType(uri);
        }
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        ContentProvider mContentProvider = this.getContentProvider();
        if (mContentProvider != null) {
            return mContentProvider.insert(uri, contentValues);
        }
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        ContentProvider mContentProvider = this.getContentProvider();
        if (mContentProvider != null) {
            return mContentProvider.delete(uri, selection, selectionArgs);
        }
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        ContentProvider mContentProvider = this.getContentProvider();
        if (mContentProvider != null) {
            return mContentProvider.update(uri, values, selection, selectionArgs);
        }
        return 0;
    }
}

