/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.android.compat;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.openatlas.android.initializer.BundleParser;
import com.openatlas.android.initializer.OpenAtlasInitializer;
import com.openatlas.runtime.ContextImplHook;
import com.openatlas.runtime.Globals;
import com.openatlas.util.OpenAtlasUtils;
import java.lang.reflect.Field;

public class OpenAtlasApp
extends Application {
    private static final Handler mAppHandler = new Handler();
    private Context mBaseContext;
    OpenAtlasInitializer mAtlasInitializer;

    public static void runOnUiThread(Runnable runnable) {
        mAppHandler.post(runnable);
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mBaseContext = base;
        BundleParser.parser(this.getBaseContext());
        try {
            Field declaredField = Globals.class.getDeclaredField("sInstalledVersionName");
            declaredField.setAccessible(true);
            declaredField.set(null, this.mBaseContext.getPackageManager().getPackageInfo((String)base.getPackageName(), (int)0).versionName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mAtlasInitializer = new OpenAtlasInitializer(this, this.getPackageName(), this.isUpdate());
        this.mAtlasInitializer.init();
    }

    private boolean isUpdate() {
        try {
            PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            SharedPreferences sharedPreferences = this.getSharedPreferences(".openatlas_configs", 0);
            int last_version_code = sharedPreferences.getInt("last_version_code", 0);
            String last_version_name = sharedPreferences.getString("last_version_name", "");
            return packageInfo.versionCode > last_version_code || packageInfo.versionCode == last_version_code && !TextUtils.equals((CharSequence)Globals.getInstalledVersionName(), (CharSequence)last_version_name);
        }
        catch (Throwable e) {
            Log.e((String)"OpenAtlasInitializer", (String)"Error to get PackageInfo >>>", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void onCreate() {
        super.onCreate();
        this.mAtlasInitializer.startUp();
    }

    public final boolean bindService(Intent intent, ServiceConnection serviceConnection, int flags) {
        return new ContextImplHook(this.getBaseContext(), null).bindService(intent, serviceConnection, flags);
    }

    public final void startActivity(Intent intent) {
        new ContextImplHook(this.getBaseContext(), this.getClassLoader()).startActivity(intent);
    }

    public final ComponentName startService(Intent intent) {
        return new ContextImplHook(this.getBaseContext(), null).startService(intent);
    }

    public final SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory cursorFactory) {
        String processName = OpenAtlasUtils.getProcessNameByPID(Process.myPid());
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            String[] split;
            Log.i((String)"SQLiteDatabase", (String)processName);
            if (!processName.equals(this.getPackageName()) && (split = processName.split(":")) != null && split.length > 1) {
                processName = split[1] + "_" + name;
                Log.i((String)"SQLiteDatabase", (String)("openOrCreateDatabase:" + processName));
                return this.hookDatabase(processName, mode, cursorFactory);
            }
        }
        return this.hookDatabase(name, mode, cursorFactory);
    }

    private SQLiteDatabase hookDatabase(String name, int mode, SQLiteDatabase.CursorFactory cursorFactory) {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.openOrCreateDatabase(name, mode, cursorFactory);
        }
        SQLiteDatabase sQLiteDatabase = null;
        try {
            return super.openOrCreateDatabase(name, mode, cursorFactory);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
            if (Globals.getApplication().deleteDatabase(name)) {
                return super.openOrCreateDatabase(name, mode, cursorFactory);
            }
            return sQLiteDatabase;
        }
    }
}

