/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.content.pm.ApplicationInfo;
import android.content.pm.Signature;
import android.util.Log;
import com.openatlas.util.ManifestDigest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PackageValidate {
    public static final int INSTALL_PARSE_FAILED_UNEXPECTED_EXCEPTION = -102;
    public static final int INSTALL_PARSE_FAILED_NO_CERTIFICATES = -103;
    public static final int INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES = -104;
    public static final int INSTALL_PARSE_FAILED_CERTIFICATE_ENCODING = -105;
    private static final boolean DEBUG_JAR = false;
    private static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private String mArchiveSourcePath;
    private int mParseError = 0;
    private static final Object mSync = new Object();
    private static WeakReference<byte[]> mReadBuffer;
    private static final String TAG = "PackageValidate";

    public PackageValidate(String archiveSourcePath) {
        this.mArchiveSourcePath = archiveSourcePath;
    }

    public Package parsePackage() {
        Package pkg = new Package("");
        pkg.mPath = this.mArchiveSourcePath;
        return pkg;
    }

    public static Certificate[] loadCertificates(JarFile jarFile, JarEntry je, byte[] readBuffer) {
        try {
            BufferedInputStream is = new BufferedInputStream(jarFile.getInputStream(je));
            while (((InputStream)is).read(readBuffer, 0, readBuffer.length) != -1) {
            }
            ((InputStream)is).close();
            return je != null ? je.getCertificates() : null;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Exception reading " + je.getName() + " in " + jarFile.getName()), (Throwable)e);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)("Exception reading " + je.getName() + " in " + jarFile.getName()), (Throwable)e);
        }
        return null;
    }

    public boolean isSignaturesSame(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        HashSet<Signature> set1 = new HashSet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        HashSet<Signature> set2 = new HashSet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        return set1.equals(set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectCertificates() {
        block20: {
            WeakReference<byte[]> readBufferRef;
            Package pkg = this.parsePackage();
            pkg.mSignatures = null;
            byte[] readBuffer = null;
            Object object = mSync;
            synchronized (object) {
                readBufferRef = mReadBuffer;
                if (readBufferRef != null) {
                    mReadBuffer = null;
                    readBuffer = (byte[])readBufferRef.get();
                }
                if (readBuffer == null) {
                    readBuffer = new byte[8192];
                    readBufferRef = new WeakReference<byte[]>(readBuffer);
                }
            }
            try {
                JarFile jarFile = new JarFile(this.mArchiveSourcePath);
                Certificate[] certs = null;
                Object entries = jarFile.entries();
                Manifest manifest = jarFile.getManifest();
                while (entries.hasMoreElements()) {
                    Certificate[] localCerts;
                    String name;
                    JarEntry je = entries.nextElement();
                    if (je.isDirectory() || (name = je.getName()).startsWith("META-INF/")) continue;
                    if (ANDROID_MANIFEST_FILENAME.equals(name)) {
                        Attributes attributes = manifest.getAttributes(name);
                        pkg.manifestDigest = ManifestDigest.fromAttributes(attributes);
                    }
                    if ((localCerts = PackageValidate.loadCertificates(jarFile, je, readBuffer)) == null) {
                        Log.e((String)TAG, (String)("Package " + pkg.packageName + " has no certificates at entry " + je.getName() + "; ignoring!"));
                        jarFile.close();
                        this.mParseError = -103;
                        return false;
                    }
                    if (certs == null) {
                        certs = localCerts;
                        continue;
                    }
                    for (int i = 0; i < certs.length; ++i) {
                        boolean found = false;
                        for (int j = 0; j < localCerts.length; ++j) {
                            if (certs[i] == null || !certs[i].equals(localCerts[j])) continue;
                            found = true;
                            break;
                        }
                        if (found && certs.length == localCerts.length) continue;
                        Log.e((String)TAG, (String)("Package " + pkg.packageName + " has mismatched certificates at entry " + je.getName() + "; ignoring!"));
                        jarFile.close();
                        this.mParseError = -104;
                        return false;
                    }
                }
                jarFile.close();
                entries = mSync;
                synchronized (entries) {
                    mReadBuffer = readBufferRef;
                }
                if (certs != null && certs.length > 0) {
                    int N = certs.length;
                    pkg.mSignatures = new Signature[certs.length];
                    for (int i = 0; i < N; ++i) {
                        pkg.mSignatures[i] = new Signature(certs[i].getEncoded());
                    }
                    break block20;
                }
                Log.e((String)TAG, (String)("Package " + pkg.packageName + " has no certificates; ignoring!"));
                this.mParseError = -103;
                return false;
            }
            catch (CertificateEncodingException e) {
                Log.w((String)TAG, (String)("Exception reading " + this.mArchiveSourcePath), (Throwable)e);
                this.mParseError = -105;
                return false;
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Exception reading " + this.mArchiveSourcePath), (Throwable)e);
                this.mParseError = -105;
                return false;
            }
            catch (RuntimeException e) {
                Log.w((String)TAG, (String)("Exception reading " + this.mArchiveSourcePath), (Throwable)e);
                this.mParseError = -102;
                return false;
            }
        }
        return true;
    }

    public static final class Package {
        public String packageName;
        public final ApplicationInfo applicationInfo = new ApplicationInfo();
        public String mPath;
        public Signature[] mSignatures;
        public ManifestDigest manifestDigest;

        public Package(String _name) {
            this.packageName = _name;
            this.applicationInfo.packageName = _name;
            this.applicationInfo.uid = -1;
        }
    }
}

