/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.app.ActivityManager;
import android.os.Process;
import android.util.Log;
import com.openatlas.runtime.RuntimeVariables;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;

public class OpenAtlasFileLock {
    private static final String TAG = "OpenAtlasFileLock";
    private static String processName;
    private static OpenAtlasFileLock singleton;
    private Map<String, FileLockCount> mRefCountMap = new HashMap<String, FileLockCount>();

    public static OpenAtlasFileLock getInstance() {
        if (singleton == null) {
            singleton = new OpenAtlasFileLock();
        }
        return singleton;
    }

    private int RefCntInc(String filePath, FileLock fileLock) {
        Integer valueOf;
        Integer.valueOf(0);
        if (this.mRefCountMap.containsKey(filePath)) {
            FileLockCount fileLockCount = this.mRefCountMap.get(filePath);
            int i = fileLockCount.mRefCount;
            fileLockCount.mRefCount = i + 1;
            valueOf = i;
        } else {
            valueOf = 1;
            this.mRefCountMap.put(filePath, new FileLockCount(fileLock, valueOf));
        }
        return valueOf;
    }

    private int RefCntDec(String filePath) {
        Integer valueOf = 0;
        if (this.mRefCountMap.containsKey(filePath)) {
            int i;
            FileLockCount fileLockCount = this.mRefCountMap.get(filePath);
            fileLockCount.mRefCount = i = fileLockCount.mRefCount - 1;
            valueOf = i;
            if (valueOf <= 0) {
                this.mRefCountMap.remove(filePath);
            }
        }
        return valueOf;
    }

    public boolean LockExclusive(File file) {
        if (file == null) {
            return false;
        }
        try {
            FileChannel channel = new RandomAccessFile(file.getAbsolutePath(), "rw").getChannel();
            if (channel == null) {
                return false;
            }
            Log.i((String)TAG, (String)(processName + " attempting to FileLock " + file));
            FileLock lock = channel.lock();
            if (!lock.isValid()) {
                return false;
            }
            this.RefCntInc(file.getAbsolutePath(), lock);
            Log.i((String)TAG, (String)(processName + " FileLock " + file + " Suc! "));
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(processName + " FileLock " + file + " FAIL! " + e.getMessage()));
            return false;
        }
    }

    public void unLock(File file) {
        FileLock fileLock;
        if ((file == null || this.mRefCountMap.containsKey(file.getAbsolutePath())) && (fileLock = this.mRefCountMap.get((Object)file.getAbsolutePath()).mFileLock) != null && fileLock.isValid()) {
            try {
                if (this.RefCntDec(file.getAbsolutePath()) <= 0) {
                    fileLock.release();
                    Log.i((String)TAG, (String)(processName + " FileLock " + file.getAbsolutePath() + " SUC! "));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        int myPid = Process.myPid();
        if (RuntimeVariables.androidApplication.getApplicationContext() != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)RuntimeVariables.androidApplication.getApplicationContext().getSystemService("activity")).getRunningAppProcesses()) {
                if (runningAppProcessInfo.pid != myPid) continue;
                processName = runningAppProcessInfo.processName;
            }
        }
    }

    private class FileLockCount {
        FileLock mFileLock;
        int mRefCount;

        FileLockCount(FileLock mFileLock, int mRefCount) {
            this.mFileLock = mFileLock;
            this.mRefCount = mRefCount;
        }
    }
}

