/*
 * Decompiled with CFR 0.152.
 */
package com.openatlas.util;

import android.annotation.TargetApi;
import android.util.Base64;
import java.util.Arrays;
import java.util.jar.Attributes;

public class ManifestDigest {
    private final byte[] mDigest;
    private static final String[] DIGEST_TYPES = new String[]{"SHA1-Digest", "SHA-Digest", "MD5-Digest"};
    private static final String TO_STRING_PREFIX = "ManifestDigest {mDigest=";

    ManifestDigest(byte[] digest) {
        this.mDigest = digest;
    }

    @TargetApi(value=8)
    static ManifestDigest fromAttributes(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        String encodedDigest = null;
        for (int i = 0; i < DIGEST_TYPES.length; ++i) {
            String value = attributes.getValue(DIGEST_TYPES[i]);
            if (value == null) continue;
            encodedDigest = value;
            break;
        }
        if (encodedDigest == null) {
            return null;
        }
        byte[] digest = Base64.decode(encodedDigest, (int)0);
        return new ManifestDigest(digest);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestDigest)) {
            return false;
        }
        ManifestDigest other = (ManifestDigest)o;
        return this == other || Arrays.equals(this.mDigest, other.mDigest);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mDigest);
    }
}

